/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.primitives.ImmutableLongArray;
import io.trino.Session;
import io.trino.execution.StageId;
import io.trino.execution.scheduler.faulttolerant.EventDrivenFaultTolerantQueryScheduler;
import io.trino.execution.scheduler.faulttolerant.OutputDataSizeEstimator;
import io.trino.execution.scheduler.faulttolerant.OutputDataSizeEstimatorFactory;
import java.util.Optional;
import java.util.function.Function;

public class ByEagerParentOutputDataSizeEstimator
implements OutputDataSizeEstimator {
    @Override
    public Optional<OutputDataSizeEstimator.OutputDataSizeEstimateResult> getEstimatedOutputDataSize(EventDrivenFaultTolerantQueryScheduler.StageExecution stageExecution, Function<StageId, EventDrivenFaultTolerantQueryScheduler.StageExecution> stageExecutionLookup, boolean parentEager) {
        if (!parentEager) {
            return Optional.empty();
        }
        int outputPartitionsCount = stageExecution.getSinkPartitioningScheme().getPartitionCount();
        ImmutableLongArray.Builder estimateBuilder = ImmutableLongArray.builder((int)outputPartitionsCount);
        for (int i = 0; i < outputPartitionsCount; ++i) {
            estimateBuilder.add(0L);
        }
        return Optional.of(new OutputDataSizeEstimator.OutputDataSizeEstimateResult(estimateBuilder.build(), OutputDataSizeEstimator.OutputDataSizeEstimateStatus.ESTIMATED_FOR_EAGER_PARENT));
    }

    public static class Factory
    implements OutputDataSizeEstimatorFactory {
        @Override
        public OutputDataSizeEstimator create(Session session) {
            return new ByEagerParentOutputDataSizeEstimator();
        }
    }
}

