/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.connector.informationschema.InformationSchemaTableHandle;
import io.trino.connector.system.SystemTableHandle;
import io.trino.execution.scheduler.faulttolerant.NoMemoryPartitionMemoryEstimator;
import io.trino.execution.scheduler.faulttolerant.PartitionMemoryEstimator;
import io.trino.execution.scheduler.faulttolerant.PartitionMemoryEstimatorFactory;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class NoMemoryAwarePartitionMemoryEstimator {

    public static class Factory
    implements PartitionMemoryEstimatorFactory {
        private final PartitionMemoryEstimatorFactory delegateFactory;

        @Inject
        public Factory(@ForNoMemoryAwarePartitionMemoryEstimator PartitionMemoryEstimatorFactory delegateFactory) {
            this.delegateFactory = Objects.requireNonNull(delegateFactory, "delegateFactory is null");
        }

        @Override
        public PartitionMemoryEstimator createPartitionMemoryEstimator(Session session, PlanFragment planFragment, Function<PlanFragmentId, PlanFragment> sourceFragmentLookup) {
            if (this.isNoMemoryFragment(planFragment, sourceFragmentLookup)) {
                return NoMemoryPartitionMemoryEstimator.INSTANCE;
            }
            return this.delegateFactory.createPartitionMemoryEstimator(session, planFragment, sourceFragmentLookup);
        }

        private boolean isNoMemoryFragment(PlanFragment fragment, Function<PlanFragmentId, PlanFragment> childFragmentLookup) {
            if (fragment.getRoot().getSources().stream().anyMatch(planNode -> planNode instanceof RefreshMaterializedViewNode)) {
                return true;
            }
            if (!fragment.getRemoteSourceNodes().stream().flatMap(node -> node.getSourceFragmentIds().stream()).allMatch(sourceFragmentId -> this.isNoMemoryFragment((PlanFragment)childFragmentLookup.apply((PlanFragmentId)sourceFragmentId), childFragmentLookup))) {
                return false;
            }
            List tableScanNodes = PlanNodeSearcher.searchFrom(fragment.getRoot()).whereIsInstanceOfAny(TableScanNode.class).findAll();
            return tableScanNodes.stream().allMatch(node -> Factory.isMetadataTableScan((TableScanNode)node));
        }

        private static boolean isMetadataTableScan(TableScanNode tableScanNode) {
            return tableScanNode.getTable().getConnectorHandle() instanceof InformationSchemaTableHandle || tableScanNode.getTable().getCatalogHandle().getCatalogName().equals("system") && tableScanNode.getTable().getConnectorHandle() instanceof SystemTableHandle;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForNoMemoryAwarePartitionMemoryEstimator {
    }
}

