/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.primitives.Shorts;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.json.ir.TypedValue;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;

public final class SqlJsonLiteralConverter {
    private SqlJsonLiteralConverter() {
    }

    public static Optional<TypedValue> getTypedValue(JsonNode jsonNode) {
        if (jsonNode.getNodeType() == JsonNodeType.BOOLEAN) {
            return Optional.of(new TypedValue((Type)BooleanType.BOOLEAN, jsonNode.booleanValue()));
        }
        if (jsonNode.getNodeType() == JsonNodeType.STRING) {
            return Optional.of(new TypedValue((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)jsonNode.textValue())));
        }
        return SqlJsonLiteralConverter.getNumericTypedValue(jsonNode);
    }

    public static Optional<TypedValue> getTextTypedValue(JsonNode jsonNode) {
        if (jsonNode.getNodeType() == JsonNodeType.STRING) {
            return Optional.of(new TypedValue((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)jsonNode.textValue())));
        }
        return Optional.empty();
    }

    public static Optional<TypedValue> getNumericTypedValue(JsonNode jsonNode) {
        if (jsonNode.getNodeType() == JsonNodeType.NUMBER) {
            if (jsonNode instanceof BigIntegerNode) {
                if (jsonNode.canConvertToInt()) {
                    return Optional.of(new TypedValue((Type)IntegerType.INTEGER, jsonNode.longValue()));
                }
                if (jsonNode.canConvertToLong()) {
                    return Optional.of(new TypedValue((Type)BigintType.BIGINT, jsonNode.longValue()));
                }
                throw new JsonLiteralConversionException(jsonNode, "value too big");
            }
            if (jsonNode instanceof DecimalNode) {
                BigDecimal jsonDecimal = jsonNode.decimalValue();
                int precision = jsonDecimal.precision();
                if (precision > 38) {
                    throw new JsonLiteralConversionException(jsonNode, "precision too big");
                }
                int scale = jsonDecimal.scale();
                DecimalType decimalType = DecimalType.createDecimalType((int)precision, (int)scale);
                Object value = decimalType.isShort() ? Long.valueOf(Decimals.encodeShortScaledValue((BigDecimal)jsonDecimal, (int)scale)) : Decimals.encodeScaledValue((BigDecimal)jsonDecimal, (int)scale);
                return Optional.of(TypedValue.fromValueAsObject((Type)decimalType, value));
            }
            if (jsonNode instanceof DoubleNode) {
                return Optional.of(new TypedValue((Type)DoubleType.DOUBLE, jsonNode.doubleValue()));
            }
            if (jsonNode instanceof FloatNode) {
                return Optional.of(new TypedValue((Type)RealType.REAL, Float.floatToRawIntBits(jsonNode.floatValue())));
            }
            if (jsonNode instanceof IntNode) {
                return Optional.of(new TypedValue((Type)IntegerType.INTEGER, jsonNode.longValue()));
            }
            if (jsonNode instanceof LongNode) {
                return Optional.of(new TypedValue((Type)BigintType.BIGINT, jsonNode.longValue()));
            }
            if (jsonNode instanceof ShortNode) {
                return Optional.of(new TypedValue((Type)SmallintType.SMALLINT, jsonNode.longValue()));
            }
        }
        return Optional.empty();
    }

    public static Optional<JsonNode> getJsonNode(TypedValue typedValue) {
        Type type = typedValue.getType();
        if (type.equals(BooleanType.BOOLEAN)) {
            return Optional.of(BooleanNode.valueOf((boolean)typedValue.getBooleanValue()));
        }
        if (type instanceof CharType) {
            return Optional.of(TextNode.valueOf((String)Chars.padSpaces((Slice)((Slice)typedValue.getObjectValue()), (CharType)((CharType)typedValue.getType())).toStringUtf8()));
        }
        if (type instanceof VarcharType) {
            return Optional.of(TextNode.valueOf((String)((Slice)typedValue.getObjectValue()).toStringUtf8()));
        }
        if (type.equals(BigintType.BIGINT)) {
            return Optional.of(LongNode.valueOf((long)typedValue.getLongValue()));
        }
        if (type.equals(IntegerType.INTEGER)) {
            return Optional.of(IntNode.valueOf((int)Math.toIntExact(typedValue.getLongValue())));
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return Optional.of(ShortNode.valueOf((short)Shorts.checkedCast((long)typedValue.getLongValue())));
        }
        if (type.equals(TinyintType.TINYINT)) {
            return Optional.of(ShortNode.valueOf((short)Shorts.checkedCast((long)typedValue.getLongValue())));
        }
        if (type instanceof DecimalType) {
            BigInteger unscaledValue = ((DecimalType)type).isShort() ? BigInteger.valueOf(typedValue.getLongValue()) : ((Int128)typedValue.getObjectValue()).toBigInteger();
            return Optional.of(DecimalNode.valueOf((BigDecimal)new BigDecimal(unscaledValue, ((DecimalType)type).getScale())));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return Optional.of(DoubleNode.valueOf((double)typedValue.getDoubleValue()));
        }
        if (type.equals(RealType.REAL)) {
            return Optional.of(FloatNode.valueOf((float)Float.intBitsToFloat(Math.toIntExact(typedValue.getLongValue()))));
        }
        return Optional.empty();
    }

    public static class JsonLiteralConversionException
    extends TrinoException {
        public JsonLiteralConversionException(JsonNode jsonNode, String message) {
            super((ErrorCodeSupplier)StandardErrorCode.INVALID_JSON_LITERAL, String.format("cannot convert %s to Trino value (%s)", jsonNode, message));
        }
    }
}

