/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.UndeclaredDependencyException;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InternalFunctionDependencies
implements FunctionDependencies {
    private final BiFunction<ResolvedFunction, InvocationConvention, ScalarFunctionImplementation> specialization;
    private final Map<TypeSignature, Type> types;
    private final Map<FunctionKey, ResolvedFunction> functions;
    private final Map<OperatorKey, ResolvedFunction> operators;
    private final Map<CastKey, ResolvedFunction> casts;

    public InternalFunctionDependencies(BiFunction<ResolvedFunction, InvocationConvention, ScalarFunctionImplementation> specialization, Map<TypeSignature, Type> typeDependencies, Collection<ResolvedFunction> functionDependencies) {
        Objects.requireNonNull(specialization, "specialization is null");
        Objects.requireNonNull(typeDependencies, "typeDependencies is null");
        Objects.requireNonNull(functionDependencies, "functionDependencies is null");
        this.specialization = specialization;
        this.types = ImmutableMap.copyOf(typeDependencies);
        this.functions = (Map)functionDependencies.stream().filter(function -> !OperatorNameUtil.isOperatorName(function.getSignature().getName().getFunctionName())).collect(ImmutableMap.toImmutableMap(FunctionKey::new, Function.identity()));
        this.operators = (Map)functionDependencies.stream().filter(InternalFunctionDependencies::isOperator).collect(ImmutableMap.toImmutableMap(OperatorKey::new, Function.identity()));
        this.casts = (Map)functionDependencies.stream().filter(InternalFunctionDependencies::isCast).collect(ImmutableMap.toImmutableMap(CastKey::new, Function.identity()));
    }

    public Type getType(TypeSignature typeSignature) {
        Type type = this.types.get(typeSignature);
        if (type == null) {
            throw new UndeclaredDependencyException(typeSignature.toString());
        }
        return type;
    }

    public FunctionNullability getFunctionNullability(CatalogSchemaFunctionName name, List<Type> parameterTypes) {
        FunctionKey functionKey = new FunctionKey(name, InternalFunctionDependencies.toTypeSignatures(parameterTypes));
        ResolvedFunction resolvedFunction = this.functions.get(functionKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(functionKey.toString());
        }
        return resolvedFunction.getFunctionNullability();
    }

    public FunctionNullability getOperatorNullability(OperatorType operatorType, List<Type> parameterTypes) {
        OperatorKey operatorKey = new OperatorKey(operatorType, InternalFunctionDependencies.toTypeSignatures(parameterTypes));
        ResolvedFunction resolvedFunction = this.operators.get(operatorKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(operatorKey.toString());
        }
        return resolvedFunction.getFunctionNullability();
    }

    public FunctionNullability getCastNullability(Type fromType, Type toType) {
        CastKey castKey = new CastKey(fromType.getTypeSignature(), toType.getTypeSignature());
        ResolvedFunction resolvedFunction = this.casts.get(castKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(castKey.toString());
        }
        return resolvedFunction.getFunctionNullability();
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(CatalogSchemaFunctionName name, List<Type> parameterTypes, InvocationConvention invocationConvention) {
        FunctionKey functionKey = new FunctionKey(name, InternalFunctionDependencies.toTypeSignatures(parameterTypes));
        ResolvedFunction resolvedFunction = this.functions.get(functionKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(functionKey.toString());
        }
        return this.specialization.apply(resolvedFunction, invocationConvention);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementationSignature(CatalogSchemaFunctionName name, List<TypeSignature> parameterTypes, InvocationConvention invocationConvention) {
        FunctionKey functionKey = new FunctionKey(name, parameterTypes);
        ResolvedFunction resolvedFunction = this.functions.get(functionKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(functionKey.toString());
        }
        return this.specialization.apply(resolvedFunction, invocationConvention);
    }

    public ScalarFunctionImplementation getOperatorImplementation(OperatorType operatorType, List<Type> parameterTypes, InvocationConvention invocationConvention) {
        OperatorKey operatorKey = new OperatorKey(operatorType, InternalFunctionDependencies.toTypeSignatures(parameterTypes));
        ResolvedFunction resolvedFunction = this.operators.get(operatorKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(operatorKey.toString());
        }
        return this.specialization.apply(resolvedFunction, invocationConvention);
    }

    public ScalarFunctionImplementation getOperatorImplementationSignature(OperatorType operatorType, List<TypeSignature> parameterTypes, InvocationConvention invocationConvention) {
        OperatorKey operatorKey = new OperatorKey(operatorType, parameterTypes);
        ResolvedFunction resolvedFunction = this.operators.get(operatorKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(operatorKey.toString());
        }
        return this.specialization.apply(resolvedFunction, invocationConvention);
    }

    public ScalarFunctionImplementation getCastImplementation(Type fromType, Type toType, InvocationConvention invocationConvention) {
        CastKey castKey = new CastKey(fromType.getTypeSignature(), toType.getTypeSignature());
        ResolvedFunction resolvedFunction = this.casts.get(castKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(castKey.toString());
        }
        return this.specialization.apply(resolvedFunction, invocationConvention);
    }

    public ScalarFunctionImplementation getCastImplementationSignature(TypeSignature fromType, TypeSignature toType, InvocationConvention invocationConvention) {
        CastKey castKey = new CastKey(fromType, toType);
        ResolvedFunction resolvedFunction = this.casts.get(castKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(castKey.toString());
        }
        return this.specialization.apply(resolvedFunction, invocationConvention);
    }

    private static List<TypeSignature> toTypeSignatures(List<Type> types) {
        return (List)types.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
    }

    private static boolean isOperator(ResolvedFunction function) {
        CatalogSchemaFunctionName name = function.getSignature().getName();
        return GlobalFunctionCatalog.isBuiltinFunctionName(name) && OperatorNameUtil.isOperatorName(name.getFunctionName()) && OperatorNameUtil.unmangleOperator(name.getFunctionName()) != OperatorType.CAST;
    }

    private static boolean isCast(ResolvedFunction function) {
        CatalogSchemaFunctionName name = function.getSignature().getName();
        return GlobalFunctionCatalog.isBuiltinFunctionName(name) && OperatorNameUtil.isOperatorName(name.getFunctionName()) && OperatorNameUtil.unmangleOperator(name.getFunctionName()) == OperatorType.CAST;
    }

    public static final class FunctionKey {
        private final CatalogSchemaFunctionName name;
        private final List<TypeSignature> argumentTypes;

        private FunctionKey(ResolvedFunction resolvedFunction) {
            this.name = resolvedFunction.getSignature().getName();
            this.argumentTypes = (List)resolvedFunction.getSignature().getArgumentTypes().stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
        }

        private FunctionKey(CatalogSchemaFunctionName name, List<TypeSignature> argumentTypes) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argumentTypes);
        }

        public String toString() {
            return this.name + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    public static final class OperatorKey {
        private final OperatorType operatorType;
        private final List<TypeSignature> argumentTypes;

        private OperatorKey(ResolvedFunction resolvedFunction) {
            this.operatorType = OperatorNameUtil.unmangleOperator(resolvedFunction.getSignature().getName().getFunctionName());
            this.argumentTypes = InternalFunctionDependencies.toTypeSignatures(resolvedFunction.getSignature().getArgumentTypes());
        }

        private OperatorKey(OperatorType operatorType, List<TypeSignature> argumentTypes) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorKey that = (OperatorKey)o;
            return this.operatorType == that.operatorType && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.operatorType, this.argumentTypes);
        }

        public String toString() {
            return this.operatorType + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    private static final class CastKey {
        private final TypeSignature fromType;
        private final TypeSignature toType;

        private CastKey(ResolvedFunction resolvedFunction) {
            this.fromType = ((Type)resolvedFunction.getSignature().getArgumentTypes().get(0)).getTypeSignature();
            this.toType = resolvedFunction.getSignature().getReturnType().getTypeSignature();
        }

        private CastKey(TypeSignature fromType, TypeSignature toType) {
            this.fromType = fromType;
            this.toType = toType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CastKey that = (CastKey)o;
            return Objects.equals(this.fromType, that.fromType) && Objects.equals(this.toType, that.toType);
        }

        public int hashCode() {
            return Objects.hash(this.fromType, this.toType);
        }

        public String toString() {
            return String.format("cast(%s, %s)", this.fromType, this.toType);
        }
    }
}

