/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.client.NodeVersion;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.AnalyzeMetadata;
import io.trino.metadata.AnalyzeTableHandle;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.BuiltinFunctionResolver;
import io.trino.metadata.CatalogFunctionMetadata;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.CatalogMetadata;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MergeHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.ResolvedIndex;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableFunctionHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TableSchema;
import io.trino.metadata.TableVersion;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.metadata.ViewInfo;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorResolvedIndex;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.AggregationFunctionMetadata;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.Signature;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.ConnectorExpressions;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.tree.QualifiedName;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import io.trino.type.TypeCoercion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MetadataManager
implements Metadata {
    private static final Logger log = Logger.get(MetadataManager.class);
    @VisibleForTesting
    public static final int MAX_TABLE_REDIRECTIONS = 10;
    private final GlobalFunctionCatalog functions;
    private final BuiltinFunctionResolver functionResolver;
    private final SystemSecurityMetadata systemSecurityMetadata;
    private final TransactionManager transactionManager;
    private final LanguageFunctionManager languageFunctionManager;
    private final TypeManager typeManager;
    private final TypeCoercion typeCoercion;
    private final ConcurrentMap<QueryId, QueryCatalogs> catalogsByQueryId = new ConcurrentHashMap<QueryId, QueryCatalogs>();
    private final ResolvedFunction.ResolvedFunctionDecoder functionDecoder;

    @Inject
    public MetadataManager(SystemSecurityMetadata systemSecurityMetadata, TransactionManager transactionManager, GlobalFunctionCatalog globalFunctionCatalog, LanguageFunctionManager languageFunctionManager, TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functions = Objects.requireNonNull(globalFunctionCatalog, "globalFunctionCatalog is null");
        this.functionDecoder = new ResolvedFunction.ResolvedFunctionDecoder(arg_0 -> ((TypeManager)typeManager).getType(arg_0));
        this.functionResolver = new BuiltinFunctionResolver(this, typeManager, globalFunctionCatalog, this.functionDecoder);
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)typeManager).getType(arg_0));
        this.systemSecurityMetadata = Objects.requireNonNull(systemSecurityMetadata, "systemSecurityMetadata is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.languageFunctionManager = Objects.requireNonNull(languageFunctionManager, "languageFunctionManager is null");
    }

    @Override
    public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogHandle catalogHandle) {
        return this.getCatalogMetadata(session, catalogHandle).getConnectorCapabilities();
    }

    @Override
    public boolean catalogExists(Session session, String catalogName) {
        return this.getOptionalCatalogMetadata(session, catalogName).isPresent();
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, schema.getCatalogName());
        if (catalog.isEmpty()) {
            return false;
        }
        CatalogMetadata catalogMetadata = catalog.get();
        ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogHandle());
        return catalogMetadata.listCatalogHandles().stream().map(catalogName -> catalogMetadata.getMetadataFor(session, (CatalogHandle)catalogName)).anyMatch(metadata -> metadata.schemaExists(connectorSession, schema.getSchemaName()));
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogHandle());
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                metadata.listSchemaNames(connectorSession).stream().map(schema -> schema.toLowerCase(Locale.ENGLISH)).filter(schema -> !MetadataManager.isExternalInformationSchema(catalogHandle, schema)).forEach(arg_0 -> ((ImmutableSet.Builder)schemaNames).add(arg_0));
            }
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table) {
        return this.getTableHandle(session, table, Optional.empty(), Optional.empty());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        Objects.requireNonNull(table, "table is null");
        if (MetadataManager.cannotExist(table)) {
            return Optional.empty();
        }
        return this.getOptionalCatalogMetadata(session, table.getCatalogName()).flatMap(catalogMetadata -> {
            CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle(session, table);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
            ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
            ConnectorTableHandle tableHandle = metadata.getTableHandle(connectorSession, table.asSchemaTableName(), this.toConnectorVersion(startVersion), this.toConnectorVersion(endVersion));
            return Optional.ofNullable(tableHandle).map(connectorTableHandle -> new TableHandle(catalogHandle, (ConnectorTableHandle)connectorTableHandle, catalogMetadata.getTransactionHandleFor(catalogHandle)));
        });
    }

    @Override
    public Optional<TableExecuteHandle> getTableHandleForExecute(Session session, TableHandle tableHandle, String procedure, Map<String, Object> executeProperties) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(procedure, "procedure is null");
        Objects.requireNonNull(executeProperties, "executeProperties is null");
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        Optional executeHandle = metadata.getTableHandleForExecute(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), procedure, executeProperties, SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return executeHandle.map(handle -> new TableExecuteHandle(catalogHandle, tableHandle.getTransaction(), (ConnectorTableExecuteHandle)handle));
    }

    @Override
    public Optional<TableLayout> getLayoutForTableExecute(Session session, TableExecuteHandle tableExecuteHandle) {
        CatalogHandle catalogHandle = tableExecuteHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.getLayoutForTableExecute(session.toConnectorSession(catalogHandle), tableExecuteHandle.getConnectorHandle()).map(layout -> new TableLayout(catalogHandle, catalogMetadata.getTransactionHandleFor(catalogHandle), (ConnectorTableLayout)layout));
    }

    @Override
    public BeginTableExecuteResult<TableExecuteHandle, TableHandle> beginTableExecute(Session session, TableExecuteHandle tableExecuteHandle, TableHandle sourceHandle) {
        CatalogHandle catalogHandle = tableExecuteHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        BeginTableExecuteResult connectorBeginResult = metadata.beginTableExecute(session.toConnectorSession(), tableExecuteHandle.getConnectorHandle(), sourceHandle.getConnectorHandle());
        return new BeginTableExecuteResult((Object)tableExecuteHandle.withConnectorHandle((ConnectorTableExecuteHandle)connectorBeginResult.getTableExecuteHandle()), (Object)sourceHandle.withConnectorHandle((ConnectorTableHandle)connectorBeginResult.getSourceHandle()));
    }

    @Override
    public void finishTableExecute(Session session, TableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> tableExecuteState) {
        CatalogHandle catalogHandle = tableExecuteHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        metadata.finishTableExecute(session.toConnectorSession(catalogHandle), tableExecuteHandle.getConnectorHandle(), fragments, tableExecuteState);
    }

    @Override
    public void executeTableExecute(Session session, TableExecuteHandle tableExecuteHandle) {
        CatalogHandle catalogHandle = tableExecuteHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        metadata.executeTableExecute(session.toConnectorSession(catalogHandle), tableExecuteHandle.getConnectorHandle());
    }

    @Override
    public Optional<SystemTable> getSystemTable(Session session, QualifiedObjectName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
            return metadata.getSystemTable(session.toConnectorSession(catalogHandle), tableName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public TableProperties getTableProperties(Session session, TableHandle handle) {
        CatalogHandle catalogHandle = handle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return new TableProperties(catalogHandle, handle.getTransaction(), metadata.getTableProperties(connectorSession, handle.getConnectorHandle()));
    }

    @Override
    public TableHandle makeCompatiblePartitioning(Session session, TableHandle tableHandle, PartitioningHandle partitioningHandle) {
        Preconditions.checkArgument((boolean)partitioningHandle.getCatalogHandle().isPresent(), (Object)"Expect partitioning handle from connector, got system partitioning handle");
        CatalogHandle catalogHandle = partitioningHandle.getCatalogHandle().get();
        Preconditions.checkArgument((boolean)catalogHandle.equals((Object)tableHandle.getCatalogHandle()), (Object)"ConnectorId of tableHandle and partitioningHandle does not match");
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogHandle);
        ConnectorTableHandle newTableHandle = metadata.makeCompatiblePartitioning(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), partitioningHandle.getConnectorHandle());
        return new TableHandle(catalogHandle, newTableHandle, transaction);
    }

    @Override
    public Optional<PartitioningHandle> getCommonPartitioning(Session session, PartitioningHandle left, PartitioningHandle right) {
        Optional<CatalogHandle> leftCatalogHandle = left.getCatalogHandle();
        Optional<CatalogHandle> rightCatalogHandle = right.getCatalogHandle();
        if (leftCatalogHandle.isEmpty() || rightCatalogHandle.isEmpty() || !leftCatalogHandle.equals(rightCatalogHandle)) {
            return Optional.empty();
        }
        if (!left.getTransactionHandle().equals(right.getTransactionHandle())) {
            return Optional.empty();
        }
        CatalogHandle catalogHandle = leftCatalogHandle.get();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        Optional commonHandle = metadata.getCommonPartitioningHandle(session.toConnectorSession(catalogHandle), left.getConnectorHandle(), right.getConnectorHandle());
        return commonHandle.map(handle -> new PartitioningHandle(Optional.of(catalogHandle), left.getTransactionHandle(), (ConnectorPartitioningHandle)handle));
    }

    @Override
    public Optional<Object> getInfo(Session session, TableHandle handle) {
        CatalogHandle catalogHandle = handle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        return metadata.getInfo(handle.getConnectorHandle());
    }

    @Override
    public CatalogSchemaTableName getTableName(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        SchemaTableName tableName = metadata.getTableName(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
        return new CatalogSchemaTableName(catalogMetadata.getCatalogName(), tableName);
    }

    @Override
    public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        ConnectorTableSchema tableSchema = metadata.getTableSchema(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
        return new TableSchema(catalogMetadata.getCatalogName(), tableSchema);
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
        return new TableMetadata(catalogMetadata.getCatalogName(), tableMetadata);
    }

    @Override
    public TableStatistics getTableStatistics(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        TableStatistics tableStatistics = metadata.getTableStatistics(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
        Verify.verifyNotNull((Object)tableStatistics, (String)"%s returned null tableStatistics for %s", (Object[])new Object[]{metadata, tableHandle});
        return tableStatistics;
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        Map handles = metadata.getColumnHandles(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry mapEntry : handles.entrySet()) {
            map.put((Object)((String)mapEntry.getKey()).toLowerCase(Locale.ENGLISH), (Object)((ColumnHandle)mapEntry.getValue()));
        }
        return map.buildOrThrow();
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        return metadata.getColumnMetadata(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Optional<RelationType> relationType;
        Objects.requireNonNull(prefix, "prefix is null");
        if (MetadataManager.cannotExist(prefix)) {
            return ImmutableList.of();
        }
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent() && (relationType = this.getRelationTypeIfExists(session, objectName.get())).isPresent()) {
            return ImmutableList.of((Object)objectName.get());
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet tables = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                if (MetadataManager.isExternalInformationSchema(catalogHandle, prefix.getSchemaName())) continue;
                metadata.listTables(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(table -> !MetadataManager.isExternalInformationSchema(catalogHandle, table.getSchemaName())).forEach(tables::add);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Map<SchemaTableName, RelationType> getRelationTypes(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (MetadataManager.cannotExist(prefix)) {
            return ImmutableMap.of();
        }
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            Optional<RelationType> relationType = this.getRelationTypeIfExists(session, objectName.get());
            if (relationType.isPresent()) {
                return ImmutableMap.of((Object)objectName.get().asSchemaTableName(), (Object)relationType.get());
            }
            return ImmutableMap.of();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap relationTypes = new LinkedHashMap();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                if (MetadataManager.isExternalInformationSchema(catalogHandle, prefix.getSchemaName())) continue;
                metadata.getRelationTypes(connectorSession, prefix.getSchemaName()).entrySet().stream().filter(entry -> !MetadataManager.isExternalInformationSchema(catalogHandle, ((SchemaTableName)entry.getKey()).getSchemaName())).forEach(entry -> relationTypes.put((SchemaTableName)entry.getKey(), (RelationType)entry.getValue()));
            }
        }
        return ImmutableMap.copyOf(relationTypes);
    }

    private Optional<RelationType> getRelationTypeIfExists(Session session, QualifiedObjectName name) {
        if (this.isMaterializedView(session, name)) {
            return Optional.of(RelationType.MATERIALIZED_VIEW);
        }
        if (this.isView(session, name)) {
            return Optional.of(RelationType.VIEW);
        }
        try {
            if (this.getRedirectionAwareTableHandle(session, name).tableHandle().isPresent()) {
                return Optional.of(RelationType.TABLE);
            }
            return Optional.empty();
        }
        catch (TrinoException e) {
            if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_REDIRECTION_ERROR.toErrorCode())) {
                return Optional.of(RelationType.TABLE);
            }
            return Optional.empty();
        }
    }

    @Override
    public List<TableColumnsMetadata> listTableColumns(Session session, QualifiedTablePrefix prefix, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (MetadataManager.cannotExist(prefix)) {
            return ImmutableList.of();
        }
        String catalogName = prefix.getCatalogName();
        Optional<String> schemaName = prefix.getSchemaName();
        Optional<String> relationName = prefix.getTableName();
        if (relationName.isPresent()) {
            QualifiedObjectName objectName = new QualifiedObjectName(catalogName, schemaName.orElseThrow(), relationName.get());
            SchemaTableName schemaTableName = objectName.asSchemaTableName();
            return (List)Optional.empty().or(() -> this.getMaterializedViewInternal(session, objectName).map(materializedView -> RelationColumnsMetadata.forMaterializedView((SchemaTableName)schemaTableName, (List)materializedView.getColumns()))).or(() -> this.getViewInternal(session, objectName).map(view -> RelationColumnsMetadata.forView((SchemaTableName)schemaTableName, (List)view.getColumns()))).or(() -> {
                try {
                    RedirectionAwareTableHandle redirectionAware = this.getRedirectionAwareTableHandle(session, objectName);
                    if (redirectionAware.redirectedTableName().isPresent()) {
                        return Optional.of(RelationColumnsMetadata.forRedirectedTable((SchemaTableName)schemaTableName));
                    }
                    if (redirectionAware.tableHandle().isPresent()) {
                        return Optional.of(RelationColumnsMetadata.forTable((SchemaTableName)schemaTableName, this.getTableMetadata(session, redirectionAware.tableHandle().get()).getColumns()));
                    }
                }
                catch (RuntimeException e) {
                    boolean silent = false;
                    if (e instanceof TrinoException) {
                        TrinoException trinoException = (TrinoException)((Object)((Object)e));
                        ErrorCode errorCode = trinoException.getErrorCode();
                        boolean bl = silent = errorCode.equals((Object)StandardErrorCode.UNSUPPORTED_TABLE_TYPE.toErrorCode()) || errorCode.equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode()) || errorCode.equals((Object)StandardErrorCode.NOT_FOUND.toErrorCode()) || errorCode.getType() == ErrorType.EXTERNAL;
                    }
                    if (silent) {
                        log.debug((Throwable)e, "Failed to get metadata for table: %s", new Object[]{objectName});
                    }
                    log.warn((Throwable)e, "Failed to get metadata for table: %s", new Object[]{objectName});
                }
                return Optional.empty();
            }).filter(relationColumnsMetadata -> ((Set)relationFilter.apply((Set<SchemaTableName>)ImmutableSet.of((Object)relationColumnsMetadata.name()))).contains(relationColumnsMetadata.name())).map(relationColumnsMetadata -> ImmutableList.of((Object)this.tableColumnsMetadata(catalogName, (RelationColumnsMetadata)relationColumnsMetadata))).orElse(ImmutableList.of());
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        HashMap tableColumns = new HashMap();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                if (MetadataManager.isExternalInformationSchema(catalogHandle, schemaName)) continue;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                metadata.streamRelationColumns(connectorSession, schemaName, relationFilter).forEachRemaining(relationColumnsMetadata -> {
                    if (!MetadataManager.isExternalInformationSchema(catalogHandle, relationColumnsMetadata.name().getSchemaName())) {
                        tableColumns.putIfAbsent(relationColumnsMetadata.name(), this.tableColumnsMetadata(catalogName, (RelationColumnsMetadata)relationColumnsMetadata));
                    }
                });
            }
        }
        return ImmutableList.copyOf(tableColumns.values());
    }

    private TableColumnsMetadata tableColumnsMetadata(String catalogName, RelationColumnsMetadata relationColumnsMetadata) {
        SchemaTableName relationName = relationColumnsMetadata.name();
        Optional columnsMetadata = Optional.empty().or(() -> relationColumnsMetadata.materializedViewColumns().map(columns -> this.materializedViewColumnMetadata(catalogName, relationName, (List<ConnectorMaterializedViewDefinition.Column>)columns))).or(() -> relationColumnsMetadata.viewColumns().map(columns -> this.viewColumnMetadata(catalogName, relationName, (List<ConnectorViewDefinition.ViewColumn>)columns))).or(() -> ((RelationColumnsMetadata)relationColumnsMetadata).tableColumns()).or(() -> {
            Preconditions.checkState((boolean)relationColumnsMetadata.redirected(), (String)"Invalid RelationColumnsMetadata: %s", (Object)relationColumnsMetadata);
            return Optional.empty();
        });
        return new TableColumnsMetadata(relationName, columnsMetadata);
    }

    private List<ColumnMetadata> materializedViewColumnMetadata(String catalogName, SchemaTableName materializedViewName, List<ConnectorMaterializedViewDefinition.Column> columns) {
        ImmutableList.Builder columnMetadata = ImmutableList.builderWithExpectedSize((int)columns.size());
        for (ConnectorMaterializedViewDefinition.Column column : columns) {
            try {
                columnMetadata.add((Object)ColumnMetadata.builder().setName(column.getName()).setType(this.typeManager.getType(column.getType())).setComment(column.getComment()).build());
            }
            catch (TypeNotFoundException e) {
                QualifiedObjectName name = new QualifiedObjectName(catalogName, materializedViewName.getSchemaName(), materializedViewName.getTableName());
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, String.format("Unknown type '%s' for column '%s' in materialized view: %s", column.getType(), column.getName(), name));
            }
        }
        return columnMetadata.build();
    }

    private List<ColumnMetadata> viewColumnMetadata(String catalogName, SchemaTableName viewName, List<ConnectorViewDefinition.ViewColumn> columns) {
        ImmutableList.Builder columnMetadata = ImmutableList.builderWithExpectedSize((int)columns.size());
        for (ConnectorViewDefinition.ViewColumn column : columns) {
            try {
                columnMetadata.add((Object)ColumnMetadata.builder().setName(column.getName()).setType(this.typeManager.getType(column.getType())).setComment(column.getComment()).build());
            }
            catch (TypeNotFoundException e) {
                QualifiedObjectName name = new QualifiedObjectName(catalogName, viewName.getSchemaName(), viewName.getTableName());
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, String.format("Unknown type '%s' for column '%s' in view: %s", column.getType(), column.getName(), name));
            }
        }
        return columnMetadata.build();
    }

    @Override
    public List<RelationCommentMetadata> listRelationComments(Session session, String catalogName, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        if (MetadataManager.cannotExist(new QualifiedTablePrefix(catalogName, schemaName, Optional.empty()))) {
            return ImmutableList.of();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        ImmutableList.Builder tableComments = ImmutableList.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                if (MetadataManager.isExternalInformationSchema(catalogHandle, schemaName)) continue;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                Streams.stream((Iterator)metadata.streamRelationComments(connectorSession, schemaName, relationFilter)).filter(commentMetadata -> !MetadataManager.isExternalInformationSchema(catalogHandle, commentMetadata.name().getSchemaName())).forEach(arg_0 -> ((ImmutableList.Builder)tableComments).add(arg_0));
            }
        }
        return tableComments.build();
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createSchema(session.toConnectorSession(catalogHandle), schema.getSchemaName(), properties, principal);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.schemaCreated(session, schema);
        }
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema, boolean cascade) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropSchema(session.toConnectorSession(catalogHandle), schema.getSchemaName(), cascade);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.schemaDropped(session, schema);
        }
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.renameSchema(session.toConnectorSession(catalogHandle), source.getSchemaName(), target);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.schemaRenamed(session, source, new CatalogSchemaName(source.getCatalogName(), target));
        }
    }

    @Override
    public void setSchemaAuthorization(Session session, CatalogSchemaName source, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.setSchemaOwner(session, source, principal);
        } else {
            metadata.setSchemaAuthorization(session.toConnectorSession(catalogHandle), source.getSchemaName(), principal);
        }
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createTable(session.toConnectorSession(catalogHandle), tableMetadata, saveMode);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableCreated(session, new CatalogSchemaTableName(catalogName, tableMetadata.getTable()));
        }
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, CatalogSchemaTableName sourceTableName, QualifiedObjectName newTableName) {
        String catalogName = newTableName.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        if (!tableHandle.getCatalogHandle().equals((Object)catalogHandle)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.renameTable(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() != CatalogMetadata.SecurityManagement.CONNECTOR) {
            this.systemSecurityMetadata.tableRenamed(session, sourceTableName, newTableName.asCatalogSchemaTableName());
        }
    }

    @Override
    public void setTableProperties(Session session, TableHandle tableHandle, Map<String, Optional<Object>> properties) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.setTableProperties(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), properties);
    }

    @Override
    public void setTableComment(Session session, TableHandle tableHandle, Optional<String> comment) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.setTableComment(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), comment);
    }

    @Override
    public void setViewComment(Session session, QualifiedObjectName viewName, Optional<String> comment) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.setViewComment(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName(), comment);
    }

    @Override
    public void setViewColumnComment(Session session, QualifiedObjectName viewName, String columnName, Optional<String> comment) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.setViewColumnComment(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName(), columnName, comment);
    }

    @Override
    public void setColumnComment(Session session, TableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.setColumnComment(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), column, comment);
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnHandle source, String target) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle.getCatalogName());
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.renameColumn(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            ColumnMetadata columnMetadata = this.getColumnMetadata(session, tableHandle, source);
            this.systemSecurityMetadata.columnRenamed(session, table, columnMetadata.getName(), target);
        }
    }

    @Override
    public void renameField(Session session, TableHandle tableHandle, List<String> fieldPath, String target) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.renameField(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), fieldPath, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnMetadata column) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle.getCatalogName());
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.addColumn(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), column);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.columnCreated(session, table, column.getName());
        }
    }

    @Override
    public void addField(Session session, TableHandle tableHandle, List<String> parentPath, String fieldName, Type type, boolean ignoreExisting) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.addField(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), parentPath, fieldName, type, ignoreExisting);
    }

    @Override
    public void dropColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnHandle column) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle.getCatalogName());
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.dropColumn(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), column);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            ColumnMetadata columnMetadata = this.getColumnMetadata(session, tableHandle, column);
            this.systemSecurityMetadata.columnDropped(session, table, columnMetadata.getName());
        }
    }

    @Override
    public void dropField(Session session, TableHandle tableHandle, ColumnHandle column, List<String> fieldPath) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.dropField(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), column, fieldPath);
    }

    @Override
    public void setColumnType(Session session, TableHandle tableHandle, ColumnHandle column, Type type) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.setColumnType(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), column, type);
    }

    @Override
    public void setFieldType(Session session, TableHandle tableHandle, List<String> fieldPath, Type type) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.setFieldType(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), fieldPath, type);
    }

    @Override
    public void setTableAuthorization(Session session, CatalogSchemaTableName table, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, table.getCatalogName());
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.setTableOwner(session, table, principal);
        } else {
            metadata.setTableAuthorization(session.toConnectorSession(catalogMetadata.getCatalogHandle()), table.getSchemaTableName(), principal);
        }
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle, CatalogSchemaTableName tableName) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropTable(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
        if (catalogMetadata.getSecurityManagement() != CatalogMetadata.SecurityManagement.CONNECTOR) {
            this.systemSecurityMetadata.tableDropped(session, tableName);
        }
    }

    @Override
    public void truncateTable(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        metadata.truncateTable(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<TableLayout> getInsertLayout(Session session, TableHandle table) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.getInsertLayout(session.toConnectorSession(catalogHandle), table.getConnectorHandle()).map(layout -> new TableLayout(catalogHandle, catalogMetadata.getTransactionHandleFor(catalogHandle), (ConnectorTableLayout)layout));
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session session, CatalogHandle catalogHandle, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.getStatisticsCollectionMetadataForWrite(session.toConnectorSession(catalogHandle), tableMetadata);
    }

    @Override
    public AnalyzeMetadata getStatisticsCollectionMetadata(Session session, TableHandle tableHandle, Map<String, Object> analyzeProperties) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorAnalyzeMetadata analyze = metadata.getStatisticsCollectionMetadata(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), analyzeProperties);
        return new AnalyzeMetadata(analyze.getStatisticsMetadata(), new TableHandle(catalogHandle, analyze.getTableHandle(), tableHandle.getTransaction()));
    }

    @Override
    public AnalyzeTableHandle beginStatisticsCollection(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogHandle);
        ConnectorTableHandle connectorTableHandle = metadata.beginStatisticsCollection(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
        return new AnalyzeTableHandle(catalogHandle, transactionHandle, connectorTableHandle);
    }

    @Override
    public void finishStatisticsCollection(Session session, AnalyzeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        catalogMetadata.getMetadata(session).finishStatisticsCollection(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), computedStatistics);
    }

    @Override
    public Optional<TableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.getNewTableLayout(connectorSession, tableMetadata).map(layout -> new TableLayout(catalogHandle, transactionHandle, (ConnectorTableLayout)layout));
    }

    @Override
    public Optional<Type> getSupportedType(Session session, CatalogHandle catalogHandle, Map<String, Object> tableProperties, Type type) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.getSupportedType(session.toConnectorSession(catalogHandle), tableProperties, type).map(newType -> {
            if (!this.typeCoercion.isCompatible((Type)newType, type)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Type '%s' is not compatible with the supplied type '%s' in getSupportedType", type, newType));
            }
            return newType;
        });
    }

    @Override
    public void beginQuery(Session session) {
        this.languageFunctionManager.registerQuery(session);
    }

    @Override
    public void cleanupQuery(Session session) {
        QueryCatalogs queryCatalogs = (QueryCatalogs)this.catalogsByQueryId.remove(session.getQueryId());
        if (queryCatalogs != null) {
            queryCatalogs.finish();
        }
        this.languageFunctionManager.unregisterQuery(session);
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<TableLayout> layout, boolean replace) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        ConnectorOutputTableHandle handle = metadata.beginCreateTable(connectorSession, tableMetadata, layout.map(TableLayout::getLayout), SystemSessionProperties.getRetryPolicy(session).getRetryMode(), replace);
        return new OutputTableHandle(catalogHandle, tableMetadata.getTable(), transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        Optional output = metadata.finishCreateTable(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), fragments, computedStatistics);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableCreated(session, new CatalogSchemaTableName(catalogHandle.getCatalogName(), tableHandle.getTableName()));
        }
        return output;
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle, List<ColumnHandle> columns) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogHandle);
        ConnectorInsertTableHandle handle = metadata.beginInsert(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), columns, SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return new InsertTableHandle(tableHandle.getCatalogHandle(), transactionHandle, handle);
    }

    @Override
    public boolean supportsMissingColumnsOnInsert(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        return catalogMetadata.getMetadata(session).supportsMissingColumnsOnInsert();
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        return metadata.finishInsert(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public boolean delegateMaterializedViewRefreshToConnector(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getRequiredCatalogMetadata(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.delegateMaterializedViewRefreshToConnector(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName());
    }

    @Override
    public ListenableFuture<Void> refreshMaterializedView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getRequiredCatalogMetadata(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return MetadataManager.asVoid(MoreFutures.toListenableFuture((CompletableFuture)metadata.refreshMaterializedView(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName())));
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public InsertTableHandle beginRefreshMaterializedView(Session session, TableHandle tableHandle, List<TableHandle> sourceTableHandles) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogHandle);
        List sourceConnectorHandles = sourceTableHandles.stream().map(TableHandle::getConnectorHandle).collect(Collectors.toList());
        sourceConnectorHandles.add(tableHandle.getConnectorHandle());
        ConnectorInsertTableHandle handle = metadata.beginRefreshMaterializedView(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), sourceConnectorHandles, SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return new InsertTableHandle(tableHandle.getCatalogHandle(), transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(Session session, TableHandle tableHandle, InsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<TableHandle> sourceTableHandles) {
        CatalogHandle catalogHandle = insertHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        List sourceConnectorHandles = (List)sourceTableHandles.stream().map(TableHandle::getConnectorHandle).collect(ImmutableList.toImmutableList());
        return metadata.finishRefreshMaterializedView(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), insertHandle.getConnectorHandle(), fragments, computedStatistics, sourceConnectorHandles);
    }

    @Override
    public ColumnHandle getMergeRowIdColumnHandle(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        return metadata.getMergeRowIdColumnHandle(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<PartitioningHandle> getUpdateLayout(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogHandle);
        return metadata.getUpdateLayout(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle()).map(partitioning -> new PartitioningHandle(Optional.of(catalogHandle), Optional.of(transactionHandle), (ConnectorPartitioningHandle)partitioning));
    }

    @Override
    public Optional<TableHandle> applyUpdate(Session session, TableHandle table, Map<ColumnHandle, Constant> assignments) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applyUpdate(connectorSession, table.getConnectorHandle(), assignments).map(newHandle -> new TableHandle(catalogHandle, (ConnectorTableHandle)newHandle, table.getTransaction()));
    }

    @Override
    public OptionalLong executeUpdate(Session session, TableHandle table) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.executeUpdate(connectorSession, table.getConnectorHandle());
    }

    @Override
    public Optional<TableHandle> applyDelete(Session session, TableHandle table) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applyDelete(connectorSession, table.getConnectorHandle()).map(newHandle -> new TableHandle(catalogHandle, (ConnectorTableHandle)newHandle, table.getTransaction()));
    }

    @Override
    public OptionalLong executeDelete(Session session, TableHandle table) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.executeDelete(connectorSession, table.getConnectorHandle());
    }

    @Override
    public RowChangeParadigm getRowChangeParadigm(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        return metadata.getRowChangeParadigm(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle());
    }

    @Override
    public MergeHandle beginMerge(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogHandle);
        ConnectorMergeTableHandle newHandle = metadata.beginMerge(session.toConnectorSession(catalogHandle), tableHandle.getConnectorHandle(), SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return new MergeHandle(tableHandle.withConnectorHandle(newHandle.getTableHandle()), newHandle);
    }

    @Override
    public void finishMerge(Session session, MergeHandle mergeHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogHandle catalogHandle = mergeHandle.getTableHandle().getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        metadata.finishMerge(session.toConnectorSession(catalogHandle), mergeHandle.getConnectorMergeHandle(), fragments, computedStatistics);
    }

    @Override
    public Optional<CatalogHandle> getCatalogHandle(Session session, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName).map(CatalogMetadata::getCatalogHandle);
    }

    @Override
    public List<CatalogInfo> listCatalogs(Session session) {
        return this.transactionManager.getCatalogs(session.getRequiredTransactionId());
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (MetadataManager.cannotExist(prefix)) {
            return ImmutableList.of();
        }
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            return (List)this.getView(session, objectName.get()).map(handle -> ImmutableList.of((Object)((QualifiedObjectName)objectName.get()))).orElseGet(ImmutableList::of);
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet views = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                if (MetadataManager.isExternalInformationSchema(catalogHandle, prefix.getSchemaName())) continue;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                metadata.listViews(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(view -> !MetadataManager.isExternalInformationSchema(catalogHandle, view.getSchemaName())).forEach(views::add);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedObjectName, ViewInfo> getViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (MetadataManager.cannotExist(prefix)) {
            return ImmutableMap.of();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap<QualifiedObjectName, ViewInfo> views = new LinkedHashMap<QualifiedObjectName, ViewInfo>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                if (MetadataManager.isExternalInformationSchema(catalogHandle, tablePrefix.getSchema())) continue;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                Map viewMap = tablePrefix.getTable().isPresent() ? (Map)metadata.getView(connectorSession, tablePrefix.toSchemaTableName()).map(view -> ImmutableMap.of((Object)tablePrefix.toSchemaTableName(), (Object)view)).orElse(ImmutableMap.of()) : metadata.getViews(connectorSession, tablePrefix.getSchema());
                for (Map.Entry entry : viewMap.entrySet()) {
                    if (MetadataManager.isExternalInformationSchema(catalogHandle, ((SchemaTableName)entry.getKey()).getSchemaName())) continue;
                    QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    views.put(viewName, new ViewInfo((ConnectorViewDefinition)entry.getValue()));
                }
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Map<String, Object> getSchemaProperties(Session session, CatalogSchemaName schemaName) {
        if (!this.schemaExists(session, schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        CatalogMetadata catalogMetadata = this.getRequiredCatalogMetadata(session, schemaName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getConnectorHandleForSchema(schemaName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.getSchemaProperties(connectorSession, schemaName.getSchemaName());
    }

    @Override
    public Optional<TrinoPrincipal> getSchemaOwner(Session session, CatalogSchemaName schemaName) {
        if (!this.schemaExists(session, schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        CatalogMetadata catalogMetadata = this.getRequiredCatalogMetadata(session, schemaName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            return this.systemSecurityMetadata.getSchemaOwner(session, schemaName);
        }
        CatalogHandle catalogHandle = catalogMetadata.getConnectorHandleForSchema(schemaName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.getSchemaOwner(connectorSession, schemaName.getSchemaName());
    }

    @Override
    public boolean isView(Session session, QualifiedObjectName viewName) {
        return this.getViewInternal(session, viewName).isPresent();
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        Optional<ConnectorViewDefinition> connectorView = this.getViewInternal(session, viewName);
        if (connectorView.isEmpty() || connectorView.get().isRunAsInvoker() || this.isCatalogManagedSecurity(session, viewName.getCatalogName())) {
            return connectorView.map(view -> MetadataManager.createViewDefinition(viewName, view, view.getOwner().map(Identity::ofUser)));
        }
        Identity runAsIdentity = this.systemSecurityMetadata.getViewRunAsIdentity(session, viewName.asCatalogSchemaTableName()).or(() -> ((ConnectorViewDefinition)connectorView.get()).getOwner().map(Identity::ofUser)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Catalog does not support run-as DEFINER views: " + viewName));
        return Optional.of(MetadataManager.createViewDefinition(viewName, connectorView.get(), Optional.of(runAsIdentity)));
    }

    private static ViewDefinition createViewDefinition(QualifiedObjectName viewName, ConnectorViewDefinition view, Optional<Identity> runAsIdentity) {
        if (view.isRunAsInvoker() && runAsIdentity.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Run-as identity cannot be set for a run-as invoker view: " + viewName);
        }
        if (!view.isRunAsInvoker() && runAsIdentity.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Run-as identity must be set for a run-as definer view: " + viewName);
        }
        return new ViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), (List)view.getColumns().stream().map(column -> new ViewColumn(column.getName(), column.getType(), column.getComment())).collect(ImmutableList.toImmutableList()), view.getComment(), runAsIdentity, view.getPath());
    }

    private Optional<ConnectorViewDefinition> getViewInternal(Session session, QualifiedObjectName viewName) {
        if (MetadataManager.cannotExist(viewName)) {
            return Optional.empty();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
            ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
            return metadata.getView(connectorSession, viewName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, ViewDefinition definition, boolean replace) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createView(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName(), definition.toConnectorViewDefinition(), replace);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableCreated(session, viewName.asCatalogSchemaTableName());
        }
    }

    @Override
    public void renameView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, target.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (!source.getCatalogName().equals(target.getCatalogName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename views across catalogs");
        }
        metadata.renameView(session.toConnectorSession(catalogHandle), source.asSchemaTableName(), target.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableRenamed(session, source.asCatalogSchemaTableName(), target.asCatalogSchemaTableName());
        }
    }

    @Override
    public void setViewAuthorization(Session session, CatalogSchemaTableName view, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, view.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.setViewOwner(session, view, principal);
        } else {
            metadata.setViewAuthorization(session.toConnectorSession(catalogHandle), view.getSchemaTableName(), principal);
        }
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropView(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableDropped(session, viewName.asCatalogSchemaTableName());
        }
    }

    @Override
    public void createMaterializedView(Session session, QualifiedObjectName viewName, MaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createMaterializedView(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName(), definition.toConnectorMaterializedViewDefinition(), replace, ignoreExisting);
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableCreated(session, viewName.asCatalogSchemaTableName());
        }
    }

    @Override
    public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropMaterializedView(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableDropped(session, viewName.asCatalogSchemaTableName());
        }
    }

    @Override
    public List<QualifiedObjectName> listMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            return this.isMaterializedView(session, objectName.get()) ? ImmutableList.of((Object)objectName.get()) : ImmutableList.of();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet materializedViews = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                if (MetadataManager.isExternalInformationSchema(catalogHandle, prefix.getSchemaName())) continue;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                metadata.listMaterializedViews(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(materializedView -> !MetadataManager.isExternalInformationSchema(catalogHandle, materializedView.getSchemaName())).forEach(materializedViews::add);
            }
        }
        return ImmutableList.copyOf(materializedViews);
    }

    @Override
    public Map<QualifiedObjectName, ViewInfo> getMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap<QualifiedObjectName, ViewInfo> views = new LinkedHashMap<QualifiedObjectName, ViewInfo>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogHandle catalogHandle : catalogMetadata.listCatalogHandles()) {
                if (MetadataManager.isExternalInformationSchema(catalogHandle, tablePrefix.getSchema())) continue;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                Map materializedViewMap = tablePrefix.getTable().isPresent() ? (Map)metadata.getMaterializedView(connectorSession, tablePrefix.toSchemaTableName()).map(view -> ImmutableMap.of((Object)tablePrefix.toSchemaTableName(), (Object)view)).orElse(ImmutableMap.of()) : metadata.getMaterializedViews(connectorSession, tablePrefix.getSchema());
                for (Map.Entry entry : materializedViewMap.entrySet()) {
                    if (MetadataManager.isExternalInformationSchema(catalogHandle, ((SchemaTableName)entry.getKey()).getSchemaName())) continue;
                    QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    views.put(viewName, new ViewInfo((ConnectorMaterializedViewDefinition)entry.getValue()));
                }
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public boolean isMaterializedView(Session session, QualifiedObjectName viewName) {
        return this.getMaterializedViewInternal(session, viewName).isPresent();
    }

    @Override
    public Optional<MaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
        Optional<ConnectorMaterializedViewDefinition> connectorView = this.getMaterializedViewInternal(session, viewName);
        if (connectorView.isEmpty()) {
            return Optional.empty();
        }
        if (this.isCatalogManagedSecurity(session, viewName.getCatalogName())) {
            String runAsUser = (String)connectorView.get().getOwner().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Owner not set for a run-as invoker view: " + viewName));
            return Optional.of(MetadataManager.createMaterializedViewDefinition(connectorView.get(), Identity.ofUser((String)runAsUser)));
        }
        Identity runAsIdentity = this.systemSecurityMetadata.getViewRunAsIdentity(session, viewName.asCatalogSchemaTableName()).or(() -> ((ConnectorMaterializedViewDefinition)connectorView.get()).getOwner().map(Identity::ofUser)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized view does not have an owner: " + viewName));
        return Optional.of(MetadataManager.createMaterializedViewDefinition(connectorView.get(), runAsIdentity));
    }

    private static MaterializedViewDefinition createMaterializedViewDefinition(ConnectorMaterializedViewDefinition view, Identity runAsIdentity) {
        return new MaterializedViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), (List)view.getColumns().stream().map(column -> new ViewColumn(column.getName(), column.getType(), Optional.empty())).collect(ImmutableList.toImmutableList()), view.getGracePeriod(), view.getComment(), runAsIdentity, view.getPath(), view.getStorageTable(), view.getProperties());
    }

    private Optional<ConnectorMaterializedViewDefinition> getMaterializedViewInternal(Session session, QualifiedObjectName viewName) {
        if (MetadataManager.cannotExist(viewName)) {
            return Optional.empty();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
            ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
            return metadata.getMaterializedView(connectorSession, viewName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public MaterializedViewFreshness getMaterializedViewFreshness(Session session, QualifiedObjectName viewName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
            ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
            return metadata.getMaterializedViewFreshness(connectorSession, viewName.asSchemaTableName());
        }
        return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE, Optional.empty());
    }

    @Override
    public void renameMaterializedView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, target.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (!source.getCatalogName().equals(target.getCatalogName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename materialized views across catalogs");
        }
        metadata.renameMaterializedView(session.toConnectorSession(catalogHandle), source.asSchemaTableName(), target.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableRenamed(session, source.asCatalogSchemaTableName(), target.asCatalogSchemaTableName());
        }
    }

    @Override
    public void setMaterializedViewProperties(Session session, QualifiedObjectName viewName, Map<String, Optional<Object>> properties) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.setMaterializedViewProperties(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName(), properties);
    }

    @Override
    public void setMaterializedViewColumnComment(Session session, QualifiedObjectName viewName, String columnName, Optional<String> comment) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.setMaterializedViewColumnComment(session.toConnectorSession(catalogHandle), viewName.asSchemaTableName(), columnName, comment);
    }

    private static boolean isExternalInformationSchema(CatalogHandle catalogHandle, Optional<String> schemaName) {
        return schemaName.isPresent() && MetadataManager.isExternalInformationSchema(catalogHandle, schemaName.get());
    }

    private static boolean isExternalInformationSchema(CatalogHandle catalogHandle, String schemaName) {
        return !catalogHandle.getType().isInternal() && "information_schema".equalsIgnoreCase(schemaName);
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(Session session, TableHandle tableHandle) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applyTableScanRedirect(connectorSession, tableHandle.getConnectorHandle());
    }

    private QualifiedObjectName getRedirectedTableName(Session session, QualifiedObjectName originalTableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(originalTableName, "originalTableName is null");
        if (MetadataManager.cannotExist(originalTableName)) {
            return originalTableName;
        }
        QualifiedObjectName tableName = originalTableName;
        LinkedHashSet<QualifiedObjectName> visitedTableNames = new LinkedHashSet<QualifiedObjectName>();
        visitedTableNames.add(tableName);
        for (int count = 0; count < 10; ++count) {
            CatalogHandle catalogHandle;
            Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
            if (catalog.isEmpty()) {
                return tableName;
            }
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle = catalogMetadata.getCatalogHandle(session, tableName));
            Optional<QualifiedObjectName> redirectedTableName = metadata.redirectTable(session.toConnectorSession(catalogHandle), tableName.asSchemaTableName()).map(name -> QualifiedObjectName.convertFromSchemaTableName(name.getCatalogName()).apply(name.getSchemaTableName()));
            if (redirectedTableName.isEmpty()) {
                return tableName;
            }
            tableName = redirectedTableName.get();
            if (visitedTableNames.add(tableName)) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table redirections form a loop: %s", Streams.concat((Stream[])new Stream[]{visitedTableNames.stream(), Stream.of(tableName)}).map(QualifiedObjectName::toString).collect(Collectors.joining(" -> "))));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table redirected too many times (%d): %s", 10, visitedTableNames));
    }

    @Override
    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName) {
        return this.getRedirectionAwareTableHandle(session, tableName, Optional.empty(), Optional.empty());
    }

    @Override
    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        QualifiedObjectName targetTableName = this.getRedirectedTableName(session, tableName);
        if (targetTableName.equals(tableName)) {
            return RedirectionAwareTableHandle.noRedirection(this.getTableHandle(session, tableName, startVersion, endVersion));
        }
        Optional<TableHandle> tableHandle = this.getTableHandle(session, targetTableName, startVersion, endVersion);
        if (tableHandle.isPresent()) {
            return RedirectionAwareTableHandle.withRedirectionTo(targetTableName, tableHandle.get());
        }
        if (this.getCatalogHandle(session, targetTableName.getCatalogName()).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table '%s' redirected to '%s', but the target catalog '%s' does not exist", tableName, targetTableName, targetTableName.getCatalogName()));
        }
        if (!this.schemaExists(session, new CatalogSchemaName(targetTableName.getCatalogName(), targetTableName.getSchemaName()))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table '%s' redirected to '%s', but the target schema '%s' does not exist", tableName, targetTableName, targetTableName.getSchemaName()));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table '%s' redirected to '%s', but the target table '%s' does not exist", tableName, targetTableName, targetTableName));
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        CatalogHandle catalogHandle = tableHandle.getCatalogHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        Optional resolvedIndex = metadata.resolveIndex(connectorSession, tableHandle.getConnectorHandle(), indexableColumns, outputColumns, tupleDomain);
        return resolvedIndex.map(resolved -> new ResolvedIndex(tableHandle.getCatalogHandle(), transaction, (ConnectorResolvedIndex)resolved));
    }

    @Override
    public Optional<LimitApplicationResult<TableHandle>> applyLimit(Session session, TableHandle table, long limit) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applyLimit(connectorSession, table.getConnectorHandle(), limit).map(result -> new LimitApplicationResult((Object)new TableHandle(catalogHandle, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.isLimitGuaranteed(), result.isPrecalculateStatistics()));
    }

    @Override
    public Optional<SampleApplicationResult<TableHandle>> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applySample(connectorSession, table.getConnectorHandle(), sampleType, sampleRatio).map(result -> new SampleApplicationResult((Object)new TableHandle(catalogHandle, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.isPrecalculateStatistics()));
    }

    @Override
    public Optional<AggregationApplicationResult<TableHandle>> applyAggregation(Session session, TableHandle table, List<AggregateFunction> aggregations, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        Preconditions.checkArgument((!groupingSets.isEmpty() ? 1 : 0) != 0, (Object)"No grouping sets provided");
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applyAggregation(connectorSession, table.getConnectorHandle(), aggregations, assignments, groupingSets).map(result -> {
            this.verifyProjection(table, result.getProjections(), result.getAssignments(), aggregations.size());
            return new AggregationApplicationResult((Object)new TableHandle(catalogHandle, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.getProjections(), result.getAssignments(), result.getGroupingColumnMapping(), result.isPrecalculateStatistics());
        });
    }

    @Override
    public Optional<JoinApplicationResult<TableHandle>> applyJoin(Session session, JoinType joinType, TableHandle left, TableHandle right, ConnectorExpression joinCondition, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        if (!right.getCatalogHandle().equals((Object)left.getCatalogHandle())) {
            return Optional.empty();
        }
        CatalogHandle catalogHandle = left.getCatalogHandle();
        ConnectorTransactionHandle transaction = left.getTransaction();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        Optional connectorResult = metadata.applyJoin(connectorSession, joinType, left.getConnectorHandle(), right.getConnectorHandle(), joinCondition, leftAssignments, rightAssignments, statistics);
        return connectorResult.map(result -> {
            ImmutableSet leftColumnHandles = ImmutableSet.copyOf(this.getColumnHandles(session, left).values());
            ImmutableSet rightColumnHandles = ImmutableSet.copyOf(this.getColumnHandles(session, right).values());
            Set leftColumnHandlesMappingKeys = result.getLeftColumnHandles().keySet();
            Set rightColumnHandlesMappingKeys = result.getRightColumnHandles().keySet();
            if (leftColumnHandlesMappingKeys.size() != leftColumnHandles.size() || rightColumnHandlesMappingKeys.size() != rightColumnHandles.size() || !leftColumnHandlesMappingKeys.containsAll((Collection<?>)leftColumnHandles) || !rightColumnHandlesMappingKeys.containsAll((Collection<?>)rightColumnHandles)) {
                throw new IllegalStateException(String.format("Column handle mappings do not match old column handles: left=%s; right=%s; newLeft=%s, newRight=%s", leftColumnHandles, rightColumnHandles, leftColumnHandlesMappingKeys, rightColumnHandlesMappingKeys));
            }
            return new JoinApplicationResult((Object)new TableHandle(catalogHandle, (ConnectorTableHandle)result.getTableHandle(), transaction), result.getLeftColumnHandles(), result.getRightColumnHandles(), result.isPrecalculateStatistics());
        });
    }

    @Override
    public Optional<TopNApplicationResult<TableHandle>> applyTopN(Session session, TableHandle table, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applyTopN(connectorSession, table.getConnectorHandle(), topNCount, sortItems, assignments).map(result -> new TopNApplicationResult((Object)new TableHandle(catalogHandle, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.isTopNGuaranteed(), result.isPrecalculateStatistics()));
    }

    @Override
    public Optional<TableFunctionApplicationResult<TableHandle>> applyTableFunction(Session session, TableFunctionHandle handle) {
        CatalogHandle catalogHandle = handle.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        return metadata.applyTableFunction(session.toConnectorSession(catalogHandle), handle.getFunctionHandle()).map(result -> new TableFunctionApplicationResult((Object)new TableHandle(catalogHandle, (ConnectorTableHandle)result.getTableHandle(), handle.getTransactionHandle()), result.getColumnHandles()));
    }

    private void verifyProjection(TableHandle table, List<ConnectorExpression> projections, List<Assignment> assignments, int expectedProjectionSize) {
        projections.forEach(projection -> Objects.requireNonNull(projection, "one of the projections is null"));
        assignments.forEach(assignment -> Objects.requireNonNull(assignment, "one of the assignments is null"));
        Verify.verify((expectedProjectionSize == projections.size() ? 1 : 0) != 0, (String)"ConnectorMetadata returned invalid number of projections: %s instead of %s for %s", (Object)projections.size(), (Object)expectedProjectionSize, (Object)table);
        Set assignedVariables = (Set)assignments.stream().map(Assignment::getVariable).collect(ImmutableSet.toImmutableSet());
        projections.stream().flatMap(connectorExpression -> ConnectorExpressions.extractVariables(connectorExpression).stream()).map(Variable::getName).filter(variableName -> !assignedVariables.contains(variableName)).findAny().ifPresent(variableName -> {
            throw new IllegalStateException("Unbound variable: " + variableName);
        });
    }

    @Override
    public void validateScan(Session session, TableHandle table) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        metadata.validateScan(session.toConnectorSession(catalogHandle), table.getConnectorHandle());
    }

    @Override
    public Optional<ConstraintApplicationResult<TableHandle>> applyFilter(Session session, TableHandle table, Constraint constraint) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applyFilter(connectorSession, table.getConnectorHandle(), constraint).map(result -> result.transform(handle -> new TableHandle(catalogHandle, (ConnectorTableHandle)handle, table.getTransaction())));
    }

    @Override
    public Optional<ProjectionApplicationResult<TableHandle>> applyProjection(Session session, TableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorMetadata metadata = this.getMetadata(session, catalogHandle);
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return metadata.applyProjection(connectorSession, table.getConnectorHandle(), projections, assignments).map(result -> {
            this.verifyProjection(table, result.getProjections(), result.getAssignments(), projections.size());
            return new ProjectionApplicationResult((Object)new TableHandle(catalogHandle, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.getProjections(), result.getAssignments(), result.isPrecalculateStatistics());
        });
    }

    @Override
    public boolean isCatalogManagedSecurity(Session session, String catalog) {
        return this.getRequiredCatalogMetadata(session, catalog).getSecurityManagement() == CatalogMetadata.SecurityManagement.CONNECTOR;
    }

    @Override
    public boolean roleExists(Session session, String role, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            return this.systemSecurityMetadata.roleExists(session, role);
        }
        CatalogMetadata catalogMetadata = this.getRequiredCatalogMetadata(session, catalog.get());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.roleExists(session.toConnectorSession(catalogHandle), role);
    }

    @Override
    public void createRole(Session session, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            this.systemSecurityMetadata.createRole(session, role, grantor);
            return;
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog.get());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createRole(session.toConnectorSession(catalogHandle), role, grantor);
    }

    @Override
    public void dropRole(Session session, String role, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            this.systemSecurityMetadata.dropRole(session, role);
            return;
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog.get());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropRole(session.toConnectorSession(catalogHandle), role);
    }

    @Override
    public Set<String> listRoles(Session session, Optional<String> catalog) {
        if (catalog.isPresent()) {
            Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog.get());
            if (catalogMetadata.isEmpty()) {
                return ImmutableSet.of();
            }
            if (catalogMetadata.get().getSecurityManagement() == CatalogMetadata.SecurityManagement.CONNECTOR) {
                CatalogHandle catalogHandle = catalogMetadata.get().getCatalogHandle();
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogHandle);
                return (Set)metadata.listRoles(connectorSession).stream().map(role -> role.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            }
        }
        return this.systemSecurityMetadata.listRoles(session);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(Session session, Optional<String> catalog, TrinoPrincipal principal) {
        if (catalog.isPresent()) {
            Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog.get());
            if (catalogMetadata.isEmpty()) {
                return ImmutableSet.of();
            }
            if (catalogMetadata.get().getSecurityManagement() == CatalogMetadata.SecurityManagement.CONNECTOR) {
                CatalogHandle catalogHandle = catalogMetadata.get().getCatalogHandle();
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogHandle);
                return metadata.listRoleGrants(connectorSession, principal);
            }
        }
        return this.systemSecurityMetadata.listRoleGrants(session, principal);
    }

    @Override
    public void grantRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            this.systemSecurityMetadata.grantRoles(session, roles, grantees, adminOption, grantor);
            return;
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog.get());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.grantRoles(session.toConnectorSession(catalogHandle), roles, grantees, adminOption, grantor);
    }

    @Override
    public void revokeRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            this.systemSecurityMetadata.revokeRoles(session, roles, grantees, adminOption, grantor);
            return;
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog.get());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.revokeRoles(session.toConnectorSession(catalogHandle), roles, grantees, adminOption, grantor);
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(Session session, TrinoPrincipal principal, Optional<String> catalog) {
        if (catalog.isPresent()) {
            Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog.get());
            if (catalogMetadata.isEmpty()) {
                return ImmutableSet.of();
            }
            if (catalogMetadata.get().getSecurityManagement() == CatalogMetadata.SecurityManagement.CONNECTOR) {
                CatalogHandle catalogHandle = catalogMetadata.get().getCatalogHandle();
                ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
                ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogHandle);
                return ImmutableSet.copyOf((Collection)metadata.listApplicableRoles(connectorSession, principal));
            }
        }
        return this.systemSecurityMetadata.listApplicableRoles(session, principal);
    }

    @Override
    public Set<String> listEnabledRoles(Identity identity) {
        return this.systemSecurityMetadata.listEnabledRoles(identity);
    }

    @Override
    public Set<String> listEnabledRoles(Session session, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        if (catalogMetadata.get().getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            return this.systemSecurityMetadata.listEnabledRoles(session.getIdentity());
        }
        CatalogHandle catalogHandle = catalogMetadata.get().getCatalogHandle();
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogHandle);
        return ImmutableSet.copyOf((Collection)metadata.listEnabledRoles(connectorSession));
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
            return;
        }
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.grantTablePrivileges(session.toConnectorSession(catalogHandle), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void denyTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.denyTablePrivileges(session, tableName, privileges, grantee);
            return;
        }
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.denyTablePrivileges(session.toConnectorSession(catalogHandle), tableName.asSchemaTableName(), privileges, grantee);
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.revokeTablePrivileges(session, tableName, privileges, grantee, grantOption);
            return;
        }
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.revokeTablePrivileges(session.toConnectorSession(catalogHandle), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void grantSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schemaName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.grantSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
            return;
        }
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.grantSchemaPrivileges(session.toConnectorSession(catalogHandle), schemaName.getSchemaName(), privileges, grantee, grantOption);
    }

    @Override
    public void denySchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schemaName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.denySchemaPrivileges(session, schemaName, privileges, grantee);
            return;
        }
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.denySchemaPrivileges(session.toConnectorSession(catalogHandle), schemaName.getSchemaName(), privileges, grantee);
    }

    @Override
    public void revokeSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schemaName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.revokeSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
            return;
        }
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.revokeSchemaPrivileges(session.toConnectorSession(catalogHandle), schemaName.getSchemaName(), privileges, grantee, grantOption);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        ImmutableSet.Builder grantInfos = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogHandle());
            List catalogHandles = prefix.asQualifiedObjectName().map(qualifiedTableName -> Collections.singletonList(catalogMetadata.getCatalogHandle(session, (QualifiedObjectName)qualifiedTableName))).orElseGet(catalogMetadata::listCatalogHandles);
            for (CatalogHandle catalogHandle : catalogHandles) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
                if (catalogMetadata.getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
                    grantInfos.addAll(this.systemSecurityMetadata.listTablePrivileges(session, prefix));
                    continue;
                }
                grantInfos.addAll((Iterable)metadata.listTablePrivileges(connectorSession, prefix.asSchemaTablePrefix()));
            }
        }
        return ImmutableList.copyOf((Collection)grantInfos.build());
    }

    @Override
    public Collection<FunctionMetadata> listGlobalFunctions(Session session) {
        return this.functions.listFunctions();
    }

    @Override
    public Collection<FunctionMetadata> listFunctions(Session session, CatalogSchemaName schema) {
        ImmutableList.Builder functions = ImmutableList.builder();
        this.getOptionalCatalogMetadata(session, schema.getCatalogName()).ifPresent(catalogMetadata -> {
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogHandle());
            ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
            functions.addAll((Iterable)metadata.listFunctions(connectorSession, schema.getSchemaName()));
            functions.addAll(this.languageFunctionManager.listFunctions(metadata.listLanguageFunctions(connectorSession, schema.getSchemaName())));
        });
        return functions.build();
    }

    @Override
    public ResolvedFunction decodeFunction(QualifiedName name) {
        return this.functionDecoder.fromQualifiedName(name).orElseThrow(() -> new IllegalArgumentException("Function is not resolved: " + name));
    }

    @Override
    public ResolvedFunction resolveBuiltinFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        return this.functionResolver.resolveBuiltinFunction(name, parameterTypes);
    }

    @Override
    public ResolvedFunction resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.functionResolver.resolveOperator(operatorType, argumentTypes);
    }

    @Override
    public ResolvedFunction getCoercion(OperatorType operatorType, Type fromType, Type toType) {
        return this.functionResolver.resolveCoercion(operatorType, fromType, toType);
    }

    @Override
    public ResolvedFunction getCoercion(CatalogSchemaFunctionName name, Type fromType, Type toType) {
        if (!GlobalFunctionCatalog.isBuiltinFunctionName(name)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("%s not found", name));
        }
        return this.functionResolver.resolveCoercion(name.getFunctionName(), fromType, toType);
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(Session session, CatalogHandle catalogHandle, FunctionId functionId, BoundSignature boundSignature) {
        if (LanguageFunctionManager.isTrinoSqlLanguageFunction(functionId)) {
            throw new IllegalArgumentException("Function dependencies for SQL functions must be fetched directly from the language manager");
        }
        if (catalogHandle.equals((Object)GlobalSystemConnector.CATALOG_HANDLE)) {
            return this.functions.getFunctionDependencies(functionId, boundSignature);
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        return this.getMetadata(session, catalogHandle).getFunctionDependencies(connectorSession, functionId, boundSignature);
    }

    @Override
    public Collection<CatalogFunctionMetadata> getFunctions(Session session, CatalogSchemaFunctionName name) {
        if (GlobalFunctionCatalog.isBuiltinFunctionName(name)) {
            return this.getBuiltinFunctions(name.getFunctionName());
        }
        return this.getOptionalCatalogMetadata(session, name.getCatalogName()).map(metadata -> this.getFunctions(session, metadata.getMetadata(session), metadata.getCatalogHandle(), name.getSchemaFunctionName())).orElse((List)ImmutableList.of());
    }

    private Collection<CatalogFunctionMetadata> getBuiltinFunctions(String functionName) {
        return (Collection)this.functions.getBuiltInFunctions(functionName).stream().map(function -> new CatalogFunctionMetadata(GlobalSystemConnector.CATALOG_HANDLE, "builtin", (FunctionMetadata)function)).collect(ImmutableList.toImmutableList());
    }

    private List<CatalogFunctionMetadata> getFunctions(Session session, ConnectorMetadata metadata, CatalogHandle catalogHandle, SchemaFunctionName name) {
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        ImmutableList.Builder functions = ImmutableList.builder();
        metadata.getFunctions(connectorSession, name).stream().map(function -> new CatalogFunctionMetadata(catalogHandle, name.getSchemaName(), (FunctionMetadata)function)).forEach(arg_0 -> ((ImmutableList.Builder)functions).add(arg_0));
        LanguageFunctionManager.RunAsIdentityLoader identityLoader = owner -> {
            CatalogSchemaFunctionName functionName = new CatalogSchemaFunctionName(catalogHandle.getCatalogName(), name);
            Optional<Object> systemIdentity = Optional.empty();
            if (this.getCatalogMetadata(session, catalogHandle).getSecurityManagement() == CatalogMetadata.SecurityManagement.SYSTEM) {
                systemIdentity = this.systemSecurityMetadata.getFunctionRunAsIdentity(session, functionName);
            }
            return (Identity)systemIdentity.or(() -> owner.map(Identity::ofUser)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "No identity for SECURITY DEFINER function: " + functionName));
        };
        this.languageFunctionManager.getFunctions(session, catalogHandle, name, (arg_0, arg_1) -> ((ConnectorMetadata)metadata).getLanguageFunctions(arg_0, arg_1), identityLoader).stream().map(function -> new CatalogFunctionMetadata(catalogHandle, name.getSchemaName(), (FunctionMetadata)function)).forEach(arg_0 -> ((ImmutableList.Builder)functions).add(arg_0));
        return functions.build();
    }

    @Override
    public AggregationFunctionMetadata getAggregationFunctionMetadata(Session session, ResolvedFunction resolvedFunction) {
        AggregationFunctionMetadata aggregationFunctionMetadata;
        Signature functionSignature;
        if (resolvedFunction.getCatalogHandle().equals((Object)GlobalSystemConnector.CATALOG_HANDLE)) {
            functionSignature = this.functions.getFunctionMetadata(resolvedFunction.getFunctionId()).getSignature();
            aggregationFunctionMetadata = this.functions.getAggregationFunctionMetadata(resolvedFunction.getFunctionId());
        } else {
            ConnectorSession connectorSession = session.toConnectorSession(resolvedFunction.getCatalogHandle());
            ConnectorMetadata metadata = this.getMetadata(session, resolvedFunction.getCatalogHandle());
            functionSignature = metadata.getFunctionMetadata(connectorSession, resolvedFunction.getFunctionId()).getSignature();
            aggregationFunctionMetadata = metadata.getAggregationFunctionMetadata(connectorSession, resolvedFunction.getFunctionId());
        }
        AggregationFunctionMetadata.AggregationFunctionMetadataBuilder builder = AggregationFunctionMetadata.builder();
        if (aggregationFunctionMetadata.isOrderSensitive()) {
            builder.orderSensitive();
        }
        if (!aggregationFunctionMetadata.getIntermediateTypes().isEmpty()) {
            FunctionBinding functionBinding = MetadataManager.toFunctionBinding(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionSignature);
            aggregationFunctionMetadata.getIntermediateTypes().stream().map(typeSignature -> SignatureBinder.applyBoundVariables(typeSignature, functionBinding)).forEach(arg_0 -> ((AggregationFunctionMetadata.AggregationFunctionMetadataBuilder)builder).intermediateType(arg_0));
        }
        return builder.build();
    }

    @Override
    public boolean languageFunctionExists(Session session, QualifiedObjectName name, String signatureToken) {
        return this.getOptionalCatalogMetadata(session, name.getCatalogName()).map(catalogMetadata -> {
            ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogHandle());
            return metadata.languageFunctionExists(connectorSession, name.asSchemaFunctionName(), signatureToken);
        }).orElse(false);
    }

    @Override
    public void createLanguageFunction(Session session, QualifiedObjectName name, LanguageFunction function, boolean replace) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, name.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createLanguageFunction(session.toConnectorSession(catalogHandle), name.asSchemaFunctionName(), function, replace);
    }

    @Override
    public void dropLanguageFunction(Session session, QualifiedObjectName name, String signatureToken) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, name.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropLanguageFunction(session.toConnectorSession(catalogHandle), name.asSchemaFunctionName(), signatureToken);
    }

    @VisibleForTesting
    public static FunctionBinding toFunctionBinding(FunctionId functionId, BoundSignature boundSignature, Signature functionSignature) {
        return SignatureBinder.bindFunction(functionId, functionSignature, boundSignature);
    }

    private Optional<CatalogMetadata> getOptionalCatalogMetadata(Session session, String catalogName) {
        Optional<CatalogMetadata> optionalCatalogMetadata = this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName);
        optionalCatalogMetadata.ifPresent(catalogMetadata -> this.registerCatalogForQuery(session, (CatalogMetadata)catalogMetadata));
        return optionalCatalogMetadata;
    }

    private CatalogMetadata getRequiredCatalogMetadata(Session session, String catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getRequiredCatalogMetadata(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadata(Session session, CatalogHandle catalogHandle) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadata(session.getRequiredTransactionId(), catalogHandle);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, String catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, CatalogHandle catalogHandle) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogHandle);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private ConnectorMetadata getMetadata(Session session, CatalogHandle catalogHandle) {
        return this.getCatalogMetadata(session, catalogHandle).getMetadataFor(session, catalogHandle);
    }

    private ConnectorMetadata getMetadataForWrite(Session session, CatalogHandle catalogHandle) {
        return this.getCatalogMetadataForWrite(session, catalogHandle).getMetadata(session);
    }

    private void registerCatalogForQuery(Session session, CatalogMetadata catalogMetadata) {
        this.catalogsByQueryId.computeIfAbsent(session.getQueryId(), queryId -> new QueryCatalogs(session)).registerCatalog(catalogMetadata);
    }

    @VisibleForTesting
    public Set<QueryId> getActiveQueryIds() {
        return ImmutableSet.copyOf(this.catalogsByQueryId.keySet());
    }

    @Override
    public OptionalInt getMaxWriterTasks(Session session, String catalogName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        if (catalog.isEmpty()) {
            return OptionalInt.empty();
        }
        CatalogMetadata catalogMetadata = catalog.get();
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle();
        return catalogMetadata.getMetadata(session).getMaxWriterTasks(session.toConnectorSession(catalogHandle));
    }

    @Override
    public WriterScalingOptions getNewTableWriterScalingOptions(Session session, QualifiedObjectName tableName, Map<String, Object> tableProperties) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        CatalogHandle catalogHandle = catalogMetadata.getCatalogHandle(session, tableName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogHandle);
        return metadata.getNewTableWriterScalingOptions(session.toConnectorSession(catalogHandle), tableName.asSchemaTableName(), tableProperties);
    }

    @Override
    public WriterScalingOptions getInsertWriterScalingOptions(Session session, TableHandle tableHandle) {
        ConnectorMetadata metadata = this.getMetadataForWrite(session, tableHandle.getCatalogHandle());
        return metadata.getInsertWriterScalingOptions(session.toConnectorSession(tableHandle.getCatalogHandle()), tableHandle.getConnectorHandle());
    }

    private Optional<ConnectorTableVersion> toConnectorVersion(Optional<TableVersion> version) {
        Optional<ConnectorTableVersion> connectorVersion = Optional.empty();
        if (version.isPresent()) {
            connectorVersion = Optional.of(new ConnectorTableVersion(version.get().getPointerType(), version.get().getObjectType(), version.get().getPointer()));
        }
        return connectorVersion;
    }

    private static boolean cannotExist(QualifiedTablePrefix prefix) {
        return prefix.getCatalogName().isEmpty() || prefix.getSchemaName().isPresent() && prefix.getSchemaName().get().isEmpty() || prefix.getTableName().isPresent() && prefix.getTableName().get().isEmpty();
    }

    private static boolean cannotExist(QualifiedObjectName name) {
        return name.getCatalogName().isEmpty() || name.getSchemaName().isEmpty() || name.getObjectName().isEmpty();
    }

    public static MetadataManager createTestMetadataManager() {
        return MetadataManager.testMetadataManagerBuilder().build();
    }

    public static TestMetadataManagerBuilder testMetadataManagerBuilder() {
        return new TestMetadataManagerBuilder();
    }

    private static class QueryCatalogs {
        private final Session session;
        @GuardedBy(value="this")
        private final Map<CatalogHandle, CatalogMetadata> catalogs = new HashMap<CatalogHandle, CatalogMetadata>();
        @GuardedBy(value="this")
        private boolean finished;

        public QueryCatalogs(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        private synchronized void registerCatalog(CatalogMetadata catalogMetadata) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Query is already finished");
            if (this.catalogs.putIfAbsent(catalogMetadata.getCatalogHandle(), catalogMetadata) == null) {
                ConnectorSession connectorSession = this.session.toConnectorSession(catalogMetadata.getCatalogHandle());
                catalogMetadata.getMetadata(this.session).beginQuery(connectorSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish() {
            ArrayList<CatalogMetadata> catalogs;
            QueryCatalogs queryCatalogs = this;
            synchronized (queryCatalogs) {
                Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Query is already finished");
                this.finished = true;
                catalogs = new ArrayList<CatalogMetadata>(this.catalogs.values());
            }
            for (CatalogMetadata catalogMetadata : catalogs) {
                ConnectorSession connectorSession = this.session.toConnectorSession(catalogMetadata.getCatalogHandle());
                catalogMetadata.getMetadata(this.session).cleanupQuery(connectorSession);
            }
        }
    }

    public static class TestMetadataManagerBuilder {
        private TransactionManager transactionManager;
        private TypeManager typeManager = InternalTypeManager.TESTING_TYPE_MANAGER;
        private GlobalFunctionCatalog globalFunctionCatalog;
        private LanguageFunctionManager languageFunctionManager;

        private TestMetadataManagerBuilder() {
        }

        public TestMetadataManagerBuilder withTransactionManager(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
            return this;
        }

        public TestMetadataManagerBuilder withTypeManager(TypeManager typeManager) {
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            return this;
        }

        public TestMetadataManagerBuilder withGlobalFunctionCatalog(GlobalFunctionCatalog globalFunctionCatalog) {
            this.globalFunctionCatalog = globalFunctionCatalog;
            return this;
        }

        public TestMetadataManagerBuilder withLanguageFunctionManager(LanguageFunctionManager languageFunctionManager) {
            this.languageFunctionManager = languageFunctionManager;
            return this;
        }

        public MetadataManager build() {
            GlobalFunctionCatalog globalFunctionCatalog;
            TransactionManager transactionManager = this.transactionManager;
            if (transactionManager == null) {
                transactionManager = InMemoryTransactionManager.createTestTransactionManager();
            }
            if ((globalFunctionCatalog = this.globalFunctionCatalog) == null) {
                globalFunctionCatalog = new GlobalFunctionCatalog();
                TypeOperators typeOperators = new TypeOperators();
                globalFunctionCatalog.addFunctions(SystemFunctionBundle.create(new FeaturesConfig(), typeOperators, new BlockTypeOperators(typeOperators), NodeVersion.UNKNOWN));
                globalFunctionCatalog.addFunctions(new InternalFunctionBundle(new LiteralFunction(new InternalBlockEncodingSerde(new BlockEncodingManager(), this.typeManager))));
            }
            if (this.languageFunctionManager == null) {
                this.languageFunctionManager = new LanguageFunctionManager(new SqlParser(), this.typeManager, user -> ImmutableSet.of());
            }
            return new MetadataManager(new DisabledSystemSecurityMetadata(), transactionManager, globalFunctionCatalog, this.languageFunctionManager, this.typeManager);
        }
    }
}

