/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public class QualifiedObjectName {
    private static final Pattern UNQUOTED_COMPONENT = Pattern.compile("[a-zA-Z0-9_]+");
    private static final String COMPONENT = UNQUOTED_COMPONENT.pattern() + "|\"([^\"]|\"\")*\"";
    private static final Pattern PATTERN = Pattern.compile("(?<catalog>" + COMPONENT + ")\\.(?<schema>" + COMPONENT + ")\\.(?<table>" + COMPONENT + ")");
    private final String catalogName;
    private final String schemaName;
    private final String objectName;

    @JsonCreator
    public static QualifiedObjectName valueOf(String name) {
        Objects.requireNonNull(name, "name is null");
        Matcher matcher = PATTERN.matcher(name);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid name %s", (Object)name);
        return new QualifiedObjectName(QualifiedObjectName.unquoteIfNeeded(matcher.group("catalog")), QualifiedObjectName.unquoteIfNeeded(matcher.group("schema")), QualifiedObjectName.unquoteIfNeeded(matcher.group("table")));
    }

    public QualifiedObjectName(String catalogName, String schemaName, String objectName) {
        MetadataUtil.checkObjectName(catalogName, schemaName, objectName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.objectName = objectName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public SchemaTableName asSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.objectName);
    }

    public CatalogSchemaTableName asCatalogSchemaTableName() {
        return new CatalogSchemaTableName(this.catalogName, this.schemaName, this.objectName);
    }

    public SchemaRoutineName asSchemaRoutineName() {
        return new SchemaRoutineName(this.schemaName, this.objectName);
    }

    public CatalogSchemaRoutineName asCatalogSchemaRoutineName() {
        return new CatalogSchemaRoutineName(this.catalogName, this.schemaName, this.objectName);
    }

    public QualifiedTablePrefix asQualifiedTablePrefix() {
        return new QualifiedTablePrefix(this.catalogName, this.schemaName, this.objectName);
    }

    public SchemaFunctionName asSchemaFunctionName() {
        return new SchemaFunctionName(this.schemaName, this.objectName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedObjectName o = (QualifiedObjectName)obj;
        return Objects.equals(this.catalogName, o.catalogName) && Objects.equals(this.schemaName, o.schemaName) && Objects.equals(this.objectName, o.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.objectName);
    }

    @JsonValue
    public String toString() {
        return QualifiedObjectName.quoteIfNeeded(this.catalogName) + "." + QualifiedObjectName.quoteIfNeeded(this.schemaName) + "." + QualifiedObjectName.quoteIfNeeded(this.objectName);
    }

    public static Function<SchemaTableName, QualifiedObjectName> convertFromSchemaTableName(String catalogName) {
        return input -> new QualifiedObjectName(catalogName, input.getSchemaName(), input.getTableName());
    }

    private static String unquoteIfNeeded(String name) {
        if (name.isEmpty() || name.charAt(0) != '\"') {
            return name;
        }
        Preconditions.checkArgument((name.charAt(name.length() - 1) == '\"' ? 1 : 0) != 0, (String)"Invalid name: [%s]", (Object)name);
        return name.substring(1, name.length() - 1).replace("\"\"", "\"");
    }

    private static String quoteIfNeeded(String name) {
        if (UNQUOTED_COMPONENT.matcher(name).matches()) {
            return name;
        }
        return "\"" + name.replace("\"", "\"\"") + "\"";
    }
}

