/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import io.trino.operator.aggregation.arrayagg.ArrayAggregationState;
import io.trino.operator.aggregation.arrayagg.SingleArrayAggregationState;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;

public class ArrayAggregationStateSerializer
implements AccumulatorStateSerializer<ArrayAggregationState> {
    private final Type arrayType;

    public ArrayAggregationStateSerializer(@TypeParameter(value="T") Type elementType) {
        this.arrayType = new ArrayType(elementType);
    }

    public Type getSerializedType() {
        return this.arrayType;
    }

    public void serialize(ArrayAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            ((ArrayBlockBuilder)out).buildEntry(state::writeAll);
        }
    }

    public void deserialize(Block block, int index, ArrayAggregationState state) {
        ((SingleArrayAggregationState)state).setTempDeserializeBlock((Block)this.arrayType.getObject(block, index));
    }
}

