/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import io.trino.operator.aggregation.histogram.GroupedHistogramState;
import io.trino.operator.aggregation.histogram.HistogramState;
import io.trino.operator.aggregation.histogram.SingleHistogramState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class HistogramStateFactory
implements AccumulatorStateFactory<HistogramState> {
    private final Type type;
    private final MethodHandle readFlat;
    private final MethodHandle writeFlat;
    private final MethodHandle hashFlat;
    private final MethodHandle distinctFlatBlock;
    private final MethodHandle hashBlock;

    public HistogramStateFactory(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle readFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle writeFlat, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle hashFlat, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle distinctFlatBlock, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle hashBlock) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.readFlat = Objects.requireNonNull(readFlat, "readFlat is null");
        this.writeFlat = Objects.requireNonNull(writeFlat, "writeFlat is null");
        this.hashFlat = Objects.requireNonNull(hashFlat, "hashFlat is null");
        this.distinctFlatBlock = Objects.requireNonNull(distinctFlatBlock, "distinctFlatBlock is null");
        this.hashBlock = Objects.requireNonNull(hashBlock, "hashBlock is null");
    }

    public HistogramState createSingleState() {
        return new SingleHistogramState(this.type, this.readFlat, this.writeFlat, this.hashFlat, this.distinctFlatBlock, this.hashBlock);
    }

    public HistogramState createGroupedState() {
        return new GroupedHistogramState(this.type, this.readFlat, this.writeFlat, this.hashFlat, this.distinctFlatBlock, this.hashBlock);
    }
}

