/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.operator.ReferenceCount;
import io.trino.operator.join.JoinBridge;
import io.trino.operator.join.OuterPositionIterator;
import io.trino.operator.join.PartitionedLookupSourceFactory;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class JoinBridgeManager<T extends JoinBridge> {
    private final List<Type> buildOutputTypes;
    private final boolean buildOuter;
    private final T joinBridge;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private JoinLifecycle joinLifecycle;
    private final FreezeOnReadCounter probeFactoryCount = new FreezeOnReadCounter();

    @VisibleForTesting
    public static JoinBridgeManager<PartitionedLookupSourceFactory> lookupAllAtOnce(PartitionedLookupSourceFactory factory) {
        return new JoinBridgeManager<PartitionedLookupSourceFactory>(false, factory, factory.getOutputTypes());
    }

    public JoinBridgeManager(boolean buildOuter, T joinBridge, List<Type> buildOutputTypes) {
        this.buildOuter = buildOuter;
        this.joinBridge = (JoinBridge)Objects.requireNonNull(joinBridge, "joinBridge is null");
        this.buildOutputTypes = Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary() {
        if (!this.initialized.get()) {
            JoinBridgeManager joinBridgeManager = this;
            synchronized (joinBridgeManager) {
                if (this.initialized.get()) {
                    return;
                }
                int finalProbeFactoryCount = this.probeFactoryCount.get();
                this.joinLifecycle = new JoinLifecycle((JoinBridge)this.joinBridge, finalProbeFactoryCount, this.buildOuter ? 1 : 0);
                this.initialized.set(true);
            }
        }
    }

    public List<Type> getBuildOutputTypes() {
        return this.buildOutputTypes;
    }

    public void incrementProbeFactoryCount() {
        this.probeFactoryCount.increment();
    }

    public T getJoinBridge() {
        this.initializeIfNecessary();
        return this.joinBridge;
    }

    public void probeOperatorFactoryClosed() {
        this.initializeIfNecessary();
        this.joinLifecycle.releaseForProbe();
    }

    public void probeOperatorCreated() {
        this.initializeIfNecessary();
        this.joinLifecycle.retainForProbe();
    }

    public void probeOperatorClosed() {
        this.initializeIfNecessary();
        this.joinLifecycle.releaseForProbe();
    }

    public void outerOperatorFactoryClosed() {
        this.initializeIfNecessary();
        this.joinLifecycle.releaseForOuter();
    }

    public void outerOperatorCreated() {
        this.initializeIfNecessary();
        this.joinLifecycle.retainForOuter();
    }

    public void outerOperatorClosed() {
        this.initializeIfNecessary();
        this.joinLifecycle.releaseForOuter();
    }

    public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture() {
        this.initializeIfNecessary();
        return Futures.transform(this.joinLifecycle.whenBuildAndProbeFinishes(), ignored -> this.joinBridge.getOuterPositionIterator(), (Executor)MoreExecutors.directExecutor());
    }

    private static class FreezeOnReadCounter {
        private int count;
        private boolean frozen;

        private FreezeOnReadCounter() {
        }

        public synchronized void increment() {
            Preconditions.checkState((!this.frozen ? 1 : 0) != 0, (Object)"Counter has been read");
            ++this.count;
        }

        public synchronized int get() {
            this.frozen = true;
            return this.count;
        }
    }

    private static class JoinLifecycle {
        private final ReferenceCount probeReferenceCount;
        private final ReferenceCount outerReferenceCount;
        private final ListenableFuture<Void> whenBuildAndProbeFinishes;
        private final ListenableFuture<Void> whenAllFinishes;

        public JoinLifecycle(JoinBridge joinBridge, int probeFactoryCount, int outerFactoryCount) {
            Preconditions.checkArgument((outerFactoryCount == 0 || outerFactoryCount == 1 ? 1 : 0) != 0);
            this.outerReferenceCount = new ReferenceCount(outerFactoryCount);
            this.probeReferenceCount = new ReferenceCount(probeFactoryCount);
            this.whenBuildAndProbeFinishes = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{joinBridge.whenBuildFinishes(), this.probeReferenceCount.getFreeFuture()}).call(() -> null, MoreExecutors.directExecutor());
            this.whenAllFinishes = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{this.whenBuildAndProbeFinishes, this.outerReferenceCount.getFreeFuture()}).call(() -> null, MoreExecutors.directExecutor());
            this.whenAllFinishes.addListener(joinBridge::destroy, MoreExecutors.directExecutor());
        }

        public ListenableFuture<Void> whenBuildAndProbeFinishes() {
            return this.whenBuildAndProbeFinishes;
        }

        private void retainForProbe() {
            this.probeReferenceCount.retain();
        }

        private void releaseForProbe() {
            this.probeReferenceCount.release();
        }

        private void retainForOuter() {
            this.outerReferenceCount.retain();
        }

        private void releaseForOuter() {
            this.outerReferenceCount.release();
        }
    }
}

