/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.security.SecurityException;
import io.trino.server.security.jwt.JwkService;
import java.security.Key;
import java.util.Objects;

public class JwkSigningKeyResolver
implements SigningKeyResolver {
    private final JwkService keys;

    public JwkSigningKeyResolver(JwkService keys) {
        this.keys = Objects.requireNonNull(keys, "keys is null");
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.getKey(header);
    }

    public Key resolveSigningKey(JwsHeader header, byte[] plaintext) {
        return this.getKey(header);
    }

    private Key getKey(JwsHeader header) {
        String keyId = header.getKeyId();
        if (keyId == null) {
            throw new SecurityException("Key ID is required");
        }
        return this.keys.getKey(keyId).orElseThrow(() -> new SecurityException("Unknown signing key ID"));
    }
}

