/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.security.Keys;
import io.trino.server.ServletSecurityUtils;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.jwt.JwtUtil;
import io.trino.server.ui.ForWebUi;
import io.trino.server.ui.FormAuthenticator;
import io.trino.server.ui.FormWebUiConfig;
import io.trino.server.ui.WebUiAuthenticationFilter;
import io.trino.spi.security.Identity;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.crypto.SecretKey;

public class FormWebUiAuthenticationFilter
implements WebUiAuthenticationFilter {
    private static final String TRINO_UI_AUDIENCE = "trino-ui";
    private static final String TRINO_UI_COOKIE = "Trino-UI-Token";
    static final String TRINO_FORM_LOGIN = "Trino-Form-Login";
    static final String LOGIN_FORM = "/ui/login.html";
    static final URI LOGIN_FORM_URI = URI.create("/ui/login.html");
    static final String DISABLED_LOCATION = "/ui/disabled.html";
    static final URI DISABLED_LOCATION_URI = URI.create("/ui/disabled.html");
    public static final String UI_LOCATION = "/ui/";
    static final URI UI_LOCATION_URI = URI.create("/ui/");
    static final String UI_LOGIN = "/ui/login";
    static final String UI_LOGOUT = "/ui/logout";
    private final JwtParser jwtParser;
    private final Function<String, String> jwtGenerator;
    private final FormAuthenticator formAuthenticator;
    private final Optional<Authenticator> authenticator;

    @Inject
    public FormWebUiAuthenticationFilter(FormWebUiConfig config, FormAuthenticator formAuthenticator, @ForWebUi Optional<Authenticator> authenticator) {
        byte[] hmacBytes;
        if (config.getSharedSecret().isPresent()) {
            hmacBytes = Hashing.sha256().hashString((CharSequence)config.getSharedSecret().get(), StandardCharsets.UTF_8).asBytes();
        } else {
            hmacBytes = new byte[32];
            new SecureRandom().nextBytes(hmacBytes);
        }
        SecretKey hmac = Keys.hmacShaKeyFor((byte[])hmacBytes);
        this.jwtParser = JwtUtil.newJwtParserBuilder().setSigningKey((Key)hmac).requireAudience(TRINO_UI_AUDIENCE).build();
        long sessionTimeoutNanos = config.getSessionTimeout().roundTo(TimeUnit.NANOSECONDS);
        this.jwtGenerator = username -> FormWebUiAuthenticationFilter.generateJwt(hmac, username, sessionTimeoutNanos);
        this.formAuthenticator = Objects.requireNonNull(formAuthenticator, "formAuthenticator is null");
        this.authenticator = Objects.requireNonNull(authenticator, "authenticator is null");
    }

    public void filter(ContainerRequestContext request) {
        String path = request.getUriInfo().getRequestUri().getPath();
        if (path.equals(DISABLED_LOCATION)) {
            return;
        }
        if (this.authenticator.isPresent() && request.getSecurityContext().isSecure()) {
            FormWebUiAuthenticationFilter.handleProtocolLoginRequest(this.authenticator.get(), request);
            return;
        }
        if (path.equals(UI_LOGIN) && request.getMethod().equals("POST") || path.equals(UI_LOGOUT)) {
            return;
        }
        Optional<String> username = this.getAuthenticatedUsername(request);
        if (username.isPresent()) {
            if (path.equals(LOGIN_FORM)) {
                request.abortWith(FormWebUiAuthenticationFilter.redirectFromSuccessfulLoginResponse(request.getUriInfo().getRequestUri().getQuery()).build());
                return;
            }
            ServletSecurityUtils.setAuthenticatedIdentity(request, username.get());
            return;
        }
        if (path.startsWith("/ui/api/")) {
            ServletSecurityUtils.sendWwwAuthenticate(request, "Unauthorized", (Collection<String>)ImmutableSet.of((Object)TRINO_FORM_LOGIN));
            return;
        }
        if (!this.isAuthenticationEnabled(request.getSecurityContext().isSecure())) {
            request.abortWith(Response.seeOther((URI)DISABLED_LOCATION_URI).build());
            return;
        }
        if (path.equals(LOGIN_FORM)) {
            return;
        }
        request.abortWith(Response.seeOther((URI)LOGIN_FORM_URI).build());
        request.abortWith(Response.seeOther((URI)FormWebUiAuthenticationFilter.buildLoginFormURI(request.getUriInfo())).build());
    }

    private static URI buildLoginFormURI(UriInfo uriInfo) {
        UriBuilder builder = uriInfo.getRequestUriBuilder().uri(LOGIN_FORM_URI);
        Object path = uriInfo.getRequestUri().getPath();
        if (!Strings.isNullOrEmpty((String)uriInfo.getRequestUri().getQuery())) {
            path = (String)path + "?" + uriInfo.getRequestUri().getQuery();
        }
        if (((String)path).equals("/ui") || ((String)path).equals(UI_LOCATION)) {
            return builder.build(new Object[0]);
        }
        try {
            builder.uri(new URI(null, null, null, (String)path, null));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return builder.build(new Object[0]);
    }

    private static void handleProtocolLoginRequest(Authenticator authenticator, ContainerRequestContext request) {
        Identity authenticatedIdentity;
        try {
            authenticatedIdentity = authenticator.authenticate(request);
        }
        catch (AuthenticationException e) {
            ServletSecurityUtils.sendWwwAuthenticate(request, (String)MoreObjects.firstNonNull((Object)e.getMessage(), (Object)"Unauthorized"), (Collection)e.getAuthenticateHeader().map(ImmutableSet::of).orElse(ImmutableSet.of()));
            return;
        }
        if (FormWebUiAuthenticationFilter.redirectFormLoginToUi(request)) {
            return;
        }
        ServletSecurityUtils.setAuthenticatedIdentity(request, authenticatedIdentity);
    }

    private static boolean redirectFormLoginToUi(ContainerRequestContext request) {
        String path = request.getUriInfo().getRequestUri().getPath();
        if (path.equals(LOGIN_FORM) || path.equals(UI_LOGIN) || path.equals(UI_LOGOUT)) {
            request.abortWith(Response.seeOther((URI)UI_LOCATION_URI).build());
            return true;
        }
        return false;
    }

    public static Response.ResponseBuilder redirectFromSuccessfulLoginResponse(String redirectPath) {
        URI redirectLocation = UI_LOCATION_URI;
        if ((redirectPath = Strings.emptyToNull((String)redirectPath)) != null) {
            try {
                redirectLocation = new URI(redirectPath);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return Response.seeOther((URI)redirectLocation);
    }

    public Optional<NewCookie> checkLoginCredentials(String username, String password, boolean secure) {
        return this.formAuthenticator.isValidCredential(username, password, secure).map(user -> this.createAuthenticationCookie((String)user, secure));
    }

    private Optional<String> getAuthenticatedUsername(ContainerRequestContext request) {
        Cookie cookie = (Cookie)request.getCookies().get(TRINO_UI_COOKIE);
        if (cookie == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.parseJwt(cookie.getValue()));
        }
        catch (JwtException e) {
            return Optional.empty();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    private NewCookie createAuthenticationCookie(String userName, boolean secure) {
        String jwt = this.jwtGenerator.apply(userName);
        return new NewCookie(TRINO_UI_COOKIE, jwt, "/ui", null, 1, null, -1, null, secure, true);
    }

    public static NewCookie getDeleteCookie(boolean secure) {
        return new NewCookie(TRINO_UI_COOKIE, "delete", "/ui", null, 1, null, 0, null, secure, true);
    }

    public boolean isPasswordAllowed(boolean secure) {
        return this.formAuthenticator.isPasswordAllowed(secure);
    }

    boolean isAuthenticationEnabled(boolean secure) {
        return this.formAuthenticator.isLoginEnabled(secure) || this.authenticator.isPresent();
    }

    private static String generateJwt(Key hmac, String username, long sessionTimeoutNanos) {
        return ((JwtBuilder)((JwtBuilder)((JwtBuilder)JwtUtil.newJwtBuilder().signWith(hmac).setSubject(username)).setExpiration(Date.from(ZonedDateTime.now().plusNanos(sessionTimeoutNanos).toInstant()))).setAudience(TRINO_UI_AUDIENCE)).compact();
    }

    private String parseJwt(String jwt) {
        return ((Claims)this.jwtParser.parseClaimsJws((CharSequence)jwt).getBody()).getSubject();
    }

    public static boolean redirectAllFormLoginToUi(ContainerRequestContext request) {
        String path = request.getUriInfo().getRequestUri().getPath();
        if (path.equals(LOGIN_FORM) || path.equals(UI_LOGIN) || path.equals(UI_LOGOUT)) {
            request.abortWith(Response.seeOther((URI)UI_LOCATION_URI).build());
            return true;
        }
        return false;
    }
}

