/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import io.trino.Session;
import io.trino.cache.CacheUtils;
import io.trino.cache.SafeCaches;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionResolver;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.NodeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.CanonicalizationAware;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.ExpressionAnalysis;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.JsonPathAnalyzer;
import io.trino.sql.analyzer.PatternRecognitionAnalyzer;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.StatementAnalyzer;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.planner.LiteralInterpreter;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BindExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.ProcessingMode;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StackableAstVisitor;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.TimeLiteral;
import io.trino.sql.tree.TimestampLiteral;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.type.ArrayParametricType;
import io.trino.type.DateTimes;
import io.trino.type.FunctionType;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.Json2016Type;
import io.trino.type.JsonType;
import io.trino.type.TypeCoercion;
import io.trino.type.UnknownType;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public class ExpressionAnalyzer {
    private static final int MAX_NUMBER_GROUPING_ARGUMENTS_BIGINT = 63;
    private static final int MAX_NUMBER_GROUPING_ARGUMENTS_INTEGER = 31;
    private static final CatalogSchemaFunctionName ARRAY_CONSTRUCTOR_NAME = GlobalFunctionCatalog.builtinFunctionName("$array");
    public static final RowType JSON_NO_PARAMETERS_ROW_TYPE = RowType.anonymous((List)ImmutableList.of((Object)((Object)UnknownType.UNKNOWN)));
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final BiFunction<Node, CorrelationSupport, StatementAnalyzer> statementAnalyzerFactory;
    private final LiteralInterpreter literalInterpreter;
    private final TypeProvider symbolTypes;
    private final boolean isDescribe;
    private final Cache<String, Type> varcharCastableTypeCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));
    private final Map<NodeRef<Expression>, ResolvedFunction> resolvedFunctions = new LinkedHashMap<NodeRef<Expression>, ResolvedFunction>();
    private final Set<NodeRef<SubqueryExpression>> subqueries = new LinkedHashSet<NodeRef<SubqueryExpression>>();
    private final Set<NodeRef<ExistsPredicate>> existsSubqueries = new LinkedHashSet<NodeRef<ExistsPredicate>>();
    private final Map<NodeRef<Expression>, Type> expressionCoercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<Expression>> typeOnlyCoercions = new LinkedHashSet<NodeRef<Expression>>();
    private final Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundCalculation = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> sortKeyCoercionsForFrameBoundComparison = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, ResolvedFunction> frameBoundCalculations = new LinkedHashMap<NodeRef<Expression>, ResolvedFunction>();
    private final Set<NodeRef<InPredicate>> subqueryInPredicates = new LinkedHashSet<NodeRef<InPredicate>>();
    private final Map<NodeRef<Expression>, Analysis.PredicateCoercions> predicateCoercions = new LinkedHashMap<NodeRef<Expression>, Analysis.PredicateCoercions>();
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences = new LinkedHashMap<NodeRef<Expression>, ResolvedField>();
    private final Map<NodeRef<Expression>, Type> expressionTypes = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons = new LinkedHashSet<NodeRef<QuantifiedComparisonExpression>>();
    private final Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences = new LinkedHashMap<NodeRef<Identifier>, LambdaArgumentDeclaration>();
    private final Set<NodeRef<FunctionCall>> windowFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Multimap<QualifiedObjectName, String> tableColumnReferences = HashMultimap.create();
    private final Multimap<NodeRef<Node>, Field> referencedFields = HashMultimap.create();
    private final Map<NodeRef<DereferenceExpression>, LabelPrefixedReference> labelDereferences = new LinkedHashMap<NodeRef<DereferenceExpression>, LabelPrefixedReference>();
    private final Set<NodeRef<FunctionCall>> patternRecognitionFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges = new LinkedHashMap<NodeRef<RangeQuantifier>, Analysis.Range>();
    private final Map<NodeRef<RowPattern>, Set<String>> undefinedLabels = new LinkedHashMap<NodeRef<RowPattern>, Set<String>>();
    private final Map<NodeRef<WindowOperation>, MeasureDefinition> measureDefinitions = new LinkedHashMap<NodeRef<WindowOperation>, MeasureDefinition>();
    private final Set<NodeRef<FunctionCall>> patternAggregations = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Map<NodeRef<Expression>, JsonPathAnalyzer.JsonPathAnalysis> jsonPathAnalyses = new LinkedHashMap<NodeRef<Expression>, JsonPathAnalyzer.JsonPathAnalysis>();
    private final Map<NodeRef<Expression>, ResolvedFunction> jsonInputFunctions = new LinkedHashMap<NodeRef<Expression>, ResolvedFunction>();
    private final Map<NodeRef<Expression>, ResolvedFunction> jsonOutputFunctions = new LinkedHashMap<NodeRef<Expression>, ResolvedFunction>();
    private final Session session;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private final WarningCollector warningCollector;
    private final TypeCoercion typeCoercion;
    private final Function<Expression, Type> getPreanalyzedType;
    private final Function<Node, Analysis.ResolvedWindow> getResolvedWindow;
    private final List<Field> sourceFields = new ArrayList<Field>();
    private final FunctionResolver functionResolver;

    private ExpressionAnalyzer(PlannerContext plannerContext, AccessControl accessControl, StatementAnalyzerFactory statementAnalyzerFactory, Analysis analysis, Session session, TypeProvider types, WarningCollector warningCollector) {
        this(plannerContext, accessControl, (node, correlationSupport) -> statementAnalyzerFactory.createStatementAnalyzer(analysis, session, warningCollector, (CorrelationSupport)((Object)correlationSupport)), session, types, analysis.getParameters(), warningCollector, analysis.isDescribe(), analysis::getType, analysis::getWindow);
    }

    ExpressionAnalyzer(PlannerContext plannerContext, AccessControl accessControl, BiFunction<Node, CorrelationSupport, StatementAnalyzer> statementAnalyzerFactory, Session session, TypeProvider symbolTypes, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, boolean isDescribe, Function<Expression, Type> getPreanalyzedType, Function<Node, Analysis.ResolvedWindow> getResolvedWindow) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.literalInterpreter = new LiteralInterpreter(plannerContext, session);
        this.session = Objects.requireNonNull(session, "session is null");
        this.symbolTypes = Objects.requireNonNull(symbolTypes, "symbolTypes is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.isDescribe = isDescribe;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        this.getPreanalyzedType = Objects.requireNonNull(getPreanalyzedType, "getPreanalyzedType is null");
        this.getResolvedWindow = Objects.requireNonNull(getResolvedWindow, "getResolvedWindow is null");
        this.functionResolver = plannerContext.getFunctionResolver(warningCollector);
    }

    public Map<NodeRef<Expression>, ResolvedFunction> getResolvedFunctions() {
        return Collections.unmodifiableMap(this.resolvedFunctions);
    }

    public Map<NodeRef<Expression>, Type> getExpressionTypes() {
        return Collections.unmodifiableMap(this.expressionTypes);
    }

    public Type setExpressionType(Expression expression, Type type) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.expressionTypes.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        return type;
    }

    private Type getExpressionType(Expression expression) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Type type = this.expressionTypes.get(NodeRef.of((Node)expression));
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Expression not yet analyzed: %s", (Object)expression);
        return type;
    }

    public Map<NodeRef<Expression>, Type> getExpressionCoercions() {
        return Collections.unmodifiableMap(this.expressionCoercions);
    }

    public Set<NodeRef<Expression>> getTypeOnlyCoercions() {
        return Collections.unmodifiableSet(this.typeOnlyCoercions);
    }

    public Map<NodeRef<Expression>, Type> getSortKeyCoercionsForFrameBoundCalculation() {
        return Collections.unmodifiableMap(this.sortKeyCoercionsForFrameBoundCalculation);
    }

    public Map<NodeRef<Expression>, Type> getSortKeyCoercionsForFrameBoundComparison() {
        return Collections.unmodifiableMap(this.sortKeyCoercionsForFrameBoundComparison);
    }

    public Map<NodeRef<Expression>, ResolvedFunction> getFrameBoundCalculations() {
        return Collections.unmodifiableMap(this.frameBoundCalculations);
    }

    public Set<NodeRef<InPredicate>> getSubqueryInPredicates() {
        return Collections.unmodifiableSet(this.subqueryInPredicates);
    }

    public Map<NodeRef<Expression>, Analysis.PredicateCoercions> getPredicateCoercions() {
        return Collections.unmodifiableMap(this.predicateCoercions);
    }

    public Map<NodeRef<Expression>, ResolvedField> getColumnReferences() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public Map<NodeRef<Identifier>, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return Collections.unmodifiableMap(this.lambdaArgumentReferences);
    }

    public Type analyze(Expression expression, Scope scope) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)Context.notInLambda(scope, CorrelationSupport.ALLOWED)));
    }

    public Type analyze(Expression expression, Scope scope, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)Context.notInLambda(scope, correlationSupport)));
    }

    private Type analyze(Expression expression, Scope scope, Set<String> labels) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)Context.patternRecognition(scope, labels)));
    }

    private Type analyze(Expression expression, Scope baseScope, Context context) {
        Visitor visitor = new Visitor(baseScope, this.warningCollector);
        return visitor.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)context));
    }

    private void analyzeWindow(Analysis.ResolvedWindow window, Scope scope, Node originalNode, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        visitor.analyzeWindow(window, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)Context.notInLambda(scope, correlationSupport)), originalNode);
    }

    public Set<NodeRef<SubqueryExpression>> getSubqueries() {
        return Collections.unmodifiableSet(this.subqueries);
    }

    public Set<NodeRef<ExistsPredicate>> getExistsSubqueries() {
        return Collections.unmodifiableSet(this.existsSubqueries);
    }

    public Set<NodeRef<QuantifiedComparisonExpression>> getQuantifiedComparisons() {
        return Collections.unmodifiableSet(this.quantifiedComparisons);
    }

    public Set<NodeRef<FunctionCall>> getWindowFunctions() {
        return Collections.unmodifiableSet(this.windowFunctions);
    }

    public Multimap<QualifiedObjectName, String> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public List<Field> getSourceFields() {
        return this.sourceFields;
    }

    public Map<NodeRef<DereferenceExpression>, LabelPrefixedReference> getLabelDereferences() {
        return this.labelDereferences;
    }

    public Set<NodeRef<FunctionCall>> getPatternRecognitionFunctions() {
        return this.patternRecognitionFunctions;
    }

    public Map<NodeRef<RangeQuantifier>, Analysis.Range> getRanges() {
        return this.ranges;
    }

    public Map<NodeRef<RowPattern>, Set<String>> getUndefinedLabels() {
        return this.undefinedLabels;
    }

    public Map<NodeRef<WindowOperation>, MeasureDefinition> getMeasureDefinitions() {
        return this.measureDefinitions;
    }

    public Set<NodeRef<FunctionCall>> getPatternAggregations() {
        return this.patternAggregations;
    }

    public Map<NodeRef<Expression>, JsonPathAnalyzer.JsonPathAnalysis> getJsonPathAnalyses() {
        return this.jsonPathAnalyses;
    }

    public Map<NodeRef<Expression>, ResolvedFunction> getJsonInputFunctions() {
        return this.jsonInputFunctions;
    }

    public Map<NodeRef<Expression>, ResolvedFunction> getJsonOutputFunctions() {
        return this.jsonOutputFunctions;
    }

    public static boolean isPatternRecognitionFunction(FunctionCall node) {
        QualifiedName qualifiedName = node.getName();
        if (qualifiedName.getParts().size() > 1) {
            return false;
        }
        Identifier identifier = (Identifier)qualifiedName.getOriginalParts().get(0);
        if (identifier.isDelimited()) {
            return false;
        }
        String name = identifier.getValue().toUpperCase(Locale.ENGLISH);
        return name.equals("FIRST") || name.equals("LAST") || name.equals("PREV") || name.equals("NEXT") || name.equals("CLASSIFIER") || name.equals("MATCH_NUMBER");
    }

    public static ExpressionAnalysis analyzePatternRecognitionExpression(Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector, Set<String> labels) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, TypeProvider.empty(), warningCollector);
        analyzer.analyze(expression, scope, labels);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalysis analyzeExpressions(Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, TypeProvider types, Iterable<Expression> expressions, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, QueryType queryType) {
        Analysis analysis = new Analysis(null, parameters, queryType);
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, types, warningCollector);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(new Field[0])).build());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalysis analyzeExpression(Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, TypeProvider.empty(), warningCollector);
        analyzer.analyze(expression, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        analysis.addExpressionFields(expression, analyzer.getSourceFields());
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static void analyzeExpressionWithoutSubqueries(Session session, PlannerContext plannerContext, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, ErrorCodeSupplier errorCode, String message, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, (node, ignored) -> {
            throw SemanticExceptions.semanticException(errorCode, node, "%s", message);
        }, session, TypeProvider.empty(), analysis.getParameters(), warningCollector, analysis.isDescribe(), analysis::getType, analysis::getWindow);
        analyzer.analyze(expression, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        analysis.addExpressionFields(expression, analyzer.getSourceFields());
    }

    public static ExpressionAnalysis analyzeWindow(Session session, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, WarningCollector warningCollector, CorrelationSupport correlationSupport, Analysis.ResolvedWindow window, Node originalNode) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(plannerContext, accessControl, statementAnalyzerFactory, analysis, session, TypeProvider.empty(), warningCollector);
        analyzer.analyzeWindow(window, scope, originalNode, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getTypeOnlyCoercions(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    private static void updateAnalysis(Analysis analysis, ExpressionAnalyzer analyzer, Session session, AccessControl accessControl) {
        analysis.addTypes(analyzer.getExpressionTypes());
        analysis.addCoercions(analyzer.getExpressionCoercions(), analyzer.getTypeOnlyCoercions(), analyzer.getSortKeyCoercionsForFrameBoundCalculation(), analyzer.getSortKeyCoercionsForFrameBoundComparison());
        analysis.addFrameBoundCalculations(analyzer.getFrameBoundCalculations());
        analyzer.getResolvedFunctions().forEach((key, value) -> analysis.addResolvedFunction((Expression)key.getNode(), (ResolvedFunction)value, session.getUser()));
        analysis.addColumnReferences(analyzer.getColumnReferences());
        analysis.addLambdaArgumentReferences(analyzer.getLambdaArgumentReferences());
        analysis.addTableColumnReferences(accessControl, session.getIdentity(), analyzer.getTableColumnReferences());
        analysis.addLabelDereferences(analyzer.getLabelDereferences());
        analysis.addPatternRecognitionFunctions(analyzer.getPatternRecognitionFunctions());
        analysis.setRanges(analyzer.getRanges());
        analysis.setUndefinedLabels(analyzer.getUndefinedLabels());
        analysis.setMeasureDefinitions(analyzer.getMeasureDefinitions());
        analysis.setPatternAggregations(analyzer.getPatternAggregations());
        analysis.setJsonPathAnalyses(analyzer.getJsonPathAnalyses());
        analysis.setJsonInputFunctions(analyzer.getJsonInputFunctions());
        analysis.setJsonOutputFunctions(analyzer.getJsonOutputFunctions());
        analysis.addPredicateCoercions(analyzer.getPredicateCoercions());
    }

    public static ExpressionAnalyzer createConstantAnalyzer(PlannerContext plannerContext, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector) {
        return ExpressionAnalyzer.createWithoutSubqueries(plannerContext, accessControl, session, parameters, (ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", warningCollector, false);
    }

    public static ExpressionAnalyzer createConstantAnalyzer(PlannerContext plannerContext, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.createWithoutSubqueries(plannerContext, accessControl, session, parameters, (ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery", warningCollector, isDescribe);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(PlannerContext plannerContext, AccessControl accessControl, Session session, Map<NodeRef<Parameter>, Expression> parameters, ErrorCodeSupplier errorCode, String message, WarningCollector warningCollector, boolean isDescribe) {
        return ExpressionAnalyzer.createWithoutSubqueries(plannerContext, accessControl, session, TypeProvider.empty(), parameters, (? super Node node) -> SemanticExceptions.semanticException(errorCode, node, "%s", message), warningCollector, isDescribe);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(PlannerContext plannerContext, AccessControl accessControl, Session session, TypeProvider symbolTypes, Map<NodeRef<Parameter>, Expression> parameters, Function<? super Node, ? extends RuntimeException> statementAnalyzerRejection, WarningCollector warningCollector, boolean isDescribe) {
        return new ExpressionAnalyzer(plannerContext, accessControl, (node, correlationSupport) -> {
            throw (RuntimeException)statementAnalyzerRejection.apply((Node)node);
        }, session, symbolTypes, parameters, warningCollector, isDescribe, expression -> {
            throw new IllegalStateException("Cannot access preanalyzed types");
        }, functionCall -> {
            throw new IllegalStateException("Cannot access resolved windows");
        });
    }

    public static boolean isNumericType(Type type) {
        return type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type instanceof DecimalType;
    }

    private static boolean isExactNumericWithScaleZero(Type type) {
        return type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type instanceof DecimalType && ((DecimalType)type).getScale() == 0;
    }

    public static boolean isStringType(Type type) {
        return ExpressionAnalyzer.isCharacterStringType(type) || VarbinaryType.VARBINARY.equals((Object)type);
    }

    public static boolean isCharacterStringType(Type type) {
        return type instanceof VarcharType || type instanceof CharType;
    }

    private class Visitor
    extends StackableAstVisitor<Type, Context> {
        private final Scope baseScope;
        private final WarningCollector warningCollector;

        public Visitor(Scope baseScope, WarningCollector warningCollector) {
            this.baseScope = Objects.requireNonNull(baseScope, "baseScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        public Type process(Node node, @Nullable StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            if (node instanceof Expression && (type = ExpressionAnalyzer.this.expressionTypes.get(NodeRef.of((Node)((Expression)node)))) != null) {
                return type;
            }
            return (Type)super.process(node, context);
        }

        protected Type visitRow(Row node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            List types = (List)node.getItems().stream().map(child -> this.process((Node)child, context)).collect(ImmutableList.toImmutableList());
            RowType type = RowType.anonymous((List)types);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitCurrentTime(CurrentTime node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return switch (node.getFunction()) {
                default -> throw new IncompatibleClassChangeError();
                case CurrentTime.Function.DATE -> {
                    Preconditions.checkArgument((node.getPrecision() == null ? 1 : 0) != 0);
                    yield ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)DateType.DATE);
                }
                case CurrentTime.Function.TIME -> {
                    if (node.getPrecision() != null) {
                        yield ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)node.getPrecision()));
                    }
                    yield ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS);
                }
                case CurrentTime.Function.LOCALTIME -> {
                    if (node.getPrecision() != null) {
                        yield ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)TimeType.createTimeType((int)node.getPrecision()));
                    }
                    yield ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)TimeType.TIME_MILLIS);
                }
                case CurrentTime.Function.TIMESTAMP -> ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)((Integer)MoreObjects.firstNonNull((Object)node.getPrecision(), (Object)3))));
                case CurrentTime.Function.LOCALTIMESTAMP -> node.getPrecision() != null ? ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)TimestampType.createTimestampType((int)node.getPrecision())) : ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)TimestampType.TIMESTAMP_MILLIS);
            };
        }

        protected Type visitSymbolReference(SymbolReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Optional<ResolvedField> resolvedField;
            if (((Context)context.getContext()).isInLambda() && (resolvedField = ((Context)context.getContext()).getScope().tryResolveField((Expression)node, QualifiedName.of((String)node.getName()))).isPresent() && ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().containsKey(FieldId.from(resolvedField.get()))) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, resolvedField.get().getType());
            }
            Type type = ExpressionAnalyzer.this.symbolTypes.get(Symbol.from((Expression)node));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitIdentifier(Identifier node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedField resolvedField = ((Context)context.getContext()).getScope().resolveField((Expression)node, QualifiedName.of((String)node.getValue()));
            return this.handleResolvedField((Expression)node, resolvedField, context);
        }

        private Type handleResolvedField(Expression node, ResolvedField resolvedField, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            LambdaArgumentDeclaration lambdaArgumentDeclaration;
            if (!resolvedField.isLocal() && ((Context)context.getContext()).getCorrelationSupport() != CorrelationSupport.ALLOWED) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Reference to column '%s' from outer scope not allowed in this context", node);
            }
            FieldId fieldId = FieldId.from(resolvedField);
            Field field = resolvedField.getField();
            if (((Context)context.getContext()).isInLambda() && (lambdaArgumentDeclaration = ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().get(fieldId)) != null) {
                ExpressionAnalyzer.this.lambdaArgumentReferences.put((NodeRef<Identifier>)NodeRef.of((Node)((Identifier)node)), lambdaArgumentDeclaration);
                return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
            }
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                ExpressionAnalyzer.this.tableColumnReferences.put((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get());
            }
            ExpressionAnalyzer.this.sourceFields.add(field);
            fieldId.getRelationId().getSourceNode().ifPresent(source -> ExpressionAnalyzer.this.referencedFields.put((Object)NodeRef.of((Node)source), (Object)field));
            ResolvedField previous = ExpressionAnalyzer.this.columnReferences.put((NodeRef<Expression>)NodeRef.of((Node)node), resolvedField);
            Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"%s already known to refer to %s", (Object)node, (Object)previous);
            return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
        }

        protected Type visitDereferenceExpression(DereferenceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type baseType;
            if (DereferenceExpression.isQualifiedAllFieldsReference((Expression)node)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "<identifier>.* not allowed in this context", new Object[0]);
            }
            QualifiedName qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)node);
            if (qualifiedName != null) {
                if (((Context)context.getContext()).isPatternRecognition()) {
                    String label = this.label((Identifier)qualifiedName.getOriginalParts().get(0));
                    if (((Context)context.getContext()).getLabels().contains(label)) {
                        QualifiedName unlabeledName = QualifiedName.of(qualifiedName.getOriginalParts().subList(1, qualifiedName.getOriginalParts().size()));
                        if (qualifiedName.getOriginalParts().size() > 2) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)node, "Column %s prefixed with label %s cannot be resolved", unlabeledName, label);
                        }
                        Identifier unlabeled = (Identifier)qualifiedName.getOriginalParts().get(1);
                        if (((Context)context.getContext()).getScope().tryResolveField((Expression)node, unlabeledName).isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)node, "Column %s prefixed with label %s cannot be resolved", unlabeledName, label);
                        }
                        Type type = this.process((Node)unlabeled, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).notExpectingLabels()));
                        ExpressionAnalyzer.this.labelDereferences.put((NodeRef<DereferenceExpression>)NodeRef.of((Node)node), new LabelPrefixedReference(label, unlabeled));
                        return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
                    }
                    throw SemanticExceptions.missingAttributeException((Expression)node, qualifiedName);
                }
                Scope scope = ((Context)context.getContext()).getScope();
                Optional<ResolvedField> resolvedField = scope.tryResolveField((Expression)node, qualifiedName);
                if (resolvedField.isPresent()) {
                    return this.handleResolvedField((Expression)node, resolvedField.get(), context);
                }
                if (!scope.isColumnReference(qualifiedName)) {
                    throw SemanticExceptions.missingAttributeException((Expression)node, qualifiedName);
                }
            }
            if (!((baseType = this.process((Node)node.getBase(), context)) instanceof RowType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getBase(), "Expression %s is not of type ROW", node.getBase());
            }
            RowType rowType = (RowType)baseType;
            Identifier field = (Identifier)node.getField().orElseThrow();
            String fieldName = field.getValue();
            boolean foundFieldName = false;
            Type rowFieldType = null;
            for (RowType.Field rowField : rowType.getFields()) {
                if (!fieldName.equalsIgnoreCase(rowField.getName().orElse(null))) continue;
                if (foundFieldName) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)field, "Ambiguous row field reference: %s", fieldName);
                }
                foundFieldName = true;
                rowFieldType = rowField.getType();
            }
            if (rowFieldType == null) {
                throw SemanticExceptions.missingAttributeException((Expression)node, qualifiedName);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, rowFieldType);
        }

        protected Type visitNotExpression(NotExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitLogicalExpression(LogicalExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (Expression term : node.getTerms()) {
                this.coerceType(context, term, (Type)BooleanType.BOOLEAN, "Logical expression term");
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitComparisonExpression(ComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            OperatorType operatorType = switch (node.getOperator()) {
                default -> throw new IncompatibleClassChangeError();
                case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.NOT_EQUAL -> OperatorType.EQUAL;
                case ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.GREATER_THAN -> OperatorType.LESS_THAN;
                case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> OperatorType.LESS_THAN_OR_EQUAL;
                case ComparisonExpression.Operator.IS_DISTINCT_FROM -> OperatorType.IS_DISTINCT_FROM;
            };
            return this.getOperator(context, (Expression)node, operatorType, node.getLeft(), node.getRight());
        }

        protected Type visitIsNullPredicate(IsNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitNullIfExpression(NullIfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type secondType;
            Type firstType = this.process((Node)node.getFirst(), context);
            if (ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(firstType, secondType = this.process((Node)node.getSecond(), context)).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with NULLIF: %s vs %s", firstType, secondType);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, firstType);
        }

        protected Type visitIfExpression(IfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, (Node)node, "Result types for IF must be the same", node.getTrueValue(), (Expression)node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType((Expression)whenClause, whenClauseType);
            }
            return type;
        }

        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceCaseOperandToToSingleType(node, context);
            Type type = this.coerceToSingleType(context, "All CASE results", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType((Expression)whenClause, whenClauseType);
            }
            return type;
        }

        private void coerceCaseOperandToToSingleType(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression whenOperand;
            Type operandType = this.process((Node)node.getOperand(), context);
            List whenClauses = node.getWhenClauses();
            ArrayList<Type> whenOperandTypes = new ArrayList<Type>(whenClauses.size());
            Type commonType = operandType;
            for (WhenClause whenClause : whenClauses) {
                whenOperand = whenClause.getOperand();
                Type whenOperandType = this.process((Node)whenOperand, context);
                whenOperandTypes.add(whenOperandType);
                commonType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(commonType, whenOperandType).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)whenOperand, "CASE operand type does not match WHEN clause operand type: %s vs %s", operandType, whenOperandType));
            }
            if (commonType != operandType) {
                this.addOrReplaceExpressionCoercion(node.getOperand(), operandType, commonType);
            }
            for (int i = 0; i < whenOperandTypes.size(); ++i) {
                Type whenOperandType = (Type)whenOperandTypes.get(i);
                if (whenOperandType.equals(commonType)) continue;
                whenOperand = ((WhenClause)whenClauses.get(i)).getOperand();
                this.addOrReplaceExpressionCoercion(whenOperand, whenOperandType, commonType);
            }
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            defaultValue.ifPresent(resultExpressions::add);
            return resultExpressions;
        }

        protected Type visitCoalesceExpression(CoalesceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands", node.getOperands());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitArithmeticUnary(ArithmeticUnaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return switch (node.getSign()) {
                default -> throw new IncompatibleClassChangeError();
                case ArithmeticUnaryExpression.Sign.PLUS -> {
                    Type type = this.process((Node)node.getValue(), context);
                    if (!(type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unary '+' operator cannot by applied to %s type", type);
                    }
                    yield ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
                }
                case ArithmeticUnaryExpression.Sign.MINUS -> this.getOperator(context, (Expression)node, OperatorType.NEGATION, node.getValue());
            };
        }

        protected Type visitArithmeticBinary(ArithmeticBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.getOperator(context, (Expression)node, OperatorType.valueOf((String)node.getOperator().name()), node.getLeft(), node.getRight());
        }

        protected Type visitLikePredicate(LikePredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression escape;
            Type escapeType;
            Type patternType;
            Type valueType = this.process((Node)node.getValue(), context);
            if (!(valueType instanceof CharType) && !(valueType instanceof VarcharType)) {
                this.coerceType(context, node.getValue(), (Type)VarcharType.VARCHAR, "Left side of LIKE expression");
            }
            if (!((patternType = this.process((Node)node.getPattern(), context)) instanceof VarcharType)) {
                this.coerceType(context, node.getPattern(), (Type)VarcharType.VARCHAR, "Pattern for LIKE expression");
            }
            if (node.getEscape().isPresent() && !((escapeType = this.process((Node)(escape = (Expression)node.getEscape().get()), context)) instanceof VarcharType)) {
                this.coerceType(context, escape, (Type)VarcharType.VARCHAR, "Escape for LIKE expression");
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitSubscriptExpression(SubscriptExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type baseType = this.process((Node)node.getBase(), context);
            if (baseType instanceof RowType) {
                if (!(node.getIndex() instanceof LongLiteral)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)node.getIndex(), "Subscript expression on ROW requires a constant index", new Object[0]);
                }
                Type indexType = this.process((Node)node.getIndex(), context);
                if (!indexType.equals(IntegerType.INTEGER)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getIndex(), "Subscript expression on ROW requires integer index, found %s", indexType);
                }
                int indexValue = Math.toIntExact(((LongLiteral)node.getIndex()).getParsedValue());
                if (indexValue <= 0) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node.getIndex(), "Invalid subscript index: %s. ROW indices start at 1", indexValue);
                }
                List rowTypes = baseType.getTypeParameters();
                if (indexValue > rowTypes.size()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node.getIndex(), "Subscript index out of bounds: %s, max value is %s", indexValue, rowTypes.size());
                }
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)rowTypes.get(indexValue - 1));
            }
            return this.getOperator(context, (Expression)node, OperatorType.SUBSCRIPT, node.getBase(), node.getIndex());
        }

        protected Type visitArray(Array node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All ARRAY elements", node.getValues());
            Type arrayType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getParameterizedType(ArrayParametricType.ARRAY.getName(), (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)type.getTypeSignature())));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, arrayType);
        }

        protected Type visitStringLiteral(StringLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            VarcharType type = VarcharType.createVarcharType((int)node.length());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitCharLiteral(CharLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            CharType type = CharType.createCharType((int)node.length());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitBinaryLiteral(BinaryLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarbinaryType.VARBINARY);
        }

        protected Type visitLongLiteral(LongLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getParsedValue() >= Integer.MIN_VALUE && node.getParsedValue() <= Integer.MAX_VALUE) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)IntegerType.INTEGER);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        protected Type visitDoubleLiteral(DoubleLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)DoubleType.DOUBLE);
        }

        protected Type visitDecimalLiteral(DecimalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            DecimalParseResult parseResult;
            try {
                parseResult = Decimals.parse((String)node.getValue());
            }
            catch (RuntimeException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, e, "'%s' is not a valid DECIMAL literal", node.getValue());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)parseResult.getType());
        }

        protected Type visitBooleanLiteral(BooleanLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitGenericLiteral(GenericLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = (Type)CacheUtils.uncheckedCacheGet(ExpressionAnalyzer.this.varcharCastableTypeCache, (Object)node.getType(), () -> {
                Type resolvedType;
                try {
                    resolvedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().fromSqlType(node.getType());
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)node, "Unknown resolvedType: %s", node.getType());
                }
                if (!JsonType.JSON.equals(resolvedType)) {
                    try {
                        ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion((Type)VarcharType.VARCHAR, resolvedType);
                    }
                    catch (IllegalArgumentException e) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "No literal form for resolvedType %s", resolvedType);
                    }
                }
                return resolvedType;
            });
            try {
                ExpressionAnalyzer.this.literalInterpreter.evaluate((Expression)node, type);
            }
            catch (RuntimeException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, e, "'%s' is not a valid %s literal", node.getValue(), type.getDisplayName().toUpperCase(Locale.ENGLISH));
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitTimeLiteral(TimeLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            TimeWithTimeZoneType type;
            try {
                int precision = DateTimes.extractTimePrecision(node.getValue());
                if (DateTimes.timeHasTimeZone(node.getValue())) {
                    type = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)precision);
                    DateTimes.parseTimeWithTimeZone(precision, node.getValue());
                } else {
                    type = TimeType.createTimeType((int)precision);
                    DateTimes.parseTime(node.getValue());
                }
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid TIME literal", node.getValue());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitTimestampLiteral(TimestampLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            TimestampWithTimeZoneType type;
            try {
                if (DateTimes.timestampHasTimeZone(node.getValue())) {
                    int precision = DateTimes.extractTimestampPrecision(node.getValue());
                    type = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision);
                    DateTimes.parseTimestampWithTimeZone(precision, node.getValue());
                } else {
                    int precision = DateTimes.extractTimestampPrecision(node.getValue());
                    type = TimestampType.createTimestampType((int)precision);
                    DateTimes.parseTimestamp(precision, node.getValue());
                }
            }
            catch (TrinoException e) {
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, e, "'%s' is not a valid TIMESTAMP literal", node.getValue());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitIntervalLiteral(IntervalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Object type = node.isYearToMonth() ? IntervalYearMonthType.INTERVAL_YEAR_MONTH : IntervalDayTimeType.INTERVAL_DAY_TIME;
            try {
                ExpressionAnalyzer.this.literalInterpreter.evaluate((Expression)node, (Type)type);
            }
            catch (RuntimeException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, e, "'%s' is not a valid INTERVAL literal", node.getValue());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)type);
        }

        protected Type visitNullLiteral(NullLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)UnknownType.UNKNOWN);
        }

        protected Type visitFunctionCall(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedFunction function;
            List arguments;
            Expression expression;
            Type expressionType;
            boolean isAggregation = ExpressionAnalyzer.this.functionResolver.isAggregationFunction(ExpressionAnalyzer.this.session, node.getName(), ExpressionAnalyzer.this.accessControl);
            boolean isRowPatternCount = ((Context)context.getContext()).isPatternRecognition() && isAggregation && node.getName().getSuffix().equalsIgnoreCase("count");
            node.getArguments().stream().filter(DereferenceExpression::isQualifiedAllFieldsReference).findAny().ifPresent(allRowsReference -> {
                if (!isRowPatternCount || node.getArguments().size() > 1) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)allRowsReference, "label.* syntax is only supported as the only argument of row pattern count function", new Object[0]);
                }
            });
            if (((Context)context.getContext()).isPatternRecognition() && ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return this.analyzePatternRecognitionFunction(node, context);
            }
            if (((Context)context.getContext()).isPatternRecognition() && isAggregation) {
                this.analyzePatternAggregation(node);
                ExpressionAnalyzer.this.patternAggregations.add((NodeRef<FunctionCall>)NodeRef.of((Node)node));
            }
            if (node.getProcessingMode().isPresent()) {
                ProcessingMode processingMode = (ProcessingMode)node.getProcessingMode().get();
                if (!((Context)context.getContext()).isPatternRecognition()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCESSING_MODE, (Node)processingMode, "%s semantics is not supported out of pattern recognition context", processingMode.getMode());
                }
                if (!isAggregation) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCESSING_MODE, (Node)processingMode, "%s semantics is supported only for FIRST(), LAST() and aggregation functions. Actual: %s", processingMode.getMode(), node.getName());
                }
            }
            if (node.getWindow().isPresent()) {
                Analysis.ResolvedWindow window = ExpressionAnalyzer.this.getResolvedWindow.apply((Node)node);
                Preconditions.checkState((window != null ? 1 : 0) != 0, (Object)("no resolved window for: " + node));
                this.analyzeWindow(window, context, (Node)node.getWindow().get());
                ExpressionAnalyzer.this.windowFunctions.add((NodeRef<FunctionCall>)NodeRef.of((Node)node));
            } else if (node.isDistinct() && !isAggregation) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE, (Node)node, "DISTINCT is not supported for non-aggregation functions", new Object[0]);
            }
            if (node.getFilter().isPresent()) {
                Expression expression2 = (Expression)node.getFilter().get();
                Type type = this.process((Node)expression2, context);
                this.coerceType(expression2, type, (Type)BooleanType.BOOLEAN, "Filter expression");
            }
            List<TypeSignatureProvider> argumentTypes = this.getCallArgumentTypes(node.getArguments(), context);
            if (QualifiedName.of((String)"LISTAGG").equals((Object)node.getName()) && !((expressionType = this.process((Node)(expression = (Expression)(arguments = node.getArguments()).get(0)), context)) instanceof VarcharType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Expected expression of varchar, but '%s' has %s type", expression, expressionType.getDisplayName());
            }
            if (((Context)context.getContext()).isPatternRecognition() && isAggregation) {
                this.validateAggregationLabelConsistency(node);
            }
            try {
                function = ExpressionAnalyzer.this.functionResolver.resolveFunction(ExpressionAnalyzer.this.session, node.getName(), argumentTypes, ExpressionAnalyzer.this.accessControl);
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            if (function.getSignature().getName().equals((Object)ARRAY_CONSTRUCTOR_NAME)) {
                if (node.getArguments().size() > 254) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, (Node)node, "Too many arguments for array constructor", new Object[0]);
                }
            } else if (node.getArguments().size() > 127) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, (Node)node, "Too many arguments for function call %s()", function.getSignature().getName().getFunctionName());
            }
            if (node.getOrderBy().isPresent()) {
                for (SortItem sortItem : ((OrderBy)node.getOrderBy().get()).getSortItems()) {
                    Type sortKeyType = this.process((Node)sortItem.getSortKey(), context);
                    if (sortKeyType.isOrderable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "ORDER BY can only be applied to orderable types (actual: %s)", sortKeyType.getDisplayName());
                }
            }
            BoundSignature signature = function.getSignature();
            for (int i = 0; i < argumentTypes.size(); ++i) {
                Expression expression3 = (Expression)node.getArguments().get(i);
                Type expectedType = (Type)signature.getArgumentTypes().get(i);
                if (expectedType == null) {
                    throw new NullPointerException(String.format("Type '%s' not found", signature.getArgumentTypes().get(i)));
                }
                if (node.isDistinct() && !expectedType.isComparable()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "DISTINCT can only be applied to comparable types (actual: %s)", expectedType);
                }
                if (argumentTypes.get(i).hasDependency()) {
                    FunctionType expectedFunctionType = (FunctionType)expectedType;
                    this.process((Node)expression3, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).expectingLambda(expectedFunctionType.getArgumentTypes())));
                    continue;
                }
                Type actualType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(argumentTypes.get(i).getTypeSignature());
                this.coerceType(expression3, actualType, expectedType, String.format("Function %s argument %d", function, i));
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), function);
            Type type = signature.getReturnType();
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        private void analyzeWindow(Analysis.ResolvedWindow window, StackableAstVisitor.StackableAstVisitorContext<Context> context, Node originalNode) {
            Object type;
            List<Expression> nestedWindowExpressions;
            ImmutableList.Builder childNodes = ImmutableList.builder();
            if (!window.isPartitionByInherited()) {
                childNodes.addAll(window.getPartitionBy());
            }
            if (!window.isOrderByInherited()) {
                window.getOrderBy().ifPresent(orderBy -> childNodes.addAll((Iterable)orderBy.getSortItems()));
            }
            if (!window.isFrameInherited()) {
                window.getFrame().ifPresent(arg_0 -> ((ImmutableList.Builder)childNodes).add(arg_0));
            }
            if (!(nestedWindowExpressions = ExpressionTreeUtils.extractWindowExpressions((Iterable<? extends Node>)childNodes.build())).isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)nestedWindowExpressions.get(0), "Cannot nest window functions or row pattern measures inside window specification", new Object[0]);
            }
            if (!window.isPartitionByInherited()) {
                for (Expression expression : window.getPartitionBy()) {
                    this.process((Node)expression, context);
                    type = ExpressionAnalyzer.this.getExpressionType(expression);
                    if (type.isComparable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "%s is not comparable, and therefore cannot be used in window function PARTITION BY", type);
                }
            }
            if (!window.isOrderByInherited()) {
                for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(window.getOrderBy())) {
                    this.process((Node)sortItem.getSortKey(), context);
                    type = ExpressionAnalyzer.this.getExpressionType(sortItem.getSortKey());
                    if (type.isOrderable()) continue;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortItem, "%s is not orderable, and therefore cannot be used in window function ORDER BY", type);
                }
            }
            if (window.getFrame().isPresent() && !window.isFrameInherited()) {
                WindowFrame frame = window.getFrame().get();
                if (frame.getPattern().isPresent()) {
                    Expression expression;
                    if (frame.getVariableDefinitions().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_VARIABLE_DEFINITIONS, (Node)frame, "Pattern recognition requires DEFINE clause", new Object[0]);
                    }
                    if (frame.getType() != WindowFrame.Type.ROWS) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Pattern recognition requires ROWS frame type", new Object[0]);
                    }
                    if (frame.getStart().getType() != FrameBound.Type.CURRENT_ROW || frame.getEnd().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Pattern recognition requires frame specified as BETWEEN CURRENT ROW AND ...", new Object[0]);
                    }
                    PatternRecognitionAnalyzer.PatternRecognitionAnalysis analysis = PatternRecognitionAnalyzer.analyze(frame.getSubsets(), frame.getVariableDefinitions(), frame.getMeasures(), (RowPattern)frame.getPattern().get(), frame.getAfterMatchSkipTo());
                    ExpressionAnalyzer.this.ranges.putAll(analysis.getRanges());
                    ExpressionAnalyzer.this.undefinedLabels.put((NodeRef<RowPattern>)NodeRef.of((Node)((RowPattern)frame.getPattern().get())), analysis.getUndefinedLabels());
                    PatternRecognitionAnalyzer.validateNoPatternAnchors((RowPattern)frame.getPattern().get());
                    for (VariableDefinition variableDefinition : frame.getVariableDefinitions()) {
                        expression = variableDefinition.getExpression();
                        Type type2 = this.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).patternRecognition(analysis.getAllLabels())));
                        if (type2.equals(BooleanType.BOOLEAN)) continue;
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "Expression defining a label must be boolean (actual type: %s)", type2);
                    }
                    for (MeasureDefinition measureDefinition : frame.getMeasures()) {
                        expression = measureDefinition.getExpression();
                        this.process((Node)expression, (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).patternRecognition(analysis.getAllLabels())));
                    }
                    PatternRecognitionAnalyzer.validateNoMatchNumber(frame.getMeasures(), frame.getVariableDefinitions(), ExpressionAnalyzer.this.patternRecognitionFunctions);
                } else {
                    if (!frame.getMeasures().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame, "Row pattern measures require PATTERN clause", new Object[0]);
                    }
                    if (frame.getAfterMatchSkipTo().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame.getAfterMatchSkipTo().get(), "AFTER MATCH SKIP clause requires PATTERN clause", new Object[0]);
                    }
                    if (frame.getPatternSearchMode().isPresent()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame.getPatternSearchMode().get(), "%s modifier requires PATTERN clause", ((PatternSearchMode)frame.getPatternSearchMode().get()).getMode().name());
                    }
                    if (!frame.getSubsets().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame.getSubsets().get(0), "Union variable definitions require PATTERN clause", new Object[0]);
                    }
                    if (!frame.getVariableDefinitions().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ROW_PATTERN, (Node)frame.getVariableDefinitions().get(0), "Primary pattern variable definitions require PATTERN clause", new Object[0]);
                    }
                }
                FrameBound.Type startType = frame.getStart().getType();
                FrameBound.Type endType = frame.getEnd().orElse(new FrameBound(FrameBound.Type.CURRENT_ROW)).getType();
                if (startType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame start cannot be UNBOUNDED FOLLOWING", new Object[0]);
                }
                if (endType == FrameBound.Type.UNBOUNDED_PRECEDING) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame end cannot be UNBOUNDED PRECEDING", new Object[0]);
                }
                if (startType == FrameBound.Type.CURRENT_ROW && endType == FrameBound.Type.PRECEDING) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from CURRENT ROW cannot end with PRECEDING", new Object[0]);
                }
                if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.PRECEDING) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with PRECEDING", new Object[0]);
                }
                if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.CURRENT_ROW) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with CURRENT ROW", new Object[0]);
                }
                if (frame.getType() == WindowFrame.Type.ROWS) {
                    if (frame.getStart().getValue().isPresent() && !ExpressionAnalyzer.isExactNumericWithScaleZero(type = this.process((Node)(startValue = (Expression)frame.getStart().getValue().get()), context))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)startValue, "Window frame ROWS start value type must be exact numeric type with scale 0 (actual %s)", type);
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent() && !ExpressionAnalyzer.isExactNumericWithScaleZero(type = this.process((Node)(endValue = (Expression)((FrameBound)frame.getEnd().get()).getValue().get()), context))) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)endValue, "Window frame ROWS end value type must be exact numeric type with scale 0 (actual %s)", type);
                    }
                } else if (frame.getType() == WindowFrame.Type.RANGE) {
                    if (frame.getStart().getValue().isPresent()) {
                        startValue = (Expression)frame.getStart().getValue().get();
                        this.analyzeFrameRangeOffset(startValue, frame.getStart().getType(), context, window, originalNode);
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent()) {
                        endValue = (Expression)((FrameBound)frame.getEnd().get()).getValue().get();
                        this.analyzeFrameRangeOffset(endValue, ((FrameBound)frame.getEnd().get()).getType(), context, window, originalNode);
                    }
                } else if (frame.getType() == WindowFrame.Type.GROUPS) {
                    if (frame.getStart().getValue().isPresent()) {
                        if (window.getOrderBy().isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, originalNode, "Window frame of type GROUPS PRECEDING or FOLLOWING requires ORDER BY", new Object[0]);
                        }
                        startValue = (Expression)frame.getStart().getValue().get();
                        type = this.process((Node)startValue, context);
                        if (!ExpressionAnalyzer.isExactNumericWithScaleZero(type)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)startValue, "Window frame GROUPS start value type must be exact numeric type with scale 0 (actual %s)", type);
                        }
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent()) {
                        if (window.getOrderBy().isEmpty()) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, originalNode, "Window frame of type GROUPS PRECEDING or FOLLOWING requires ORDER BY", new Object[0]);
                        }
                        endValue = (Expression)((FrameBound)frame.getEnd().get()).getValue().get();
                        type = this.process((Node)endValue, context);
                        if (!ExpressionAnalyzer.isExactNumericWithScaleZero(type)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)endValue, "Window frame GROUPS end value type must be exact numeric type with scale 0 (actual %s)", type);
                        }
                    }
                } else {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)frame, "Unsupported frame type: %s", frame.getType());
                }
            }
        }

        private void analyzeFrameRangeOffset(Expression offsetValue, FrameBound.Type boundType, StackableAstVisitor.StackableAstVisitorContext<Context> context, Analysis.ResolvedWindow window, Node originalNode) {
            Type expectedFunctionResultType;
            Type expectedOffsetValueType;
            ResolvedFunction function;
            OrderBy orderBy = window.getOrderBy().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_ORDER_BY, originalNode, "Window frame of type RANGE PRECEDING or FOLLOWING requires ORDER BY", new Object[0]));
            if (orderBy.getSortItems().size() != 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ORDER_BY, (Node)orderBy, "Window frame of type RANGE PRECEDING or FOLLOWING requires single sort item in ORDER BY (actual: %s)", orderBy.getSortItems().size());
            }
            Expression sortKey = ((SortItem)Iterables.getOnlyElement((Iterable)orderBy.getSortItems())).getSortKey();
            Type sortKeyType = window.isOrderByInherited() ? ExpressionAnalyzer.this.getPreanalyzedType.apply(sortKey) : ExpressionAnalyzer.this.getExpressionType(sortKey);
            if (!ExpressionAnalyzer.isNumericType(sortKeyType) && !this.isDateTimeType(sortKeyType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortKey, "Window frame of type RANGE PRECEDING or FOLLOWING requires that sort item type be numeric, datetime or interval (actual: %s)", sortKeyType);
            }
            Type offsetValueType = this.process((Node)offsetValue, context);
            if (ExpressionAnalyzer.isNumericType(sortKeyType) ? !ExpressionAnalyzer.isNumericType(offsetValueType) : offsetValueType != IntervalDayTimeType.INTERVAL_DAY_TIME && offsetValueType != IntervalYearMonthType.INTERVAL_YEAR_MONTH) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)offsetValue, "Window frame RANGE value type (%s) not compatible with sort item type (%s)", offsetValueType, sortKeyType);
            }
            SortItem.Ordering ordering = ((SortItem)Iterables.getOnlyElement((Iterable)orderBy.getSortItems())).getOrdering();
            OperatorType operatorType = boundType == FrameBound.Type.PRECEDING && ordering == SortItem.Ordering.ASCENDING || boundType == FrameBound.Type.FOLLOWING && ordering == SortItem.Ordering.DESCENDING ? OperatorType.SUBTRACT : OperatorType.ADD;
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)sortKeyType, (Object)offsetValueType));
            }
            catch (TrinoException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (errorCode.equals((Object)StandardErrorCode.OPERATOR_NOT_FOUND.toErrorCode())) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)offsetValue, "Window frame RANGE value type (%s) not compatible with sort item type (%s)", offsetValueType, sortKeyType);
                }
                throw e;
            }
            BoundSignature signature = function.getSignature();
            Type expectedSortKeyType = (Type)signature.getArgumentTypes().get(0);
            if (!expectedSortKeyType.equals(sortKeyType)) {
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(sortKeyType, expectedSortKeyType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortKey, "Sort key must evaluate to a %s (actual: %s)", expectedSortKeyType, sortKeyType);
                }
                ExpressionAnalyzer.this.sortKeyCoercionsForFrameBoundCalculation.put((NodeRef<Expression>)NodeRef.of((Node)offsetValue), expectedSortKeyType);
            }
            if (!(expectedOffsetValueType = (Type)signature.getArgumentTypes().get(1)).equals(offsetValueType)) {
                this.coerceType(offsetValue, offsetValueType, expectedOffsetValueType, String.format("Function %s argument 1", function));
            }
            if (!(expectedFunctionResultType = signature.getReturnType()).equals(sortKeyType)) {
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(sortKeyType, expectedFunctionResultType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)sortKey, "Sort key must evaluate to a %s (actual: %s)", expectedFunctionResultType, sortKeyType);
                }
                ExpressionAnalyzer.this.sortKeyCoercionsForFrameBoundComparison.put((NodeRef<Expression>)NodeRef.of((Node)offsetValue), expectedFunctionResultType);
            }
            ExpressionAnalyzer.this.frameBoundCalculations.put((NodeRef<Expression>)NodeRef.of((Node)offsetValue), function);
        }

        protected Type visitWindowOperation(WindowOperation node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Analysis.ResolvedWindow window = ExpressionAnalyzer.this.getResolvedWindow.apply((Node)node);
            Preconditions.checkState((window != null ? 1 : 0) != 0, (Object)("no resolved window for: " + node));
            if (window.getFrame().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_MEASURE, (Node)node, "Measure %s is not defined in the corresponding window", node.getName().getValue());
            }
            CanonicalizationAware<Identifier> canonicalName = CanonicalizationAware.canonicalizationAwareKey(node.getName());
            List matchingMeasures = (List)window.getFrame().get().getMeasures().stream().filter(measureDefinition -> CanonicalizationAware.canonicalizationAwareKey(measureDefinition.getName()).equals(canonicalName)).collect(ImmutableList.toImmutableList());
            if (matchingMeasures.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_MEASURE, (Node)node, "Measure %s is not defined in the corresponding window", node.getName().getValue());
            }
            if (matchingMeasures.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)node, "Measure %s is defined more than once", node.getName().getValue());
            }
            MeasureDefinition matchingMeasure = (MeasureDefinition)Iterables.getOnlyElement((Iterable)matchingMeasures);
            ExpressionAnalyzer.this.measureDefinitions.put((NodeRef<WindowOperation>)NodeRef.of((Node)node), matchingMeasure);
            this.analyzeWindow(window, context, (Node)node.getWindow());
            Expression expression = matchingMeasure.getExpression();
            Type type = window.isFrameInherited() ? ExpressionAnalyzer.this.getPreanalyzedType.apply(expression) : ExpressionAnalyzer.this.getExpressionType(expression);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public List<TypeSignatureProvider> getCallArgumentTypes(List<Expression> arguments, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ImmutableList.Builder argumentTypesBuilder = ImmutableList.builder();
            for (Expression argument : arguments) {
                if (argument instanceof LambdaExpression || argument instanceof BindExpression) {
                    argumentTypesBuilder.add((Object)new TypeSignatureProvider(types -> {
                        ExpressionAnalyzer innerExpressionAnalyzer = new ExpressionAnalyzer(ExpressionAnalyzer.this.plannerContext, ExpressionAnalyzer.this.accessControl, ExpressionAnalyzer.this.statementAnalyzerFactory, ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.symbolTypes, ExpressionAnalyzer.this.parameters, this.warningCollector, ExpressionAnalyzer.this.isDescribe, ExpressionAnalyzer.this.getPreanalyzedType, ExpressionAnalyzer.this.getResolvedWindow);
                        if (((Context)context.getContext()).isInLambda()) {
                            for (LambdaArgumentDeclaration lambdaArgument : ((Context)context.getContext()).getFieldToLambdaArgumentDeclaration().values()) {
                                innerExpressionAnalyzer.setExpressionType((Expression)lambdaArgument, ExpressionAnalyzer.this.getExpressionType((Expression)lambdaArgument));
                            }
                        }
                        return innerExpressionAnalyzer.analyze(argument, this.baseScope, ((Context)context.getContext()).expectingLambda((List<Type>)types)).getTypeSignature();
                    }));
                    continue;
                }
                if (DereferenceExpression.isQualifiedAllFieldsReference((Expression)argument)) {
                    DereferenceExpression allRowsDereference = (DereferenceExpression)argument;
                    String label = this.label((Identifier)allRowsDereference.getBase());
                    if (!((Context)context.getContext()).getLabels().contains(label)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)allRowsDereference.getBase(), "%s is not a primary pattern variable or subset name", label);
                    }
                    ExpressionAnalyzer.this.labelDereferences.put((NodeRef<DereferenceExpression>)NodeRef.of((Node)allRowsDereference), new LabelPrefixedReference(label));
                    continue;
                }
                argumentTypesBuilder.add((Object)new TypeSignatureProvider(this.process((Node)argument, context).getTypeSignature()));
            }
            return argumentTypesBuilder.build();
        }

        private Type analyzePatternRecognitionFunction(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getWindow().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "Cannot use OVER with %s pattern recognition function", node.getName());
            }
            if (node.getFilter().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "Cannot use FILTER with %s pattern recognition function", node.getName());
            }
            if (node.getOrderBy().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "Cannot use ORDER BY with %s pattern recognition function", node.getName());
            }
            if (node.isDistinct()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, (Node)node, "Cannot use DISTINCT with %s pattern recognition function", node.getName());
            }
            String name = node.getName().getSuffix();
            if (node.getProcessingMode().isPresent()) {
                ProcessingMode processingMode = (ProcessingMode)node.getProcessingMode().get();
                if (!name.equalsIgnoreCase("FIRST") && !name.equalsIgnoreCase("LAST")) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCESSING_MODE, (Node)processingMode, "%s semantics is not supported with %s pattern recognition function", processingMode.getMode(), node.getName());
                }
            }
            ExpressionAnalyzer.this.patternRecognitionFunctions.add((NodeRef<FunctionCall>)NodeRef.of((Node)node));
            return switch (name.toUpperCase(Locale.ENGLISH)) {
                case "FIRST", "LAST", "PREV", "NEXT" -> {
                    if (node.getArguments().size() != 1 && node.getArguments().size() != 2) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "%s pattern recognition function requires 1 or 2 arguments", node.getName());
                    }
                    Type resultType = this.process((Node)node.getArguments().get(0), context);
                    if (node.getArguments().size() == 2) {
                        this.process((Node)node.getArguments().get(1), context);
                        if (!(node.getArguments().get(1) instanceof LongLiteral)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "%s pattern recognition navigation function requires a number as the second argument", node.getName());
                        }
                        long offset = ((LongLiteral)node.getArguments().get(1)).getParsedValue();
                        if (offset < 0L) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "%s pattern recognition navigation function requires a non-negative number as the second argument (actual: %s)", node.getName(), offset);
                        }
                        if (offset > Integer.MAX_VALUE) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)node, "The second argument of %s pattern recognition navigation function must not exceed %s (actual: %s)", node.getName(), Integer.MAX_VALUE, offset);
                        }
                    }
                    this.validateNavigationNesting(node);
                    this.checkNoNestedAggregations(node);
                    this.validateNavigationLabelConsistency(node);
                    yield ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
                }
                case "MATCH_NUMBER" -> {
                    if (!node.getArguments().isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "MATCH_NUMBER pattern recognition function takes no arguments", new Object[0]);
                    }
                    yield ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
                }
                case "CLASSIFIER" -> {
                    if (node.getArguments().size() > 1) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "CLASSIFIER pattern recognition function takes no arguments or 1 argument", new Object[0]);
                    }
                    if (node.getArguments().size() == 1) {
                        Node argument = (Node)node.getArguments().get(0);
                        if (!(argument instanceof Identifier)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, argument, "CLASSIFIER function argument should be primary pattern variable or subset name. Actual: %s", argument.getClass().getSimpleName());
                        }
                        Identifier identifier = (Identifier)argument;
                        String label = this.label(identifier);
                        if (!((Context)context.getContext()).getLabels().contains(label)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, argument, "%s is not a primary pattern variable or subset name", identifier.getValue());
                        }
                    }
                    yield ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
                }
                default -> throw new IllegalStateException("unexpected pattern recognition function " + node.getName());
            };
        }

        private void validateNavigationNesting(FunctionCall node) {
            Preconditions.checkArgument((boolean)this.isPatternNavigationFunction(node));
            String name = node.getName().getSuffix();
            List nestedNavigationFunctions = (List)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)((Expression)node.getArguments().get(0))), FunctionCall.class).stream().filter(this::isPatternNavigationFunction).collect(ImmutableList.toImmutableList());
            if (!nestedNavigationFunctions.isEmpty()) {
                if (name.equalsIgnoreCase("FIRST") || name.equalsIgnoreCase("LAST")) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)nestedNavigationFunctions.get(0), "Cannot nest %s pattern navigation function inside %s pattern navigation function", ((FunctionCall)nestedNavigationFunctions.get(0)).getName(), name);
                }
                if (nestedNavigationFunctions.size() > 1) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)nestedNavigationFunctions.get(1), "Cannot nest multiple pattern navigation functions inside %s pattern navigation function", name);
                }
                FunctionCall nested = (FunctionCall)Iterables.getOnlyElement((Iterable)nestedNavigationFunctions);
                String nestedName = nested.getName().getSuffix();
                if (nestedName.equalsIgnoreCase("PREV") || nestedName.equalsIgnoreCase("NEXT")) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)nested, "Cannot nest %s pattern navigation function inside %s pattern navigation function", nestedName, name);
                }
                if (nested != node.getArguments().get(0)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)nested, "Immediate nesting is required for pattern navigation functions", new Object[0]);
                }
            }
        }

        private void validateAggregationLabelConsistency(FunctionCall node) {
            if (node.getArguments().isEmpty()) {
                return;
            }
            HashSet<Optional<String>> argumentLabels = new HashSet<Optional<String>>();
            for (int i = 0; i < node.getArguments().size(); ++i) {
                ArgumentLabel argumentLabel = this.validateLabelConsistency(node, false, i);
                if (!argumentLabel.hasLabel()) continue;
                argumentLabels.add(argumentLabel.getLabel());
            }
            if (argumentLabels.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "All aggregate function arguments must apply to rows matched with the same label", new Object[0]);
            }
        }

        private void validateNavigationLabelConsistency(FunctionCall node) {
            Preconditions.checkArgument((boolean)this.isPatternNavigationFunction(node));
            this.validateLabelConsistency(node, true, 0);
        }

        private ArgumentLabel validateLabelConsistency(FunctionCall node, boolean labelRequired, int argumentIndex) {
            String name = node.getName().getSuffix();
            List unlabeledInputColumns = (List)Streams.concat((Stream[])new Stream[]{ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)((Expression)node.getArguments().get(argumentIndex))), Identifier.class).stream(), ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)((Expression)node.getArguments().get(argumentIndex))), DereferenceExpression.class).stream()}).filter(expression -> ExpressionAnalyzer.this.columnReferences.containsKey(NodeRef.of((Node)expression))).collect(ImmutableList.toImmutableList());
            List labeledInputColumns = (List)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)((Expression)node.getArguments().get(argumentIndex))), DereferenceExpression.class).stream().filter(expression -> ExpressionAnalyzer.this.labelDereferences.containsKey(NodeRef.of((Node)expression))).collect(ImmutableList.toImmutableList());
            List classifiers = (List)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)((Expression)node.getArguments().get(argumentIndex))), FunctionCall.class).stream().filter(this::isClassifierFunction).collect(ImmutableList.toImmutableList());
            if (unlabeledInputColumns.isEmpty() && labeledInputColumns.isEmpty() && classifiers.isEmpty()) {
                if (labelRequired) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "Pattern navigation function %s must contain at least one column reference or CLASSIFIER()", name);
                }
                return ArgumentLabel.noLabel();
            }
            if (!unlabeledInputColumns.isEmpty() && !labeledInputColumns.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)labeledInputColumns.get(0), "Column references inside argument of function %s must all either be prefixed with the same label or be not prefixed", name);
            }
            Set inputColumnLabels = (Set)labeledInputColumns.stream().map(expression -> ExpressionAnalyzer.this.labelDereferences.get(NodeRef.of((Node)expression))).map(LabelPrefixedReference::getLabel).collect(ImmutableSet.toImmutableSet());
            if (inputColumnLabels.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)labeledInputColumns.get(0), "Column references inside argument of function %s must all either be prefixed with the same label or be not prefixed", name);
            }
            Set classifierLabels = (Set)classifiers.stream().map(functionCall -> {
                if (functionCall.getArguments().isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(this.label((Identifier)functionCall.getArguments().get(0)));
            }).collect(ImmutableSet.toImmutableSet());
            if (classifierLabels.size() > 1) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "CLASSIFIER() calls inside argument of function %s must all either have the same label as the argument or have no arguments", name);
            }
            if (!(unlabeledInputColumns.isEmpty() || classifiers.isEmpty() || ((Optional)Iterables.getOnlyElement((Iterable)classifierLabels)).equals(Optional.empty()))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "Column references inside argument of function %s must all be prefixed with the same label that all CLASSIFIER() calls have as the argument", name);
            }
            if (!(labeledInputColumns.isEmpty() || classifiers.isEmpty() || ((Optional)Iterables.getOnlyElement((Iterable)classifierLabels)).equals(Optional.of((String)Iterables.getOnlyElement((Iterable)inputColumnLabels))))) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "Column references inside argument of function %s must all be prefixed with the same label that all CLASSIFIER() calls have as the argument", name);
            }
            if (!inputColumnLabels.isEmpty()) {
                return ArgumentLabel.explicitLabel((String)Iterables.getOnlyElement((Iterable)inputColumnLabels));
            }
            if (!classifierLabels.isEmpty()) {
                return ((Optional)Iterables.getOnlyElement((Iterable)classifierLabels)).map(ArgumentLabel::explicitLabel).orElse(ArgumentLabel.universalLabel());
            }
            if (!unlabeledInputColumns.isEmpty()) {
                return ArgumentLabel.universalLabel();
            }
            return ArgumentLabel.noLabel();
        }

        private boolean isPatternNavigationFunction(FunctionCall node) {
            if (!ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return false;
            }
            String name = node.getName().getSuffix().toUpperCase(Locale.ENGLISH);
            return name.equals("FIRST") || name.equals("LAST") || name.equals("PREV") || name.equals("NEXT");
        }

        private boolean isClassifierFunction(FunctionCall node) {
            if (!ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return false;
            }
            return node.getName().getSuffix().toUpperCase(Locale.ENGLISH).equals("CLASSIFIER");
        }

        private String label(Identifier identifier) {
            return identifier.getCanonicalValue();
        }

        private void analyzePatternAggregation(FunctionCall node) {
            if (node.getWindow().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)node, "Cannot use OVER with %s aggregate function in pattern recognition context", node.getName());
            }
            if (node.getFilter().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Cannot use FILTER with %s aggregate function in pattern recognition context", node.getName());
            }
            if (node.getOrderBy().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Cannot use ORDER BY with %s aggregate function in pattern recognition context", node.getName());
            }
            if (node.isDistinct()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Cannot use DISTINCT with %s aggregate function in pattern recognition context", node.getName());
            }
            this.checkNoNestedAggregations(node);
            this.checkNoNestedNavigations(node);
        }

        private void checkNoNestedAggregations(FunctionCall node) {
            ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(function -> ExpressionAnalyzer.this.functionResolver.isAggregationFunction(ExpressionAnalyzer.this.session, function.getName(), ExpressionAnalyzer.this.accessControl)).findFirst().ifPresent(aggregation -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_AGGREGATION, (Node)aggregation, "Cannot nest %s aggregate function inside %s function", aggregation.getName(), node.getName());
            });
        }

        private void checkNoNestedNavigations(FunctionCall node) {
            ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(this::isPatternNavigationFunction).findFirst().ifPresent(navigation -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_NAVIGATION_NESTING, (Node)navigation, "Cannot nest %s pattern navigation function inside %s function", navigation.getName().getSuffix(), node.getName());
            });
        }

        protected Type visitAtTimeZone(AtTimeZone node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            this.process((Node)node.getTimeZone(), context);
            if (!(valueType instanceof TimeWithTimeZoneType || valueType instanceof TimestampWithTimeZoneType || valueType instanceof TimeType || valueType instanceof TimestampType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getValue(), "Type of value must be a time or timestamp with or without time zone (actual %s)", valueType);
            }
            Type resultType = valueType;
            if (valueType instanceof TimeType) {
                resultType = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)((TimeType)valueType).getPrecision());
            } else if (valueType instanceof TimestampType) {
                resultType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)((TimestampType)valueType).getPrecision());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
        }

        protected Type visitCurrentCatalog(CurrentCatalog node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitCurrentSchema(CurrentSchema node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitCurrentUser(CurrentUser node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitCurrentPath(CurrentPath node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitTrim(Trim node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            argumentTypes.add((Object)this.process((Node)node.getTrimSource(), context));
            node.getTrimCharacter().ifPresent(trimChar -> argumentTypes.add((Object)this.process((Node)trimChar, context)));
            ImmutableList actualTypes = argumentTypes.build();
            String functionName = node.getSpecification().getFunctionName();
            ResolvedFunction function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction(functionName, TypeSignatureProvider.fromTypes((List<? extends Type>)actualTypes));
            List expectedTypes = function.getSignature().getArgumentTypes();
            Preconditions.checkState((expectedTypes.size() == actualTypes.size() ? 1 : 0) != 0, (Object)"wrong argument number in the resolved signature");
            Type actualTrimSourceType = (Type)actualTypes.get(0);
            Type expectedTrimSourceType = (Type)expectedTypes.get(0);
            this.coerceType(node.getTrimSource(), actualTrimSourceType, expectedTrimSourceType, "source argument of trim function");
            if (node.getTrimCharacter().isPresent()) {
                Type actualTrimCharType = (Type)actualTypes.get(1);
                Type expectedTrimCharType = (Type)expectedTypes.get(1);
                this.coerceType((Expression)node.getTrimCharacter().get(), actualTrimCharType, expectedTrimCharType, "trim character argument of trim function");
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), function);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, function.getSignature().getReturnType());
        }

        protected Type visitFormat(Format node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            List arguments = (List)node.getArguments().stream().map(expression -> this.process((Node)expression, context)).collect(ImmutableList.toImmutableList());
            if (!(arguments.get(0) instanceof VarcharType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getArguments().get(0), "Type of first argument to format() must be VARCHAR (actual: %s)", arguments.get(0));
            }
            for (int i = 1; i < arguments.size(); ++i) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$format", TypeSignatureProvider.fromTypes(new Type[]{(Type)arguments.get(0), RowType.anonymous(arguments.subList(1, arguments.size()))}));
                    continue;
                }
                catch (TrinoException e) {
                    ErrorCode errorCode = e.getErrorCode();
                    if (errorCode.equals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode()) || errorCode.equals((Object)StandardErrorCode.OPERATOR_NOT_FOUND.toErrorCode())) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node.getArguments().get(i), "Type not supported for formatting: %s", arguments.get(i));
                    }
                    throw e;
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)VarcharType.VARCHAR);
        }

        protected Type visitParameter(Parameter node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (ExpressionAnalyzer.this.isDescribe) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)UnknownType.UNKNOWN);
            }
            if (ExpressionAnalyzer.this.parameters.size() == 0) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Query takes no parameters", new Object[0]);
            }
            if (node.getId() >= ExpressionAnalyzer.this.parameters.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Invalid parameter index %s, max value is %s", node.getId(), ExpressionAnalyzer.this.parameters.size() - 1);
            }
            Expression providedValue = ExpressionAnalyzer.this.parameters.get(NodeRef.of((Node)node));
            if (providedValue == null) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "No value provided for parameter", new Object[0]);
            }
            Type resultType = this.process((Node)providedValue, context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, resultType);
        }

        protected Type visitExtract(Extract node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.process((Node)node.getExpression(), context);
            Extract.Field field = node.getField();
            switch (field) {
                case YEAR: 
                case MONTH: {
                    if (type instanceof DateType || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                case DAY: {
                    if (type instanceof DateType || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME)) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                case QUARTER: 
                case WEEK: 
                case DAY_OF_MONTH: 
                case DAY_OF_WEEK: 
                case DOW: 
                case DAY_OF_YEAR: 
                case DOY: 
                case YEAR_OF_WEEK: 
                case YOW: {
                    if (type instanceof DateType || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    if (type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type instanceof TimeType || type instanceof TimeWithTimeZoneType || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME)) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                case TIMEZONE_MINUTE: 
                case TIMEZONE_HOUR: {
                    if (type instanceof TimestampWithTimeZoneType || type instanceof TimeWithTimeZoneType) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Cannot extract %s from %s", field, type);
                }
                default: {
                    throw new UnsupportedOperationException("Unknown field: " + field);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        private boolean isDateTimeType(Type type) {
            return type.equals(DateType.DATE) || type instanceof TimeType || type instanceof TimeWithTimeZoneType || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) || type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        }

        protected Type visitBetweenPredicate(BetweenPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            Type minType = this.process((Node)node.getMin(), context);
            Type maxType = this.process((Node)node.getMax(), context);
            Optional commonType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(valueType, minType).flatMap(type -> ExpressionAnalyzer.this.typeCoercion.getCommonSuperType((Type)type, maxType));
            if (commonType.isEmpty()) {
                SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot check if %s is BETWEEN %s and %s", valueType, minType, maxType);
            }
            if (!((Type)commonType.get()).isOrderable()) {
                SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot check if %s is BETWEEN %s and %s", valueType, minType, maxType);
            }
            if (!valueType.equals(commonType.get())) {
                this.addOrReplaceExpressionCoercion(node.getValue(), valueType, (Type)commonType.get());
            }
            if (!minType.equals(commonType.get())) {
                this.addOrReplaceExpressionCoercion(node.getMin(), minType, (Type)commonType.get());
            }
            if (!maxType.equals(commonType.get())) {
                this.addOrReplaceExpressionCoercion(node.getMax(), maxType, (Type)commonType.get());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        public Type visitTryExpression(TryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (((Context)context.getContext()).isPatternRecognition()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "TRY expression in pattern recognition context is not yet supported", new Object[0]);
            }
            Type type = this.process((Node)node.getInnerExpression(), context);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public Type visitCast(Cast node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            try {
                type = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
            }
            catch (TypeNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getType());
            }
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "UNKNOWN is not a valid type", new Object[0]);
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (!value.equals((Object)UnknownType.UNKNOWN) && !node.isTypeOnly()) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(value, type);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast %s to %s", value, type);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        protected Type visitInPredicate(InPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression value = node.getValue();
            Expression valueList = node.getValueList();
            if (((Context)context.getContext()).isPatternRecognition() && valueList instanceof SubqueryExpression) {
                ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)value), FunctionCall.class).stream().filter(ExpressionAnalyzer::isPatternRecognitionFunction).findFirst().ifPresent(function -> {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)function, "IN-PREDICATE with %s function is not yet supported", function.getName().getSuffix());
                });
                ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)value), DereferenceExpression.class).forEach(dereference -> {
                    QualifiedName qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)dereference);
                    if (qualifiedName != null) {
                        String label = this.label((Identifier)qualifiedName.getOriginalParts().get(0));
                        if (((Context)context.getContext()).getLabels().contains(label)) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)dereference, "IN-PREDICATE with labeled column reference is not yet supported", new Object[0]);
                        }
                    }
                });
            }
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                Type type = this.coerceToSingleType(context, "IN value and list items", (List<Expression>)ImmutableList.builder().add((Object)value).addAll((Iterable)inListExpression.getValues()).build());
                ExpressionAnalyzer.this.setExpressionType((Expression)inListExpression, type);
            } else if (valueList instanceof SubqueryExpression) {
                ExpressionAnalyzer.this.subqueryInPredicates.add((NodeRef<InPredicate>)NodeRef.of((Node)node));
                this.analyzePredicateWithSubquery((Expression)node, this.process((Node)value, context), (SubqueryExpression)valueList, context);
            } else {
                throw new IllegalArgumentException("Unexpected value list type for InPredicate: " + node.getValueList().getClass().getName());
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitSubqueryExpression(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.analyzeSubquery(node, context);
            if (type instanceof RowType && ((RowType)type).getFields().size() == 1) {
                type = (Type)type.getTypeParameters().get(0);
            }
            ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
            ExpressionAnalyzer.this.subqueries.add((NodeRef<SubqueryExpression>)NodeRef.of((Node)node));
            return type;
        }

        private Type analyzePredicateWithSubquery(Expression node, Type declaredValueType, SubqueryExpression subquery, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueRowType = declaredValueType;
            if (!(declaredValueType instanceof RowType) && !(declaredValueType instanceof UnknownType)) {
                valueRowType = RowType.anonymous((List)ImmutableList.of((Object)declaredValueType));
            }
            Type subqueryType = this.analyzeSubquery(subquery, context);
            ExpressionAnalyzer.this.setExpressionType((Expression)subquery, subqueryType);
            Optional<Type> commonType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType(valueRowType, subqueryType);
            if (commonType.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Value expression and result of subquery must be of the same type: %s vs %s", valueRowType, subqueryType);
            }
            Optional<Type> valueCoercion = Optional.empty();
            if (!valueRowType.equals(commonType.get())) {
                valueCoercion = commonType;
            }
            Optional<Type> subQueryCoercion = Optional.empty();
            if (!subqueryType.equals(commonType.get())) {
                subQueryCoercion = commonType;
            }
            ExpressionAnalyzer.this.predicateCoercions.put((NodeRef<Expression>)NodeRef.of((Node)node), new Analysis.PredicateCoercions(valueRowType, valueCoercion, subQueryCoercion));
            return commonType.get();
        }

        private Type analyzeSubquery(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (((Context)context.getContext()).isInLambda()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Lambda expression cannot contain subqueries", new Object[0]);
            }
            StatementAnalyzer analyzer = ExpressionAnalyzer.this.statementAnalyzerFactory.apply((Node)node, ((Context)context.getContext()).getCorrelationSupport());
            Scope subqueryScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).build();
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), subqueryScope);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < queryScope.getRelationType().getAllFieldCount(); ++i) {
                Field field = queryScope.getRelationType().getFieldByIndex(i);
                if (field.isHidden()) continue;
                if (field.getName().isPresent()) {
                    fields.add((Object)RowType.field((String)field.getName().get(), (Type)field.getType()));
                    continue;
                }
                fields.add((Object)RowType.field((Type)field.getType()));
            }
            ExpressionAnalyzer.this.sourceFields.addAll(queryScope.getRelationType().getVisibleFields());
            return RowType.from((List)fields.build());
        }

        protected Type visitExists(ExistsPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            StatementAnalyzer analyzer = ExpressionAnalyzer.this.statementAnalyzerFactory.apply((Node)node, ((Context)context.getContext()).getCorrelationSupport());
            Scope subqueryScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).build();
            List fields = (List)analyzer.analyze((Node)node.getSubquery(), subqueryScope).getRelationType().getAllFields().stream().map(field -> {
                if (field.getName().isPresent()) {
                    return RowType.field((String)field.getName().get(), (Type)field.getType());
                }
                return RowType.field((Type)field.getType());
            }).collect(ImmutableList.toImmutableList());
            ExpressionAnalyzer.this.setExpressionType(node.getSubquery(), (Type)RowType.from((List)fields));
            ExpressionAnalyzer.this.existsSubqueries.add((NodeRef<ExistsPredicate>)NodeRef.of((Node)node));
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        protected Type visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ExpressionAnalyzer.this.quantifiedComparisons.add((NodeRef<QuantifiedComparisonExpression>)NodeRef.of((Node)node));
            Type declaredValueType = this.process((Node)node.getValue(), context);
            Type comparisonType = this.analyzePredicateWithSubquery((Expression)node, declaredValueType, (SubqueryExpression)node.getSubquery(), context);
            switch (node.getOperator()) {
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    if (comparisonType.isOrderable()) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Type [%s] must be orderable in order to be used in quantified comparison", comparisonType);
                }
                case EQUAL: 
                case NOT_EQUAL: {
                    if (comparisonType.isComparable()) break;
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Type [%s] must be comparable in order to be used in quantified comparison", comparisonType);
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected comparison type: %s", node.getOperator()));
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BooleanType.BOOLEAN);
        }

        public Type visitFieldReference(FieldReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedField field = this.baseScope.getField(node.getFieldIndex());
            return this.handleResolvedField((Expression)node, field, context);
        }

        protected Type visitLambdaExpression(LambdaExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (((Context)context.getContext()).isPatternRecognition()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Lambda expression in pattern recognition context is not yet supported", new Object[0]);
            }
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.functionResolver, ExpressionAnalyzer.this.accessControl, node.getBody(), "Lambda expression");
            if (!((Context)context.getContext()).isExpectingLambda()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Lambda expression should always be used inside a function", new Object[0]);
            }
            List<Type> types = ((Context)context.getContext()).getFunctionInputTypes();
            List lambdaArguments = node.getArguments();
            if (types.size() != lambdaArguments.size()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Expected a lambda that takes %s argument(s) but got %s", types.size(), lambdaArguments.size());
            }
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < lambdaArguments.size(); ++i) {
                LambdaArgumentDeclaration lambdaArgument = (LambdaArgumentDeclaration)lambdaArguments.get(i);
                Type type = types.get(i);
                fields.add((Object)Field.newUnqualified(lambdaArgument.getName().getValue(), type));
                ExpressionAnalyzer.this.setExpressionType((Expression)lambdaArgument, type);
            }
            Scope lambdaScope = Scope.builder().withParent(((Context)context.getContext()).getScope()).withRelationType(RelationId.of((Node)node), new RelationType((List<Field>)fields.build())).build();
            ImmutableMap.Builder fieldToLambdaArgumentDeclaration = ImmutableMap.builder();
            if (((Context)context.getContext()).isInLambda()) {
                fieldToLambdaArgumentDeclaration.putAll(((Context)context.getContext()).getFieldToLambdaArgumentDeclaration());
            }
            for (LambdaArgumentDeclaration lambdaArgument : lambdaArguments) {
                ResolvedField resolvedField = lambdaScope.resolveField((Expression)lambdaArgument, QualifiedName.of((String)lambdaArgument.getName().getValue()));
                fieldToLambdaArgumentDeclaration.put((Object)FieldId.from(resolvedField), (Object)lambdaArgument);
            }
            Type returnType = this.process((Node)node.getBody(), (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).inLambda(lambdaScope, (Map<FieldId, LambdaArgumentDeclaration>)fieldToLambdaArgumentDeclaration.buildOrThrow())));
            FunctionType functionType = new FunctionType(types, returnType);
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, functionType);
        }

        protected Type visitBindExpression(BindExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Verify.verify((boolean)((Context)context.getContext()).isExpectingLambda(), (String)"bind expression found when lambda is not expected", (Object[])new Object[0]);
            StackableAstVisitor.StackableAstVisitorContext innerContext = new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).notExpectingLambda());
            ImmutableList.Builder functionInputTypesBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                functionInputTypesBuilder.add((Object)this.process((Node)value, (StackableAstVisitor.StackableAstVisitorContext<Context>)innerContext));
            }
            functionInputTypesBuilder.addAll(((Context)context.getContext()).getFunctionInputTypes());
            ImmutableList functionInputTypes = functionInputTypesBuilder.build();
            FunctionType functionType = (FunctionType)this.process((Node)node.getFunction(), (StackableAstVisitor.StackableAstVisitorContext<Context>)new StackableAstVisitor.StackableAstVisitorContext((Object)((Context)context.getContext()).expectingLambda((List<Type>)functionInputTypes)));
            List<Type> argumentTypes = functionType.getArgumentTypes();
            int numCapturedValues = node.getValues().size();
            Verify.verify((argumentTypes.size() == functionInputTypes.size() ? 1 : 0) != 0);
            for (int i = 0; i < numCapturedValues; ++i) {
                Verify.verify((boolean)((Type)functionInputTypes.get(i)).equals(argumentTypes.get(i)));
            }
            FunctionType result = new FunctionType(argumentTypes.subList(numCapturedValues, argumentTypes.size()), functionType.getReturnType());
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, result);
        }

        protected Type visitExpression(Expression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "not yet implemented: %s", node.getClass().getName());
        }

        protected Type visitNode(Node node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, node, "not yet implemented: %s", node.getClass().getName());
        }

        public Type visitGroupingOperation(GroupingOperation node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getGroupingColumns().size() > 63) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, (Node)node, "GROUPING supports up to %d column arguments", 63);
            }
            for (Expression columnArgument : node.getGroupingColumns()) {
                this.process((Node)columnArgument, context);
            }
            if (node.getGroupingColumns().size() <= 31) {
                return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)IntegerType.INTEGER);
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)BigintType.BIGINT);
        }

        public Type visitJsonExists(JsonExists node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedFunction function;
            List<Type> pathInvocationArgumentTypes = this.analyzeJsonPathInvocation("JSON_EXISTS", (Expression)node, node.getJsonPathInvocation(), context);
            ImmutableList argumentTypes = ImmutableList.builder().addAll(pathInvocationArgumentTypes).add((Object)TinyintType.TINYINT).build();
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_exists", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), function);
            Type type = function.getSignature().getReturnType();
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type);
        }

        public Type visitJsonValue(JsonValue node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedFunction function;
            Type type;
            List<Type> pathInvocationArgumentTypes = this.analyzeJsonPathInvocation("JSON_VALUE", (Expression)node, node.getJsonPathInvocation(), context);
            VarcharType returnedType = VarcharType.VARCHAR;
            if (node.getReturnedType().isPresent()) {
                try {
                    returnedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature((DataType)node.getReturnedType().get()));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getReturnedType().get());
                }
            }
            if (!ExpressionAnalyzer.isCharacterStringType((Type)returnedType) && !ExpressionAnalyzer.isNumericType((Type)returnedType) && !returnedType.equals(BooleanType.BOOLEAN) && !this.isDateTimeType((Type)returnedType) || returnedType.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) || returnedType.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Invalid return type of function JSON_VALUE: %s", node.getReturnedType().get());
            }
            JsonPathAnalyzer.JsonPathAnalysis pathAnalysis = ExpressionAnalyzer.this.jsonPathAnalyses.get(NodeRef.of((Node)node));
            Type resultType = pathAnalysis.getType((PathNode)pathAnalysis.getPath());
            if (resultType != null && !resultType.equals(returnedType)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(resultType, (Type)returnedType);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Return type of JSON path: %s incompatible with return type of function JSON_VALUE: %s", resultType, returnedType);
                }
            }
            if (node.getEmptyDefault().isPresent()) {
                Expression emptyDefault = (Expression)node.getEmptyDefault().get();
                if (node.getEmptyBehavior() != JsonValue.EmptyOrErrorBehavior.DEFAULT) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)emptyDefault, "Default value specified for %s ON EMPTY behavior", node.getEmptyBehavior());
                }
                type = this.process((Node)emptyDefault, context);
                this.coerceType(emptyDefault, type, (Type)returnedType, "Function JSON_VALUE default ON EMPTY result");
            }
            if (node.getErrorDefault().isPresent()) {
                Expression errorDefault = (Expression)node.getErrorDefault().get();
                if (node.getErrorBehavior() != JsonValue.EmptyOrErrorBehavior.DEFAULT) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)errorDefault, "Default value specified for %s ON ERROR behavior", node.getErrorBehavior());
                }
                type = this.process((Node)errorDefault, context);
                this.coerceType(errorDefault, type, (Type)returnedType, "Function JSON_VALUE default ON ERROR result");
            }
            ImmutableList argumentTypes = ImmutableList.builder().addAll(pathInvocationArgumentTypes).add((Object)TinyintType.TINYINT).add((Object)returnedType).add((Object)TinyintType.TINYINT).add((Object)returnedType).build();
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_value", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), function);
            Type type2 = function.getSignature().getReturnType();
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, type2);
        }

        public Type visitJsonQuery(JsonQuery node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedFunction function;
            List<Type> pathInvocationArgumentTypes = this.analyzeJsonPathInvocation("JSON_QUERY", (Expression)node, node.getJsonPathInvocation(), context);
            if ((node.getWrapperBehavior() == JsonQuery.ArrayWrapperBehavior.CONDITIONAL || node.getWrapperBehavior() == JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL) && node.getQuotesBehavior().isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)node, "%s QUOTES behavior specified with WITH %s ARRAY WRAPPER behavior", node.getQuotesBehavior().get(), node.getWrapperBehavior());
            }
            ImmutableList argumentTypes = ImmutableList.builder().addAll(pathInvocationArgumentTypes).add((Object)TinyintType.TINYINT).add((Object)TinyintType.TINYINT).add((Object)TinyintType.TINYINT).build();
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_query", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), function);
            VarcharType returnedType = VarcharType.VARCHAR;
            if (node.getReturnedType().isPresent()) {
                try {
                    returnedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature((DataType)node.getReturnedType().get()));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getReturnedType().get());
                }
            }
            JsonPathParameter.JsonFormat outputFormat = node.getOutputFormat().orElse(JsonPathParameter.JsonFormat.JSON);
            ResolvedFunction outputFunction = this.getOutputFunction((Type)returnedType, outputFormat, (Node)node);
            ExpressionAnalyzer.this.jsonOutputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), outputFunction);
            Type outputType = outputFunction.getSignature().getReturnType();
            if (!outputType.equals(returnedType)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(outputType, (Type)returnedType);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast %s to %s", outputType, returnedType);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)returnedType);
        }

        private List<Type> analyzeJsonPathInvocation(String functionName, Expression node, JsonPathInvocation jsonPathInvocation, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            jsonPathInvocation.getPathName().ifPresent(pathName -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, (Node)pathName, "JSON path name is not allowed in %s function", functionName);
            });
            Expression inputExpression = jsonPathInvocation.getInputExpression();
            Type inputType = this.process((Node)inputExpression, context);
            JsonPathParameter.JsonFormat inputFormat = jsonPathInvocation.getInputFormat();
            ResolvedFunction inputFunction = this.getInputFunction(inputType, inputFormat, (Node)inputExpression);
            Type expectedType = inputFunction.getSignature().getArgumentType(0);
            this.coerceType(inputExpression, inputType, expectedType, String.format("%s function input argument", functionName));
            ExpressionAnalyzer.this.jsonInputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)inputExpression), inputFunction);
            ImmutableMap.Builder types = ImmutableMap.builder();
            HashSet<String> uniqueNames = new HashSet<String>();
            ImmutableList.Builder fields = ImmutableList.builder();
            List pathParameters = jsonPathInvocation.getPathParameters();
            for (JsonPathParameter pathParameter : pathParameters) {
                Object passedType;
                Expression parameter = pathParameter.getParameter();
                String parameterName = pathParameter.getName().getCanonicalValue();
                Optional<JsonPathParameter.JsonFormat> parameterFormat = pathParameter.getFormat();
                if (!uniqueNames.add(parameterName)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PARAMETER_NAME, (Node)pathParameter.getName(), "%s JSON path parameter is specified more than once", parameterName);
                }
                if (parameter instanceof LambdaExpression || parameter instanceof BindExpression) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)parameter, "%s is not supported as JSON path parameter", parameter.getClass().getSimpleName());
                }
                if ((parameter instanceof JsonQuery || parameter instanceof JsonObject || parameter instanceof JsonArray) && parameterFormat.isEmpty()) {
                    parameterFormat = Optional.of(JsonPathParameter.JsonFormat.JSON);
                }
                Type parameterType = this.process((Node)parameter, context);
                if (parameterFormat.isPresent()) {
                    ResolvedFunction parameterInputFunction = this.getInputFunction(parameterType, parameterFormat.get(), (Node)parameter);
                    Type expectedParameterType = parameterInputFunction.getSignature().getArgumentType(0);
                    this.coerceType(parameter, parameterType, expectedParameterType, String.format("%s function JSON path parameter", functionName));
                    ExpressionAnalyzer.this.jsonInputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)parameter), parameterInputFunction);
                    passedType = Json2016Type.JSON_2016;
                } else if (ExpressionAnalyzer.isStringType(parameterType)) {
                    if (!ExpressionAnalyzer.isCharacterStringType(parameterType)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)parameter, "Unsupported type of JSON path parameter: %s", parameterType.getDisplayName());
                    }
                    passedType = parameterType;
                } else if (ExpressionAnalyzer.isNumericType(parameterType) || parameterType.equals(BooleanType.BOOLEAN)) {
                    passedType = parameterType;
                } else if (this.isDateTimeType(parameterType) && !parameterType.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME) && !parameterType.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) {
                    passedType = parameterType;
                } else {
                    try {
                        ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(parameterType, (Type)VarcharType.VARCHAR);
                    }
                    catch (OperatorNotFoundException e) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Unsupported type of JSON path parameter: %s", parameterType.getDisplayName());
                    }
                    this.addOrReplaceExpressionCoercion(parameter, parameterType, (Type)VarcharType.VARCHAR);
                    passedType = VarcharType.VARCHAR;
                }
                types.put((Object)parameterName, passedType);
                fields.add((Object)new RowType.Field(Optional.of(parameterName), passedType));
            }
            RowType parametersRowType = JSON_NO_PARAMETERS_ROW_TYPE;
            if (!pathParameters.isEmpty()) {
                parametersRowType = RowType.from((List)fields.build());
            }
            ImmutableMap typesMap = types.buildOrThrow();
            JsonPathAnalyzer.JsonPathAnalysis pathAnalysis = new JsonPathAnalyzer(ExpressionAnalyzer.this.plannerContext.getMetadata(), ExpressionAnalyzer.this.session, ExpressionAnalyzer.createConstantAnalyzer(ExpressionAnalyzer.this.plannerContext, ExpressionAnalyzer.this.accessControl, ExpressionAnalyzer.this.session, ExpressionAnalyzer.this.parameters, WarningCollector.NOOP)).analyzeJsonPath(jsonPathInvocation.getJsonPath(), (Map<String, Type>)typesMap);
            ExpressionAnalyzer.this.jsonPathAnalyses.put((NodeRef<Expression>)NodeRef.of((Node)node), pathAnalysis);
            return ImmutableList.of((Object)((Object)Json2016Type.JSON_2016), (Object)ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")), (Object)parametersRowType);
        }

        private ResolvedFunction getInputFunction(Type type, JsonPathParameter.JsonFormat format, Node node) {
            String name = switch (format) {
                default -> throw new IncompatibleClassChangeError();
                case JsonPathParameter.JsonFormat.JSON -> {
                    if (UnknownType.UNKNOWN.equals(type) || ExpressionAnalyzer.isCharacterStringType(type)) {
                        yield "$varchar_to_json";
                    }
                    if (ExpressionAnalyzer.isStringType(type)) {
                        yield "$varbinary_to_json";
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot read input of type %s as JSON using formatting %s", type, format);
                }
                case JsonPathParameter.JsonFormat.UTF8 -> "$varbinary_utf8_to_json";
                case JsonPathParameter.JsonFormat.UTF16 -> "$varbinary_utf16_to_json";
                case JsonPathParameter.JsonFormat.UTF32 -> "$varbinary_utf32_to_json";
            };
            try {
                return ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction(name, TypeSignatureProvider.fromTypes(new Type[]{type, BooleanType.BOOLEAN}));
            }
            catch (TrinoException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation(node), String.format("Cannot read input of type %s as JSON using formatting %s", type, format), (Throwable)e);
            }
        }

        private ResolvedFunction getOutputFunction(Type type, JsonPathParameter.JsonFormat format, Node node) {
            String name = switch (format) {
                default -> throw new IncompatibleClassChangeError();
                case JsonPathParameter.JsonFormat.JSON -> {
                    if (ExpressionAnalyzer.isCharacterStringType(type)) {
                        yield "$json_to_varchar";
                    }
                    if (ExpressionAnalyzer.isStringType(type)) {
                        yield "$json_to_varbinary";
                    }
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot output JSON value as %s using formatting %s", type, format);
                }
                case JsonPathParameter.JsonFormat.UTF8 -> {
                    if (!VarbinaryType.VARBINARY.equals((Object)type)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot output JSON value as %s using formatting %s", type, format);
                    }
                    yield "$json_to_varbinary_utf8";
                }
                case JsonPathParameter.JsonFormat.UTF16 -> {
                    if (!VarbinaryType.VARBINARY.equals((Object)type)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot output JSON value as %s using formatting %s", type, format);
                    }
                    yield "$json_to_varbinary_utf16";
                }
                case JsonPathParameter.JsonFormat.UTF32 -> {
                    if (!VarbinaryType.VARBINARY.equals((Object)type)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "Cannot output JSON value as %s using formatting %s", type, format);
                    }
                    yield "$json_to_varbinary_utf32";
                }
            };
            try {
                return ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction(name, TypeSignatureProvider.fromTypes(new Type[]{Json2016Type.JSON_2016, TinyintType.TINYINT, BooleanType.BOOLEAN}));
            }
            catch (TrinoException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ExpressionTreeUtils.extractLocation(node), String.format("Cannot output JSON value as %s using formatting %s", type, format), (Throwable)e);
            }
        }

        protected Type visitJsonObject(JsonObject node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedFunction function;
            ImmutableList.Builder keyFields = ImmutableList.builder();
            ImmutableList.Builder valueFields = ImmutableList.builder();
            for (JsonObjectMember member : node.getMembers()) {
                Expression key = member.getKey();
                Expression value = member.getValue();
                Optional<JsonPathParameter.JsonFormat> format = member.getFormat();
                Type keyType = this.process((Node)key, context);
                if (!ExpressionAnalyzer.isCharacterStringType(keyType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Node)key, "Invalid type of JSON object key: %s", keyType.getDisplayName());
                }
                keyFields.add((Object)new RowType.Field(Optional.empty(), keyType));
                if (value instanceof LambdaExpression || value instanceof BindExpression) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)value, "%s is not supported as JSON object value", value.getClass().getSimpleName());
                }
                if ((value instanceof JsonQuery || value instanceof JsonObject || value instanceof JsonArray) && format.isEmpty()) {
                    format = Optional.of(JsonPathParameter.JsonFormat.JSON);
                }
                Object valueType = this.process((Node)value, context);
                if (format.isPresent()) {
                    if (node.isUniqueKeys()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "WITH UNIQUE KEYS behavior is not supported for JSON_OBJECT function when input expression has FORMAT", new Object[0]);
                    }
                    ResolvedFunction inputFunction = this.getInputFunction((Type)valueType, format.get(), (Node)value);
                    Type expectedValueType = inputFunction.getSignature().getArgumentType(0);
                    this.coerceType(value, (Type)valueType, expectedValueType, "value passed to JSON_OBJECT function");
                    ExpressionAnalyzer.this.jsonInputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)value), inputFunction);
                    valueType = Json2016Type.JSON_2016;
                } else {
                    if (ExpressionAnalyzer.isStringType(valueType) && !ExpressionAnalyzer.isCharacterStringType(valueType)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)value, "Unsupported type of value passed to JSON_OBJECT function: %s", valueType.getDisplayName());
                    }
                    if (!(ExpressionAnalyzer.isStringType(valueType) || ExpressionAnalyzer.isNumericType(valueType) || valueType.equals(BooleanType.BOOLEAN))) {
                        try {
                            ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion((Type)valueType, (Type)VarcharType.VARCHAR);
                        }
                        catch (OperatorNotFoundException e) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Unsupported type of value passed to JSON_OBJECT function: %s", valueType.getDisplayName());
                        }
                        this.addOrReplaceExpressionCoercion(value, (Type)valueType, (Type)VarcharType.VARCHAR);
                        valueType = VarcharType.VARCHAR;
                    }
                }
                valueFields.add((Object)new RowType.Field(Optional.empty(), valueType));
            }
            RowType keysRowType = JSON_NO_PARAMETERS_ROW_TYPE;
            RowType valuesRowType = JSON_NO_PARAMETERS_ROW_TYPE;
            if (!node.getMembers().isEmpty()) {
                keysRowType = RowType.from((List)keyFields.build());
                valuesRowType = RowType.from((List)valueFields.build());
            }
            ImmutableList argumentTypes = ImmutableList.of((Object)keysRowType, (Object)valuesRowType, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN);
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_object", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), function);
            VarcharType returnedType = VarcharType.VARCHAR;
            if (node.getReturnedType().isPresent()) {
                try {
                    returnedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature((DataType)node.getReturnedType().get()));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getReturnedType().get());
                }
            }
            JsonPathParameter.JsonFormat outputFormat = node.getOutputFormat().orElse(JsonPathParameter.JsonFormat.JSON);
            ResolvedFunction outputFunction = this.getOutputFunction((Type)returnedType, outputFormat, (Node)node);
            ExpressionAnalyzer.this.jsonOutputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), outputFunction);
            Type outputType = outputFunction.getSignature().getReturnType();
            if (!outputType.equals(returnedType)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(outputType, (Type)returnedType);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot return type %s from JSON_OBJECT function", returnedType);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)returnedType);
        }

        protected Type visitJsonArray(JsonArray node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedFunction function;
            ImmutableList.Builder elementFields = ImmutableList.builder();
            for (JsonArrayElement arrayElement : node.getElements()) {
                Expression element = arrayElement.getValue();
                Optional<JsonPathParameter.JsonFormat> format = arrayElement.getFormat();
                if (element instanceof LambdaExpression || element instanceof BindExpression) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "%s is not supported as JSON array element", element.getClass().getSimpleName());
                }
                if ((element instanceof JsonQuery || element instanceof JsonObject || element instanceof JsonArray) && format.isEmpty()) {
                    format = Optional.of(JsonPathParameter.JsonFormat.JSON);
                }
                Object elementType = this.process((Node)element, context);
                if (format.isPresent()) {
                    ResolvedFunction inputFunction = this.getInputFunction((Type)elementType, format.get(), (Node)element);
                    Type expectedElementType = inputFunction.getSignature().getArgumentType(0);
                    this.coerceType(element, (Type)elementType, expectedElementType, "value passed to JSON_ARRAY function");
                    ExpressionAnalyzer.this.jsonInputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)element), inputFunction);
                    elementType = Json2016Type.JSON_2016;
                } else {
                    if (ExpressionAnalyzer.isStringType(elementType) && !ExpressionAnalyzer.isCharacterStringType(elementType)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "Unsupported type of value passed to JSON_ARRAY function: %s", elementType.getDisplayName());
                    }
                    if (!(ExpressionAnalyzer.isStringType(elementType) || ExpressionAnalyzer.isNumericType(elementType) || elementType.equals(BooleanType.BOOLEAN))) {
                        try {
                            ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion((Type)elementType, (Type)VarcharType.VARCHAR);
                        }
                        catch (OperatorNotFoundException e) {
                            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)node, "Unsupported type of value passed to JSON_ARRAY function: %s", elementType.getDisplayName());
                        }
                        this.addOrReplaceExpressionCoercion(element, (Type)elementType, (Type)VarcharType.VARCHAR);
                        elementType = VarcharType.VARCHAR;
                    }
                }
                elementFields.add((Object)new RowType.Field(Optional.empty(), elementType));
            }
            RowType elementsRowType = JSON_NO_PARAMETERS_ROW_TYPE;
            if (!node.getElements().isEmpty()) {
                elementsRowType = RowType.from((List)elementFields.build());
            }
            ImmutableList argumentTypes = ImmutableList.of((Object)elementsRowType, (Object)BooleanType.BOOLEAN);
            try {
                function = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveBuiltinFunction("$json_array", TypeSignatureProvider.fromTypes((List<? extends Type>)argumentTypes));
            }
            catch (TrinoException e) {
                if (e.getLocation().isPresent()) {
                    throw e;
                }
                throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)node), e.getMessage(), (Throwable)e);
            }
            ExpressionAnalyzer.this.resolvedFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), function);
            VarcharType returnedType = VarcharType.VARCHAR;
            if (node.getReturnedType().isPresent()) {
                try {
                    returnedType = ExpressionAnalyzer.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature((DataType)node.getReturnedType().get()));
                }
                catch (TypeNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: %s", node.getReturnedType().get());
                }
            }
            JsonPathParameter.JsonFormat outputFormat = node.getOutputFormat().orElse(JsonPathParameter.JsonFormat.JSON);
            ResolvedFunction outputFunction = this.getOutputFunction((Type)returnedType, outputFormat, (Node)node);
            ExpressionAnalyzer.this.jsonOutputFunctions.put((NodeRef<Expression>)NodeRef.of((Node)node), outputFunction);
            Type outputType = outputFunction.getSignature().getReturnType();
            if (!outputType.equals(returnedType)) {
                try {
                    ExpressionAnalyzer.this.plannerContext.getMetadata().getCoercion(outputType, (Type)returnedType);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, "Cannot return type %s from JSON_ARRAY function", returnedType);
                }
            }
            return ExpressionAnalyzer.this.setExpressionType((Expression)node, (Type)returnedType);
        }

        private Type getOperator(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression node, OperatorType operatorType, Expression ... arguments) {
            BoundSignature operatorSignature;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                operatorSignature = ExpressionAnalyzer.this.plannerContext.getMetadata().resolveOperator(operatorType, (List<? extends Type>)argumentTypes.build()).getSignature();
            }
            catch (OperatorNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)node, (Throwable)((Object)e), "%s", e.getMessage());
            }
            for (int i = 0; i < arguments.length; ++i) {
                Expression expression = arguments[i];
                Type type = (Type)operatorSignature.getArgumentTypes().get(i);
                this.coerceType(context, expression, type, String.format("Operator %s argument %d", operatorSignature, i));
            }
            Type type = operatorSignature.getReturnType();
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        private void coerceType(Expression expression, Type actualType, Type expectedType, String message) {
            if (!actualType.equals(expectedType)) {
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(actualType, expectedType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)expression, "%s must evaluate to a %s (actual: %s)", message, expectedType, actualType);
                }
                this.addOrReplaceExpressionCoercion(expression, actualType, expectedType);
            }
        }

        private void coerceType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            this.coerceType(expression, actualType, expectedType, message);
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Node node, String message, Expression first, Expression second) {
            Optional<Type> superTypeOptional;
            UnknownType firstType = UnknownType.UNKNOWN;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            UnknownType secondType = UnknownType.UNKNOWN;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if ((superTypeOptional = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType((Type)firstType, (Type)secondType)).isPresent() && ExpressionAnalyzer.this.typeCoercion.canCoerce((Type)firstType, superTypeOptional.get()) && ExpressionAnalyzer.this.typeCoercion.canCoerce((Type)secondType, superTypeOptional.get())) {
                Type superType = superTypeOptional.get();
                if (!((Object)((Object)firstType)).equals(superType)) {
                    this.addOrReplaceExpressionCoercion(first, (Type)firstType, superType);
                }
                if (!((Object)((Object)secondType)).equals(superType)) {
                    this.addOrReplaceExpressionCoercion(second, (Type)secondType, superType);
                }
                return superType;
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, node, "%s: %s vs %s", new Object[]{message, firstType, secondType});
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, String description, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            LinkedHashMultimap typeExpressions = LinkedHashMultimap.create();
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                typeExpressions.put((Object)type, (Object)NodeRef.of((Node)expression));
            }
            Set types = typeExpressions.keySet();
            for (Type type : types) {
                Optional<Type> newSuperType = ExpressionAnalyzer.this.typeCoercion.getCommonSuperType((Type)superType, type);
                if (newSuperType.isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ((NodeRef)Iterables.get((Iterable)typeExpressions.get((Object)type), (int)0)).getNode(), "%s must be the same type or coercible to a common type. Cannot find common type between %s and %s, all types (without duplicates): %s", new Object[]{description, superType, type, typeExpressions.keySet()});
                }
                superType = newSuperType.get();
            }
            for (Type type : types) {
                Collection coercionCandidates = typeExpressions.get((Object)type);
                if (type.equals((Object)superType)) continue;
                if (!ExpressionAnalyzer.this.typeCoercion.canCoerce(type, (Type)superType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, ((NodeRef)Iterables.get((Iterable)coercionCandidates, (int)0)).getNode(), "%s must be the same type or coercible to a common type. Cannot find common type between %s and %s, all types (without duplicates): %s", new Object[]{description, superType, type, typeExpressions.keySet()});
                }
                this.addOrReplaceExpressionsCoercion(coercionCandidates, type, (Type)superType);
            }
            return superType;
        }

        private void addOrReplaceExpressionCoercion(Expression expression, Type type, Type superType) {
            this.addOrReplaceExpressionsCoercion((Collection<NodeRef<Expression>>)ImmutableList.of((Object)NodeRef.of((Node)expression)), type, superType);
        }

        private void addOrReplaceExpressionsCoercion(Collection<NodeRef<Expression>> expressions, Type type, Type superType) {
            expressions.forEach(expression -> ExpressionAnalyzer.this.expressionCoercions.put((NodeRef<Expression>)expression, superType));
            if (ExpressionAnalyzer.this.typeCoercion.isTypeOnlyCoercion(type, superType)) {
                ExpressionAnalyzer.this.typeOnlyCoercions.addAll(expressions);
            } else {
                ExpressionAnalyzer.this.typeOnlyCoercions.removeAll(expressions);
            }
        }
    }

    private static class Context {
        private final Scope scope;
        private final List<Type> functionInputTypes;
        private final Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration;
        private final Set<String> labels;
        private final CorrelationSupport correlationSupport;

        private Context(Scope scope, List<Type> functionInputTypes, Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration, Set<String> labels, CorrelationSupport correlationSupport) {
            this.scope = Objects.requireNonNull(scope, "scope is null");
            this.functionInputTypes = functionInputTypes;
            this.fieldToLambdaArgumentDeclaration = fieldToLambdaArgumentDeclaration;
            this.labels = labels;
            this.correlationSupport = Objects.requireNonNull(correlationSupport, "correlationSupport is null");
        }

        public static Context notInLambda(Scope scope, CorrelationSupport correlationSupport) {
            return new Context(scope, null, null, null, correlationSupport);
        }

        public Context inLambda(Scope scope, Map<FieldId, LambdaArgumentDeclaration> fieldToLambdaArgumentDeclaration) {
            return new Context(scope, null, Objects.requireNonNull(fieldToLambdaArgumentDeclaration, "fieldToLambdaArgumentDeclaration is null"), this.labels, this.correlationSupport);
        }

        public Context expectingLambda(List<Type> functionInputTypes) {
            return new Context(this.scope, Objects.requireNonNull(functionInputTypes, "functionInputTypes is null"), this.fieldToLambdaArgumentDeclaration, this.labels, this.correlationSupport);
        }

        public Context notExpectingLambda() {
            return new Context(this.scope, null, this.fieldToLambdaArgumentDeclaration, this.labels, this.correlationSupport);
        }

        public static Context patternRecognition(Scope scope, Set<String> labels) {
            return new Context(scope, null, null, Objects.requireNonNull(labels, "labels is null"), CorrelationSupport.DISALLOWED);
        }

        public Context patternRecognition(Set<String> labels) {
            return new Context(this.scope, this.functionInputTypes, this.fieldToLambdaArgumentDeclaration, Objects.requireNonNull(labels, "labels is null"), CorrelationSupport.DISALLOWED);
        }

        public Context notExpectingLabels() {
            return new Context(this.scope, this.functionInputTypes, this.fieldToLambdaArgumentDeclaration, null, this.correlationSupport);
        }

        Scope getScope() {
            return this.scope;
        }

        public boolean isInLambda() {
            return this.fieldToLambdaArgumentDeclaration != null;
        }

        public boolean isExpectingLambda() {
            return this.functionInputTypes != null;
        }

        public boolean isPatternRecognition() {
            return this.labels != null;
        }

        public Map<FieldId, LambdaArgumentDeclaration> getFieldToLambdaArgumentDeclaration() {
            Preconditions.checkState((boolean)this.isInLambda());
            return this.fieldToLambdaArgumentDeclaration;
        }

        public List<Type> getFunctionInputTypes() {
            Preconditions.checkState((boolean)this.isExpectingLambda());
            return this.functionInputTypes;
        }

        public Set<String> getLabels() {
            Preconditions.checkState((boolean)this.isPatternRecognition());
            return this.labels;
        }

        public CorrelationSupport getCorrelationSupport() {
            return this.correlationSupport;
        }
    }

    private static class ArgumentLabel {
        private final boolean hasLabel;
        private final Optional<String> label;

        private ArgumentLabel(boolean hasLabel, Optional<String> label) {
            this.hasLabel = hasLabel;
            this.label = label;
        }

        public static ArgumentLabel noLabel() {
            return new ArgumentLabel(false, Optional.empty());
        }

        public static ArgumentLabel universalLabel() {
            return new ArgumentLabel(true, Optional.empty());
        }

        public static ArgumentLabel explicitLabel(String label) {
            return new ArgumentLabel(true, Optional.of(label));
        }

        public boolean hasLabel() {
            return this.hasLabel;
        }

        public Optional<String> getLabel() {
            Preconditions.checkState((boolean)this.hasLabel, (Object)"no label available");
            return this.label;
        }
    }

    public static class LabelPrefixedReference {
        private final String label;
        private final Optional<Identifier> column;

        public LabelPrefixedReference(String label, Identifier column) {
            this(label, Optional.of(Objects.requireNonNull(column, "column is null")));
        }

        public LabelPrefixedReference(String label) {
            this(label, Optional.empty());
        }

        private LabelPrefixedReference(String label, Optional<Identifier> column) {
            this.label = Objects.requireNonNull(label, "label is null");
            this.column = Objects.requireNonNull(column, "column is null");
        }

        public String getLabel() {
            return this.label;
        }

        public Optional<Identifier> getColumn() {
            return this.column;
        }
    }
}

