/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.Objects;

public class DereferenceCodeGenerator
implements BytecodeGenerator {
    private final Type returnType;
    private final RowExpression base;
    private final int index;

    public DereferenceCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        this.returnType = specialForm.getType();
        Preconditions.checkArgument((specialForm.getArguments().size() == 2 ? 1 : 0) != 0);
        this.base = specialForm.getArguments().get(0);
        this.index = (Integer)((ConstantExpression)specialForm.getArguments().get(1)).getValue();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator) {
        CallSiteBinder callSiteBinder = generator.getCallSiteBinder();
        BytecodeBlock block = new BytecodeBlock().comment("DEREFERENCE").setDescription("DEREFERENCE");
        Variable wasNull = generator.wasNull();
        Variable row = generator.getScope().createTempVariable(SqlRow.class);
        block.putVariable(wasNull, false);
        block.append(generator.generate(this.base)).putVariable(row);
        IfStatement ifRowBlockIsNull = new IfStatement("if row block is null...", new Object[0]).condition((BytecodeNode)wasNull);
        Class javaType = this.returnType.getJavaType();
        LabelNode end = new LabelNode("end");
        ifRowBlockIsNull.ifTrue().comment("if row block is null, push null to the stack and goto 'end' label (return)").putVariable(wasNull, true).pushJavaDefault(javaType).gotoLabel(end);
        block.append((BytecodeNode)ifRowBlockIsNull);
        IfStatement ifFieldIsNull = new IfStatement("if row field is null...", new Object[0]);
        ifFieldIsNull.condition((BytecodeNode)row.invoke("getRawFieldBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)this.index)}).invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{row.invoke("getRawIndex", Integer.TYPE, new BytecodeExpression[0])}));
        ifFieldIsNull.ifTrue().comment("if the field is null, push null to stack").putVariable(wasNull, true).pushJavaDefault(javaType);
        BytecodeExpression value = SqlTypeBytecodeExpression.constantType(callSiteBinder, this.returnType).getValue(row.invoke("getRawFieldBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)this.index)}), row.invoke("getRawIndex", Integer.TYPE, new BytecodeExpression[0]));
        ifFieldIsNull.ifFalse().comment("otherwise call type.getTYPE(row, index)").append((BytecodeNode)value).putVariable(wasNull, false);
        block.append((BytecodeNode)ifFieldIsNull).visitLabel(end);
        return block;
    }
}

