/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public final class DeterminismEvaluator {
    private DeterminismEvaluator() {
    }

    public static boolean isDeterministic(Expression expression, Metadata metadata) {
        return DeterminismEvaluator.isDeterministic(expression, (FunctionCall functionCall) -> metadata.decodeFunction(functionCall.getName()));
    }

    public static boolean isDeterministic(Expression expression, Function<FunctionCall, ResolvedFunction> resolvedFunctionSupplier) {
        Objects.requireNonNull(resolvedFunctionSupplier, "resolvedFunctionSupplier is null");
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean deterministic = new AtomicBoolean(true);
        new Visitor(resolvedFunctionSupplier).process((Node)expression, deterministic);
        return deterministic.get();
    }

    public static boolean containsCurrentTimeFunctions(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean currentTime = new AtomicBoolean(false);
        new CurrentTimeVisitor().process((Node)expression, currentTime);
        return currentTime.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<AtomicBoolean> {
        private final Function<FunctionCall, ResolvedFunction> resolvedFunctionSupplier;

        public Visitor(Function<FunctionCall, ResolvedFunction> resolvedFunctionSupplier) {
            this.resolvedFunctionSupplier = resolvedFunctionSupplier;
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean deterministic) {
            if (!this.resolvedFunctionSupplier.apply(node).isDeterministic()) {
                deterministic.set(false);
                return null;
            }
            return super.visitFunctionCall(node, (Object)deterministic);
        }
    }

    private static class CurrentTimeVisitor
    extends DefaultExpressionTraversalVisitor<AtomicBoolean> {
        private CurrentTimeVisitor() {
        }

        protected Void visitCurrentTime(CurrentTime node, AtomicBoolean currentTime) {
            currentTime.set(true);
            return null;
        }
    }
}

