/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.operator.scalar.TryFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.NullableValue;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.LookupSymbolResolver;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NullLiteral;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LayoutConstraintEvaluator {
    private final Map<Symbol, ColumnHandle> assignments;
    private final ExpressionInterpreter evaluator;
    private final Set<ColumnHandle> arguments;

    public LayoutConstraintEvaluator(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, Session session, TypeProvider types, Map<Symbol, ColumnHandle> assignments, Expression expression) {
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        this.evaluator = new ExpressionInterpreter(expression, plannerContext, session, typeAnalyzer.getTypes(session, types, expression));
        this.arguments = (Set)SymbolsExtractor.extractUnique(expression).stream().map(assignments::get).collect(ImmutableSet.toImmutableSet());
    }

    public Set<ColumnHandle> getArguments() {
        return this.arguments;
    }

    public boolean isCandidate(Map<ColumnHandle, NullableValue> bindings) {
        if (Sets.intersection(bindings.keySet(), this.arguments).isEmpty()) {
            return true;
        }
        LookupSymbolResolver inputs = new LookupSymbolResolver(this.assignments, bindings);
        Boolean optimized = TryFunction.evaluate(() -> this.evaluator.optimize(inputs), true);
        return !Boolean.FALSE.equals(optimized) && optimized != null && !(optimized instanceof NullLiteral);
    }
}

