/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.SliceUtf8;
import io.trino.block.BlockSerdeUtil;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.VarbinaryFunctions;
import io.trino.operator.scalar.timestamp.TimestampToVarcharCast;
import io.trino.operator.scalar.timestamptz.TimestampWithTimeZoneToVarcharCast;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.ResolvedFunctionCallBuilder;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.TimestampLiteral;
import io.trino.type.DateTimes;
import io.trino.type.UnknownType;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public final class LiteralEncoder {
    private final PlannerContext plannerContext;

    public LiteralEncoder(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    public List<Expression> toExpressions(List<?> objects, List<? extends Type> types) {
        Objects.requireNonNull(objects, "objects is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((objects.size() == types.size() ? 1 : 0) != 0, (Object)"objects and types do not have the same size");
        ImmutableList.Builder expressions = ImmutableList.builder();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            Type type = types.get(i);
            expressions.add((Object)this.toExpression(object, type));
        }
        return expressions.build();
    }

    public Expression toExpression(@Nullable Object object, Type type) {
        Expression argument;
        Objects.requireNonNull(type, "type is null");
        if (object instanceof Expression) {
            Expression expression = (Expression)object;
            return expression;
        }
        if (object == null) {
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                return new NullLiteral();
            }
            return new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(type), false, true);
        }
        Preconditions.checkArgument((boolean)Primitives.wrap((Class)type.getJavaType()).isInstance(object), (String)"object.getClass (%s) and type.getJavaType (%s) do not agree", object.getClass(), (Object)type.getJavaType());
        if (type.equals(TinyintType.TINYINT)) {
            return new GenericLiteral("TINYINT", object.toString());
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new GenericLiteral("SMALLINT", object.toString());
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new LongLiteral(object.toString());
        }
        if (type.equals(BigintType.BIGINT)) {
            LongLiteral expression = new LongLiteral(object.toString());
            if (expression.getParsedValue() >= Integer.MIN_VALUE && expression.getParsedValue() <= Integer.MAX_VALUE) {
                return new GenericLiteral("BIGINT", object.toString());
            }
            return new LongLiteral(object.toString());
        }
        if (type.equals(DoubleType.DOUBLE)) {
            Double value = (Double)object;
            if (value.isNaN()) {
                return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("nan").build();
            }
            if (value.equals(Double.NEGATIVE_INFINITY)) {
                return ArithmeticUnaryExpression.negative((Expression)BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("infinity").build());
            }
            if (value.equals(Double.POSITIVE_INFINITY)) {
                return BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("infinity").build();
            }
            return new DoubleLiteral(object.toString());
        }
        if (type.equals(RealType.REAL)) {
            Float value = Float.valueOf(Float.intBitsToFloat(((Long)object).intValue()));
            if (value.isNaN()) {
                return new Cast((Expression)BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("nan").build(), TypeSignatureTranslator.toSqlType((Type)RealType.REAL));
            }
            if (value.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                return ArithmeticUnaryExpression.negative((Expression)new Cast((Expression)BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("infinity").build(), TypeSignatureTranslator.toSqlType((Type)RealType.REAL)));
            }
            if (value.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                return new Cast((Expression)BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("infinity").build(), TypeSignatureTranslator.toSqlType((Type)RealType.REAL));
            }
            return new GenericLiteral("REAL", value.toString());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String string = decimalType.isShort() ? Decimals.toString((long)((Long)object), (int)decimalType.getScale()) : Decimals.toString((Int128)((Int128)object), (int)decimalType.getScale());
            return new Cast((Expression)new DecimalLiteral(string), TypeSignatureTranslator.toSqlType(type));
        }
        if (type instanceof VarcharType) {
            int valueLength;
            VarcharType varcharType = (VarcharType)type;
            Slice value = (Slice)object;
            if (varcharType.isUnbounded()) {
                return new GenericLiteral("VARCHAR", value.toStringUtf8());
            }
            StringLiteral stringLiteral = new StringLiteral(value.toStringUtf8());
            int boundedLength = varcharType.getBoundedLength();
            if (boundedLength == (valueLength = SliceUtf8.countCodePoints((Slice)value))) {
                return stringLiteral;
            }
            if (boundedLength > valueLength) {
                return new Cast((Expression)stringLiteral, TypeSignatureTranslator.toSqlType(type), false, true);
            }
            throw new IllegalArgumentException(String.format("Value [%s] does not fit in type %s", value.toStringUtf8(), varcharType));
        }
        if (type instanceof CharType) {
            StringLiteral stringLiteral = new StringLiteral(((Slice)object).toStringUtf8());
            return new Cast((Expression)stringLiteral, TypeSignatureTranslator.toSqlType(type), false, true);
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanLiteral(object.toString());
        }
        if (type.equals(DateType.DATE)) {
            return new GenericLiteral("DATE", new SqlDate(Math.toIntExact((Long)object)).toString());
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            String representation = timestampType.isShort() ? TimestampToVarcharCast.cast((long)timestampType.getPrecision(), (Long)object).toStringUtf8() : TimestampToVarcharCast.cast((long)timestampType.getPrecision(), (LongTimestamp)object).toStringUtf8();
            return new TimestampLiteral(representation);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            String representation = timestampWithTimeZoneType.isShort() ? TimestampWithTimeZoneToVarcharCast.cast((long)timestampWithTimeZoneType.getPrecision(), (Long)object).toStringUtf8() : TimestampWithTimeZoneToVarcharCast.cast((long)timestampWithTimeZoneType.getPrecision(), (LongTimestampWithTimeZone)object).toStringUtf8();
            if (object.equals(DateTimes.parseTimestampWithTimeZone(timestampWithTimeZoneType.getPrecision(), representation))) {
                return new TimestampLiteral(representation);
            }
        }
        if (!type.getJavaType().isPrimitive() && type.getJavaType() != Slice.class && type.getJavaType() != Block.class) {
            object = Utils.nativeValueToBlock((Type)type, (Object)object);
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(block.getSizeInBytes()));
            BlockSerdeUtil.writeBlock(this.plannerContext.getBlockEncodingSerde(), (SliceOutput)output, block);
            object = output.slice();
        }
        Type argumentType = LiteralFunction.typeForMagicLiteral(type);
        if (object instanceof Slice) {
            Slice slice = (Slice)object;
            Slice encoded = VarbinaryFunctions.toBase64(slice);
            argument = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("from_base64").addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral(encoded.toStringUtf8())).build();
        } else {
            argument = this.toExpression(object, argumentType);
        }
        ResolvedFunction resolvedFunction = this.plannerContext.getMetadata().getCoercion(GlobalFunctionCatalog.builtinFunctionName("$literal$"), argumentType, type);
        return ResolvedFunctionCallBuilder.builder(resolvedFunction).addArgument(argument).build();
    }
}

