/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.SampleType;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Rules;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Optional;

public class PushSampleIntoTableScan
implements Rule<SampleNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<SampleNode> PATTERN = Patterns.sample().with(Patterns.Sample.sampleType().equalTo((Object)SampleNode.Type.SYSTEM)).with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;

    public PushSampleIntoTableScan(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<SampleNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(SampleNode sample, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        return this.metadata.applySample(context.getSession(), tableScan.getTable(), PushSampleIntoTableScan.getSamplingType(sample.getSampleType()), sample.getSampleRatio()).map(result -> Rule.Result.ofPlanNode(new TableScanNode(tableScan.getId(), (TableHandle)result.getHandle(), tableScan.getOutputSymbols(), tableScan.getAssignments(), tableScan.getEnforcedConstraint(), Rules.deriveTableStatisticsForPushdown(context.getStatsProvider(), context.getSession(), result.isPrecalculateStatistics(), sample), tableScan.isUpdateTarget(), Optional.empty()))).orElseGet(Rule.Result::empty);
    }

    private static SampleType getSamplingType(SampleNode.Type sampleNodeType) {
        return switch (sampleNodeType) {
            default -> throw new IncompatibleClassChangeError();
            case SampleNode.Type.SYSTEM -> SampleType.SYSTEM;
            case SampleNode.Type.BERNOULLI -> SampleType.BERNOULLI;
        };
    }
}

