/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.trino.cost.PlanNodeStatsAndCostSummary;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.NullLiteral;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public class JoinNode
extends PlanNode {
    private final Type type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<EquiJoinClause> criteria;
    private final List<Symbol> leftOutputSymbols;
    private final List<Symbol> rightOutputSymbols;
    private final boolean maySkipOutputDuplicates;
    private final Optional<Expression> filter;
    private final Optional<Symbol> leftHashSymbol;
    private final Optional<Symbol> rightHashSymbol;
    private final Optional<DistributionType> distributionType;
    private final Optional<Boolean> spillable;
    private final Map<DynamicFilterId, Symbol> dynamicFilters;
    private final Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost;

    @JsonCreator
    public JoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="leftOutputSymbols") List<Symbol> leftOutputSymbols, @JsonProperty(value="rightOutputSymbols") List<Symbol> rightOutputSymbols, @JsonProperty(value="maySkipOutputDuplicates") boolean maySkipOutputDuplicates, @JsonProperty(value="filter") Optional<Expression> filter, @JsonProperty(value="leftHashSymbol") Optional<Symbol> leftHashSymbol, @JsonProperty(value="rightHashSymbol") Optional<Symbol> rightHashSymbol, @JsonProperty(value="distributionType") Optional<DistributionType> distributionType, @JsonProperty(value="spillable") Optional<Boolean> spillable, @JsonProperty(value="dynamicFilters") Map<DynamicFilterId, Symbol> dynamicFilters, @JsonProperty(value="reorderJoinStatsAndCost") Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        Objects.requireNonNull(criteria, "criteria is null");
        Objects.requireNonNull(leftOutputSymbols, "leftOutputSymbols is null");
        Objects.requireNonNull(rightOutputSymbols, "rightOutputSymbols is null");
        Objects.requireNonNull(filter, "filter is null");
        Preconditions.checkArgument((filter.isEmpty() || !(filter.get() instanceof NullLiteral) ? 1 : 0) != 0, (String)"Filter must be an expression of boolean type: %s", filter);
        Objects.requireNonNull(leftHashSymbol, "leftHashSymbol is null");
        Objects.requireNonNull(rightHashSymbol, "rightHashSymbol is null");
        Objects.requireNonNull(distributionType, "distributionType is null");
        Objects.requireNonNull(spillable, "spillable is null");
        this.type = type;
        this.left = left;
        this.right = right;
        this.criteria = ImmutableList.copyOf(criteria);
        this.leftOutputSymbols = ImmutableList.copyOf(leftOutputSymbols);
        this.rightOutputSymbols = ImmutableList.copyOf(rightOutputSymbols);
        this.maySkipOutputDuplicates = maySkipOutputDuplicates;
        this.filter = filter;
        this.leftHashSymbol = leftHashSymbol;
        this.rightHashSymbol = rightHashSymbol;
        this.distributionType = distributionType;
        this.spillable = spillable;
        this.dynamicFilters = ImmutableMap.copyOf(Objects.requireNonNull(dynamicFilters, "dynamicFilters is null"));
        this.reorderJoinStatsAndCost = Objects.requireNonNull(reorderJoinStatsAndCost, "reorderJoinStatsAndCost is null");
        ImmutableSet leftSymbols = ImmutableSet.copyOf(left.getOutputSymbols());
        ImmutableSet rightSymbols = ImmutableSet.copyOf(right.getOutputSymbols());
        Preconditions.checkArgument((boolean)leftSymbols.containsAll(leftOutputSymbols), (Object)"Left source inputs do not contain all left output symbols");
        Preconditions.checkArgument((boolean)rightSymbols.containsAll(rightOutputSymbols), (Object)"Right source inputs do not contain all right output symbols");
        Preconditions.checkArgument((!criteria.isEmpty() || !leftHashSymbol.isPresent() ? 1 : 0) != 0, (Object)"Left hash symbol is only valid in an equijoin");
        Preconditions.checkArgument((!criteria.isEmpty() || !rightHashSymbol.isPresent() ? 1 : 0) != 0, (Object)"Right hash symbol is only valid in an equijoin");
        criteria.forEach(arg_0 -> JoinNode.lambda$new$0((Set)leftSymbols, (Set)rightSymbols, arg_0));
        if (distributionType.isPresent()) {
            Preconditions.checkArgument((distributionType.get() != DistributionType.REPLICATED || type != Type.RIGHT && type != Type.FULL ? 1 : 0) != 0, (String)"%s join do not work with %s distribution type", (Object)((Object)type), (Object)((Object)distributionType.get()));
        }
        for (Symbol symbol : dynamicFilters.values()) {
            Preconditions.checkArgument((boolean)rightSymbols.contains(symbol), (String)"Right join input doesn't contain symbol for dynamic filter: %s", (Object)symbol);
        }
    }

    public JoinNode flipChildren() {
        return new JoinNode(this.getId(), JoinNode.flipType(this.type), this.right, this.left, JoinNode.flipJoinCriteria(this.criteria), this.rightOutputSymbols, this.leftOutputSymbols, this.maySkipOutputDuplicates, this.filter, this.rightHashSymbol, this.leftHashSymbol, this.distributionType, this.spillable, (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), this.reorderJoinStatsAndCost);
    }

    private static Type flipType(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.INNER -> Type.INNER;
            case Type.FULL -> Type.FULL;
            case Type.LEFT -> Type.RIGHT;
            case Type.RIGHT -> Type.LEFT;
        };
    }

    private static List<EquiJoinClause> flipJoinCriteria(List<EquiJoinClause> joinCriteria) {
        return (List)joinCriteria.stream().map(EquiJoinClause::flip).collect(ImmutableList.toImmutableList());
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="left")
    public PlanNode getLeft() {
        return this.left;
    }

    @JsonProperty(value="right")
    public PlanNode getRight() {
        return this.right;
    }

    @JsonProperty(value="criteria")
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty(value="leftOutputSymbols")
    public List<Symbol> getLeftOutputSymbols() {
        return this.leftOutputSymbols;
    }

    @JsonProperty(value="rightOutputSymbols")
    public List<Symbol> getRightOutputSymbols() {
        return this.rightOutputSymbols;
    }

    @JsonProperty(value="filter")
    public Optional<Expression> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="leftHashSymbol")
    public Optional<Symbol> getLeftHashSymbol() {
        return this.leftHashSymbol;
    }

    @JsonProperty(value="rightHashSymbol")
    public Optional<Symbol> getRightHashSymbol() {
        return this.rightHashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.leftOutputSymbols).addAll(this.rightOutputSymbols).build();
    }

    @JsonProperty(value="distributionType")
    public Optional<DistributionType> getDistributionType() {
        return this.distributionType;
    }

    @JsonProperty(value="spillable")
    public Optional<Boolean> isSpillable() {
        return this.spillable;
    }

    @JsonProperty(value="maySkipOutputDuplicates")
    public boolean isMaySkipOutputDuplicates() {
        return this.maySkipOutputDuplicates;
    }

    @JsonProperty
    public Map<DynamicFilterId, Symbol> getDynamicFilters() {
        return this.dynamicFilters;
    }

    @JsonProperty
    public Optional<PlanNodeStatsAndCostSummary> getReorderJoinStatsAndCost() {
        return this.reorderJoinStatsAndCost;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new JoinNode(this.getId(), this.type, newChildren.get(0), newChildren.get(1), this.criteria, this.leftOutputSymbols, this.rightOutputSymbols, this.maySkipOutputDuplicates, this.filter, this.leftHashSymbol, this.rightHashSymbol, this.distributionType, this.spillable, this.dynamicFilters, this.reorderJoinStatsAndCost);
    }

    public JoinNode withDistributionType(DistributionType distributionType) {
        return new JoinNode(this.getId(), this.type, this.left, this.right, this.criteria, this.leftOutputSymbols, this.rightOutputSymbols, this.maySkipOutputDuplicates, this.filter, this.leftHashSymbol, this.rightHashSymbol, Optional.of(distributionType), this.spillable, this.dynamicFilters, this.reorderJoinStatsAndCost);
    }

    public JoinNode withSpillable(boolean spillable) {
        return new JoinNode(this.getId(), this.type, this.left, this.right, this.criteria, this.leftOutputSymbols, this.rightOutputSymbols, this.maySkipOutputDuplicates, this.filter, this.leftHashSymbol, this.rightHashSymbol, this.distributionType, Optional.of(spillable), this.dynamicFilters, this.reorderJoinStatsAndCost);
    }

    public JoinNode withMaySkipOutputDuplicates() {
        return new JoinNode(this.getId(), this.type, this.left, this.right, this.criteria, this.leftOutputSymbols, this.rightOutputSymbols, true, this.filter, this.leftHashSymbol, this.rightHashSymbol, this.distributionType, this.spillable, this.dynamicFilters, this.reorderJoinStatsAndCost);
    }

    public JoinNode withReorderJoinStatsAndCost(PlanNodeStatsAndCostSummary statsAndCost) {
        return new JoinNode(this.getId(), this.type, this.left, this.right, this.criteria, this.leftOutputSymbols, this.rightOutputSymbols, this.maySkipOutputDuplicates, this.filter, this.leftHashSymbol, this.rightHashSymbol, this.distributionType, this.spillable, this.dynamicFilters, Optional.of(statsAndCost));
    }

    public JoinNode withoutDynamicFilters() {
        return new JoinNode(this.getId(), this.type, this.left, this.right, this.criteria, this.leftOutputSymbols, this.rightOutputSymbols, this.maySkipOutputDuplicates, this.filter, this.leftHashSymbol, this.rightHashSymbol, this.distributionType, this.spillable, (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), this.reorderJoinStatsAndCost);
    }

    public boolean isCrossJoin() {
        return this.criteria.isEmpty() && this.filter.isEmpty() && this.type == Type.INNER;
    }

    private static /* synthetic */ void lambda$new$0(Set leftSymbols, Set rightSymbols, EquiJoinClause equiJoinClause) {
        Preconditions.checkArgument((leftSymbols.contains(equiJoinClause.getLeft()) && rightSymbols.contains(equiJoinClause.getRight()) ? 1 : 0) != 0, (String)"Equality join criteria should be normalized according to join sides: %s", (Object)equiJoinClause);
    }

    public static enum Type {
        INNER("InnerJoin"),
        LEFT("LeftJoin"),
        RIGHT("RightJoin"),
        FULL("FullJoin");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }

        public static Type typeConvert(Join.Type joinType) {
            return switch (joinType) {
                default -> throw new IncompatibleClassChangeError();
                case Join.Type.CROSS, Join.Type.IMPLICIT, Join.Type.INNER -> INNER;
                case Join.Type.LEFT -> LEFT;
                case Join.Type.RIGHT -> RIGHT;
                case Join.Type.FULL -> FULL;
            };
        }
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }

    public static class EquiJoinClause {
        private final Symbol left;
        private final Symbol right;

        @JsonCreator
        public EquiJoinClause(@JsonProperty(value="left") Symbol left, @JsonProperty(value="right") Symbol right) {
            this.left = Objects.requireNonNull(left, "left is null");
            this.right = Objects.requireNonNull(right, "right is null");
        }

        @JsonProperty(value="left")
        public Symbol getLeft() {
            return this.left;
        }

        @JsonProperty(value="right")
        public Symbol getRight() {
            return this.right;
        }

        public ComparisonExpression toExpression() {
            return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)this.left.toSymbolReference(), (Expression)this.right.toSymbolReference());
        }

        public EquiJoinClause flip() {
            return new EquiJoinClause(this.right, this.left);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            EquiJoinClause other = (EquiJoinClause)obj;
            return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public String toString() {
            return String.format("%s = %s", this.left, this.right);
        }
    }
}

