/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockJsonSerde;
import io.trino.json.ir.IrJsonPath;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.TypeDeserializer;
import java.util.Map;

public class JsonPath2016Type
extends AbstractVariableWidthType {
    public static final String NAME = "JsonPath2016";
    private final JsonCodec<IrJsonPath> jsonPathCodec;

    public JsonPath2016Type(TypeDeserializer typeDeserializer, BlockEncodingSerde blockEncodingSerde) {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), IrJsonPath.class);
        this.jsonPathCodec = JsonPath2016Type.getCodec(typeDeserializer, blockEncodingSerde);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        String json = valueBlock.getSlice(valuePosition).toStringUtf8();
        return this.jsonPathCodec.fromJson(json);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        String json = this.jsonPathCodec.toJson((Object)((IrJsonPath)value));
        Slice bytes = Slices.utf8Slice((String)json);
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(bytes);
    }

    private static JsonCodec<IrJsonPath> getCodec(TypeDeserializer typeDeserializer, BlockEncodingSerde blockEncodingSerde) {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(Block.class, (Object)((Object)new BlockJsonSerde.Serializer(blockEncodingSerde))));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)typeDeserializer), Block.class, (Object)((Object)new BlockJsonSerde.Deserializer(blockEncodingSerde))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(IrJsonPath.class);
    }
}

