/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.Int128ArrayBlockBuilder;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInt128ArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestInt128ArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestInt128ArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestInt128ArrayBlock.alternatingNullValues(TestInt128ArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestInt128ArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestInt128ArrayBlock.createTestValue(100);
        Int128ArrayBlockBuilder emptyBlockBuilder = new Int128ArrayBlockBuilder(null, 0);
        Int128ArrayBlockBuilder blockBuilder = new Int128ArrayBlockBuilder(null, expectedValues.length);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestInt128ArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestInt128ArrayBlock.createTestValue(100);
        TestInt128ArrayBlock.assertEstimatedDataSizeForStats(TestInt128ArrayBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        long[] longArray = new long[]{0L, 0L, 0L, 0L, 0L, 1L, 0L, 2L, 0L, 3L, 0L, 4L};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestInt128ArrayBlock.testCompactBlock((Block)new Int128ArrayBlock(0, Optional.empty(), new long[0]));
        TestInt128ArrayBlock.testCompactBlock((Block)new Int128ArrayBlock(valueIsNull.length, Optional.of(valueIsNull), longArray));
        TestInt128ArrayBlock.testIncompactBlock((Block)new Int128ArrayBlock(valueIsNull.length - 2, Optional.of(valueIsNull), longArray));
    }

    private void assertFixedWithValues(Slice[] expectedValues) {
        Block block = TestInt128ArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        Int128ArrayBlockBuilder blockBuilder = new Int128ArrayBlockBuilder(null, expectedValues.length);
        TestInt128ArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(expectedValue.getLong(0), expectedValue.getLong(8));
        }
    }

    private static Slice[] createTestValue(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestInt128ArrayBlock.createExpectedValue(16);
        }
        return expectedValues;
    }

    @Override
    protected boolean isByteAccessSupported() {
        return false;
    }

    @Override
    protected boolean isShortAccessSupported() {
        return false;
    }

    @Override
    protected boolean isIntAccessSupported() {
        return false;
    }

    @Override
    protected boolean isLongAccessSupported() {
        return false;
    }

    @Override
    protected boolean isAlignedLongAccessSupported() {
        return true;
    }

    @Override
    protected boolean isSliceAccessSupported() {
        return false;
    }
}

