/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slices;
import io.trino.block.AbstractTestBlock;
import io.trino.block.BlockAssertions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.DuplicateMapKeyException;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.StructuralTestUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMapBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        this.testWith(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactKeyBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock compactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock inCompactKeyBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(17).getBytes());
        ByteArrayBlock inCompactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(17).getBytes());
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] mapIsNull = new boolean[]{false, true, false, false, false, false};
        TestMapBlock.testCompactBlock((Block)StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(Optional.empty(), new int[1], (Block)emptyBlock, (Block)emptyBlock));
        TestMapBlock.testCompactBlock((Block)StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(Optional.of(mapIsNull), offsets, (Block)compactKeyBlock, (Block)compactValueBlock));
        TestMapBlock.testIncompactBlock((Block)StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(Optional.of(mapIsNull), offsets, (Block)inCompactKeyBlock, (Block)inCompactValueBlock));
    }

    @Test
    public void testLazyHashTableBuildOverBlockRegion() {
        this.assertLazyHashTableBuildOverBlockRegion(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
        this.assertLazyHashTableBuildOverBlockRegion(TestMapBlock.alternatingNullValues(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5)));
    }

    private void assertLazyHashTableBuildOverBlockRegion(Map<String, Long>[] testValues) {
        this.testLazyGetPositionsHashTable(testValues);
        this.testLazyBeginningGetRegionHashTable(testValues);
        this.testLazyMiddleGetRegionHashTable(testValues);
        this.testLazyEndGetRegionHashTable(testValues);
    }

    private void testLazyGetPositionsHashTable(Map<String, Long>[] testValues) {
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(testValues);
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isFalse();
        int[] testPositions = new int[]{7, 1, 5, 2, 3, 7};
        Block prefix = block.getPositions(testPositions, 0, testPositions.length);
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isFalse();
        this.assertBlock(prefix, TestMapBlock.getArrayPositions(testValues, testPositions));
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isTrue();
    }

    private static Map<String, Long>[] getArrayPositions(Map<String, Long>[] testPositions, int[] positions) {
        Map[] values = new Map[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            values[i] = testPositions[positions[i]];
        }
        return values;
    }

    private void testLazyBeginningGetRegionHashTable(Map<String, Long>[] testValues) {
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(testValues);
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isFalse();
        MapBlock prefix = block.getRegion(0, 4);
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isFalse();
        Assertions.assertThat((boolean)prefix.isHashTablesPresent()).isFalse();
        this.assertBlock((Block)prefix, Arrays.copyOfRange(testValues, 0, 4));
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isTrue();
        Assertions.assertThat((boolean)prefix.isHashTablesPresent()).isTrue();
        MapBlock midSection = block.getRegion(2, 4);
        Assertions.assertThat((boolean)midSection.isHashTablesPresent()).isTrue();
        this.assertBlock((Block)midSection, Arrays.copyOfRange(testValues, 2, 6));
        MapBlock suffix = block.getRegion(4, 4);
        Assertions.assertThat((boolean)suffix.isHashTablesPresent()).isTrue();
        this.assertBlock((Block)suffix, Arrays.copyOfRange(testValues, 4, 8));
    }

    private void testLazyMiddleGetRegionHashTable(Map<String, Long>[] testValues) {
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(testValues);
        MapBlock midSection = block.getRegion(2, 4);
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isFalse();
        Assertions.assertThat((boolean)midSection.isHashTablesPresent()).isFalse();
        this.assertBlock((Block)midSection, Arrays.copyOfRange(testValues, 2, 6));
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isTrue();
        Assertions.assertThat((boolean)midSection.isHashTablesPresent()).isTrue();
        MapBlock prefix = block.getRegion(0, 4);
        Assertions.assertThat((boolean)prefix.isHashTablesPresent()).isTrue();
        this.assertBlock((Block)prefix, Arrays.copyOfRange(testValues, 0, 4));
        MapBlock suffix = block.getRegion(4, 4);
        Assertions.assertThat((boolean)suffix.isHashTablesPresent()).isTrue();
        this.assertBlock((Block)suffix, Arrays.copyOfRange(testValues, 4, 8));
    }

    private void testLazyEndGetRegionHashTable(Map<String, Long>[] testValues) {
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(testValues);
        MapBlock suffix = block.getRegion(4, 4);
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isFalse();
        Assertions.assertThat((boolean)suffix.isHashTablesPresent()).isFalse();
        this.assertBlock((Block)suffix, Arrays.copyOfRange(testValues, 4, 8));
        Assertions.assertThat((boolean)block.isHashTablesPresent()).isTrue();
        Assertions.assertThat((boolean)suffix.isHashTablesPresent()).isTrue();
        MapBlock prefix = block.getRegion(0, 4);
        Assertions.assertThat((boolean)prefix.isHashTablesPresent()).isTrue();
        this.assertBlock((Block)prefix, Arrays.copyOfRange(testValues, 0, 4));
        MapBlock midSection = block.getRegion(2, 4);
        Assertions.assertThat((boolean)midSection.isHashTablesPresent()).isTrue();
        this.assertBlock((Block)midSection, Arrays.copyOfRange(testValues, 2, 6));
    }

    private static Map<String, Long>[] createTestMap(int ... entryCounts) {
        Map[] result = new Map[entryCounts.length];
        for (int rowNumber = 0; rowNumber < entryCounts.length; ++rowNumber) {
            int entryCount = entryCounts[rowNumber];
            HashMap<CallSite, Long> map = new HashMap<CallSite, Long>();
            for (int entryNumber = 0; entryNumber < entryCount; ++entryNumber) {
                map.put((CallSite)((Object)("key" + entryNumber)), entryNumber == 5 ? null : Long.valueOf((long)rowNumber * 100L + (long)entryNumber));
            }
            result[rowNumber] = map;
        }
        return result;
    }

    private void testWith(Map<String, Long>[] expectedValues) {
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(expectedValues);
        this.assertBlock(blockBuilder.build(), expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 2, 3, 5, 6);
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(expectedValues);
        Assertions.assertThat((boolean)block.mayHaveNull()).isFalse();
        this.assertBlock((Block)block, expectedValues);
        this.assertBlockFilteredPositions(expectedValues, (Block)block, 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, (Block)block, 2, 3, 5, 6);
        Map<String, Long>[] expectedValuesWithNull = TestMapBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = this.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), expectedValuesWithNull);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockBuilderWithNull.build(), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockBuilderWithNull.build(), 2, 3, 4, 9, 13, 14);
        MapBlock blockWithNull = this.createBlockWithValuesFromKeyValueBlock(expectedValuesWithNull);
        Assertions.assertThat((boolean)blockWithNull.mayHaveNull()).isTrue();
        this.assertBlock((Block)blockWithNull, expectedValuesWithNull);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockWithNull, 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockWithNull, 2, 3, 4, 9, 13, 14);
    }

    private BlockBuilder createBlockBuilderWithValues(Map<String, Long>[] maps) {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        MapBlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
        for (Map<String, Long> map : maps) {
            this.createBlockBuilderWithValues(map, mapBlockBuilder);
        }
        return mapBlockBuilder;
    }

    private MapBlock createBlockWithValuesFromKeyValueBlock(Map<String, Long>[] maps) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Long> values = new ArrayList<Long>();
        int[] offsets = new int[maps.length + 1];
        boolean[] mapIsNull = new boolean[maps.length];
        boolean hasNullValue = false;
        for (int i = 0; i < maps.length; ++i) {
            boolean isNull;
            Map<String, Long> map = maps[i];
            mapIsNull[i] = isNull = map == null;
            hasNullValue |= isNull;
            if (map == null) {
                offsets[i + 1] = offsets[i];
                continue;
            }
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                keys.add(entry.getKey());
                values.add(entry.getValue());
            }
            offsets[i + 1] = offsets[i] + map.size();
        }
        return StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT).createBlockFromKeyValue(hasNullValue ? Optional.of(mapIsNull) : Optional.empty(), offsets, (Block)BlockAssertions.createStringsBlock(keys), (Block)BlockAssertions.createLongsBlock(values));
    }

    private void createBlockBuilderWithValues(Map<String, Long> map, MapBlockBuilder mapBlockBuilder) {
        if (map == null) {
            mapBlockBuilder.appendNull();
        } else {
            mapBlockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
                for (Map.Entry entry : map.entrySet()) {
                    VarcharType.VARCHAR.writeSlice(keyBuilder, Slices.utf8Slice((String)((String)entry.getKey())));
                    if (entry.getValue() == null) {
                        valueBuilder.appendNull();
                        continue;
                    }
                    BigintType.BIGINT.writeLong(valueBuilder, ((Long)entry.getValue()).longValue());
                }
            });
        }
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue instanceof Map) {
            this.assertValue(block, position, (Map)expectedValue);
            return;
        }
        super.assertPositionValue(block, position, expectedValue);
    }

    private void assertValue(Block mapBlock, int position, Map<String, Long> map) {
        int i;
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        Objects.requireNonNull(map, "map is null");
        Assertions.assertThat((boolean)mapBlock.isNull(position)).isFalse();
        SqlMap sqlMap = mapType.getObject(mapBlock, position);
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        Assertions.assertThat((int)sqlMap.getSize()).isEqualTo(map.size());
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            int index = sqlMap.seekKey((Object)Slices.utf8Slice((String)entry.getKey()));
            Assertions.assertThat((int)index).isNotEqualTo(-1);
            if (entry.getValue() == null) {
                Assertions.assertThat((boolean)rawValueBlock.isNull(rawOffset + index)).isTrue();
                continue;
            }
            Assertions.assertThat((boolean)rawValueBlock.isNull(rawOffset + index)).isFalse();
            Assertions.assertThat((long)BigintType.BIGINT.getLong(rawValueBlock, rawOffset + index)).isEqualTo(entry.getValue().longValue());
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((int)sqlMap.seekKey((Object)Slices.utf8Slice((String)("not-inserted-" + i)))).isEqualTo(-1);
        }
        for (i = 0; i < sqlMap.getSize(); ++i) {
            String actualKey = VarcharType.VARCHAR.getSlice(rawKeyBlock, rawOffset + i).toStringUtf8();
            Long actualValue = rawValueBlock.isNull(rawOffset + i) ? null : Long.valueOf(BigintType.BIGINT.getLong(rawValueBlock, rawOffset + i));
            Assertions.assertThat(map).containsEntry((Object)actualKey, actualValue);
        }
    }

    @Test
    public void testStrict() {
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        MapBlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
        mapBlockBuilder.strict();
        for (int i = 0; i < 100; ++i) {
            mapBlockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
                BigintType.BIGINT.writeLong(keyBuilder, 1L);
                BigintType.BIGINT.writeLong(valueBuilder, -1L);
            });
        }
        mapBlockBuilder.build();
        mapBlockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
            for (int i = 0; i < 50; ++i) {
                BigintType.BIGINT.writeLong(keyBuilder, (long)i);
                BigintType.BIGINT.writeLong(valueBuilder, -1L);
            }
        });
        mapBlockBuilder.build();
        mapBlockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
            for (int i = 0; i < 2; ++i) {
                BigintType.BIGINT.writeLong(keyBuilder, 99L);
                BigintType.BIGINT.writeLong(valueBuilder, -1L);
            }
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MapBlockBuilder)mapBlockBuilder).build()).isInstanceOf(DuplicateMapKeyException.class)).hasMessage("Duplicate map keys are not allowed");
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Map<String, Long>[] expectedValues = TestMapBlock.alternatingNullValues(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(expectedValues);
        Block block = blockBuilder.build();
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = TestMapBlock.getExpectedEstimatedDataSize(expectedValues[i]);
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(i)).isEqualTo((long)expectedSize);
        }
    }

    private static int getExpectedEstimatedDataSize(Map<String, Long> map) {
        if (map == null) {
            return 0;
        }
        int size = 0;
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            size += entry.getKey().length();
            size += entry.getValue() == null ? 0 : 8;
        }
        return size;
    }
}

