/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.EstimateAssertion;
import io.trino.cost.StatisticRange;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatisticRange {
    @Test
    public void testOverlapPercentWith() {
        StatisticRange zeroToTen = TestStatisticRange.range(0.0, 10.0, 10.0);
        StatisticRange empty = StatisticRange.empty();
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 5.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 20.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 20.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(5.0, 3000.0, 3.0), 0.5);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(3.0, 3.0, 1.0), 1.0 / zeroToTen.getDistinctValuesCount());
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(10.0, 100.0, 357.0), 1.0 / zeroToTen.getDistinctValuesCount());
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(20.0, 30.0, 10.0), 0.0);
        TestStatisticRange.assertOverlap(zeroToTen, empty, 0.0);
        TestStatisticRange.assertOverlap(empty, zeroToTen, 0.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(10.0), empty, 0.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(10.0), TestStatisticRange.unboundedRange(20.0), 1.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(20.0), TestStatisticRange.unboundedRange(10.0), 0.5);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(0.1), TestStatisticRange.unboundedRange(1.0), 1.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(0.0), TestStatisticRange.unboundedRange(1.0), 0.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(0.0), TestStatisticRange.unboundedRange(0.0), 0.0);
    }

    @Test
    public void testIntersect() {
        StatisticRange zeroToTen = TestStatisticRange.range(0.0, 10.0, 10.0);
        StatisticRange fiveToFifteen = TestStatisticRange.range(5.0, 15.0, 60.0);
        Assertions.assertThat((Object)zeroToTen.intersect(fiveToFifteen)).isEqualTo((Object)TestStatisticRange.range(5.0, 10.0, 10.0));
    }

    @Test
    public void testAddAndSumDistinctValues() {
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndSumDistinctValues(TestStatisticRange.unboundedRange(Double.NaN))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndSumDistinctValues(TestStatisticRange.unboundedRange(1.0))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(1.0).addAndSumDistinctValues(TestStatisticRange.unboundedRange(Double.NaN))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(1.0).addAndSumDistinctValues(TestStatisticRange.unboundedRange(2.0))).isEqualTo((Object)TestStatisticRange.unboundedRange(3.0));
        Assertions.assertThat((Object)StatisticRange.empty().addAndSumDistinctValues(StatisticRange.empty())).isEqualTo((Object)StatisticRange.empty());
        Assertions.assertThat((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndSumDistinctValues(StatisticRange.empty())).isEqualTo((Object)TestStatisticRange.range(0.0, 1.0, 1.0));
        Assertions.assertThat((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndSumDistinctValues(TestStatisticRange.range(1.0, 2.0, 1.0))).isEqualTo((Object)TestStatisticRange.range(0.0, 2.0, 2.0));
    }

    @Test
    public void testAddAndMaxDistinctValues() {
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndMaxDistinctValues(TestStatisticRange.unboundedRange(Double.NaN))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndMaxDistinctValues(TestStatisticRange.unboundedRange(1.0))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(1.0).addAndMaxDistinctValues(TestStatisticRange.unboundedRange(Double.NaN))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(1.0).addAndMaxDistinctValues(TestStatisticRange.unboundedRange(2.0))).isEqualTo((Object)TestStatisticRange.unboundedRange(2.0));
        Assertions.assertThat((Object)StatisticRange.empty().addAndMaxDistinctValues(StatisticRange.empty())).isEqualTo((Object)StatisticRange.empty());
        Assertions.assertThat((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndMaxDistinctValues(StatisticRange.empty())).isEqualTo((Object)TestStatisticRange.range(0.0, 1.0, 1.0));
        Assertions.assertThat((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndMaxDistinctValues(TestStatisticRange.range(1.0, 2.0, 1.0))).isEqualTo((Object)TestStatisticRange.range(0.0, 2.0, 1.0));
    }

    @Test
    public void testAddAndCollapseDistinctValues() {
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndCollapseDistinctValues(TestStatisticRange.unboundedRange(Double.NaN))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndCollapseDistinctValues(TestStatisticRange.unboundedRange(1.0))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(1.0).addAndCollapseDistinctValues(TestStatisticRange.unboundedRange(Double.NaN))).isEqualTo((Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assertions.assertThat((Object)TestStatisticRange.unboundedRange(1.0).addAndCollapseDistinctValues(TestStatisticRange.unboundedRange(2.0))).isEqualTo((Object)TestStatisticRange.unboundedRange(2.0));
        Assertions.assertThat((Object)StatisticRange.empty().addAndCollapseDistinctValues(StatisticRange.empty())).isEqualTo((Object)StatisticRange.empty());
        Assertions.assertThat((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndCollapseDistinctValues(StatisticRange.empty())).isEqualTo((Object)TestStatisticRange.range(0.0, 1.0, 1.0));
        Assertions.assertThat((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndCollapseDistinctValues(TestStatisticRange.range(1.0, 2.0, 1.0))).isEqualTo((Object)TestStatisticRange.range(0.0, 2.0, 1.0));
        Assertions.assertThat((Object)TestStatisticRange.range(0.0, 3.0, 3.0).addAndCollapseDistinctValues(TestStatisticRange.range(2.0, 6.0, 4.0))).isEqualTo((Object)TestStatisticRange.range(0.0, 6.0, 6.0));
    }

    private static StatisticRange range(double low, double high, double distinctValues) {
        return new StatisticRange(low, high, distinctValues);
    }

    private static StatisticRange unboundedRange(double distinctValues) {
        return new StatisticRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, distinctValues);
    }

    private static void assertOverlap(StatisticRange a, StatisticRange b, double expected) {
        EstimateAssertion.assertEstimateEquals(a.overlapPercentWith(b), expected, "overlapPercentWith", new Object[0]);
    }
}

