/*
 * Decompiled with CFR 0.152.
 */
package io.trino.exchange;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.trino.server.SliceSerialization;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeSourceOutputSelector;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestExchangeSourceOutputSelector {
    private static final ExchangeId EXCHANGE_ID_1 = new ExchangeId("exchange_1");
    private static final ExchangeId EXCHANGE_ID_2 = new ExchangeId("exchange_2");
    private JsonCodec<ExchangeSourceOutputSelector> codec;

    @BeforeAll
    public void setup() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonSerializers((Map)ImmutableMap.of(Slice.class, (Object)new SliceSerialization.SliceSerializer()));
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Slice.class, (Object)new SliceSerialization.SliceDeserializer()));
        this.codec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(ExchangeSourceOutputSelector.class);
    }

    @AfterAll
    public void tearDown() {
        this.codec = null;
    }

    @Test
    public void testEmpty() {
        ExchangeSourceOutputSelector selector = this.serializeDeserialize(ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)EXCHANGE_ID_1, (Object)EXCHANGE_ID_2)).build());
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 100, 1)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.UNKNOWN);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_2, 21, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.UNKNOWN);
        Assertions.assertThat((boolean)selector.isFinal()).isFalse();
        selector = this.serializeDeserialize(ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)EXCHANGE_ID_1, (Object)EXCHANGE_ID_2)).setPartitionCount(EXCHANGE_ID_1, 0).setPartitionCount(EXCHANGE_ID_2, 0).setFinal().build());
        Assertions.assertThat((boolean)selector.isFinal()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> selector.getSelection(EXCHANGE_ID_1, 100, 1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("selection not found for exchangeId %s, taskPartitionId %s".formatted(EXCHANGE_ID_1, 100));
    }

    @Test
    public void testNonFinal() {
        ExchangeSourceOutputSelector selector = this.serializeDeserialize(ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)EXCHANGE_ID_1, (Object)EXCHANGE_ID_2)).include(EXCHANGE_ID_1, 21, 2).exclude(EXCHANGE_ID_2, 100).build());
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 100, 1)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.UNKNOWN);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_2, 100, 1)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_2, 100, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_2, 21, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.UNKNOWN);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 21, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.INCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 21, 1)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_2, 1, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.UNKNOWN);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_2, 200, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.UNKNOWN);
        Assertions.assertThat((boolean)selector.isFinal()).isFalse();
    }

    @Test
    public void testFinal() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)EXCHANGE_ID_1)).include(EXCHANGE_ID_1, 1, 2).setFinal().build()).isInstanceOf(IllegalStateException.class)).hasMessage("partition count is missing for exchange: %s".formatted(EXCHANGE_ID_1));
        ExchangeSourceOutputSelector selector = this.serializeDeserialize(ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)EXCHANGE_ID_1, (Object)EXCHANGE_ID_2)).include(EXCHANGE_ID_1, 0, 1).exclude(EXCHANGE_ID_1, 1).include(EXCHANGE_ID_1, 2, 0).exclude(EXCHANGE_ID_2, 0).setPartitionCount(EXCHANGE_ID_1, 3).setPartitionCount(EXCHANGE_ID_2, 1).setFinal().build());
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 0, 1)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.INCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 0, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 1, 0)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 1, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 2, 0)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.INCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_1, 2, 2)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_2, 0, 1)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        Assertions.assertThat((Comparable)selector.getSelection(EXCHANGE_ID_2, 0, 0)).isEqualTo((Object)ExchangeSourceOutputSelector.Selection.EXCLUDED);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> selector.getSelection(EXCHANGE_ID_1, 100, 1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("selection not found for exchangeId %s, taskPartitionId %s".formatted(EXCHANGE_ID_1, 100));
    }

    @Test
    public void testBasicTransitions() {
        ExchangeSourceOutputSelector.Builder builder = ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)EXCHANGE_ID_1, (Object)EXCHANGE_ID_2));
        ExchangeSourceOutputSelector partialVersion0 = builder.build();
        builder.include(EXCHANGE_ID_1, 0, 0);
        ExchangeSourceOutputSelector partialVersion1 = builder.build();
        builder.exclude(EXCHANGE_ID_1, 1);
        ExchangeSourceOutputSelector partialVersion2 = builder.build();
        builder.setPartitionCount(EXCHANGE_ID_1, 2);
        builder.setPartitionCount(EXCHANGE_ID_2, 0);
        builder.setFinal();
        ExchangeSourceOutputSelector finalVersion1 = builder.build();
        ExchangeSourceOutputSelector finalVersion2 = builder.build();
        partialVersion0.checkValidTransition(partialVersion1);
        partialVersion1.checkValidTransition(partialVersion2);
        partialVersion2.checkValidTransition(finalVersion1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> partialVersion1.checkValidTransition(partialVersion0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid transition to the same or an older version");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> partialVersion2.checkValidTransition(partialVersion0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid transition to the same or an older version");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> partialVersion2.checkValidTransition(partialVersion1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid transition to the same or an older version");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalVersion2.checkValidTransition(finalVersion1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid transition to the same or an older version");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalVersion2.checkValidTransition(partialVersion0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid transition to the same or an older version");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalVersion1.checkValidTransition(finalVersion2)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid transition from final selector");
    }

    @Test
    public void testIncompatibleTransitions() {
        ExchangeSourceOutputSelector.Builder builder = ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)EXCHANGE_ID_1));
        builder.include(EXCHANGE_ID_1, 0, 0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.include(EXCHANGE_ID_1, 0, 1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("decision for partition 0 is already made: 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.exclude(EXCHANGE_ID_1, 0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("decision for partition 0 is already made: 0");
    }

    @Test
    public void testToString() {
        ExchangeSourceOutputSelector selector = ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)EXCHANGE_ID_1, (Object)EXCHANGE_ID_2)).include(EXCHANGE_ID_1, 0, 1).exclude(EXCHANGE_ID_1, 1).include(EXCHANGE_ID_1, 2, 0).exclude(EXCHANGE_ID_2, 3).setPartitionCount(EXCHANGE_ID_2, 4).build();
        Assertions.assertThat((Object)selector).hasToString("ExchangeSourceOutputSelector[version=0, values={exchange_1=[0=1,1=E,2=0], exchange_2=[0=U,1=U,2=U,3=E]}, finalSelector=false]");
    }

    private ExchangeSourceOutputSelector serializeDeserialize(ExchangeSourceOutputSelector selector) {
        return (ExchangeSourceOutputSelector)this.codec.fromJson(this.codec.toJson((Object)selector));
    }
}

