/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.jmh.Benchmarks;
import io.trino.operator.PageAssertions;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.Ciphers;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1)
@Warmup(iterations=12, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.Throughput})
public class BenchmarkPagesSerde {
    @Benchmark
    public void serialize(BenchmarkData data, Blackhole blackhole) {
        Page[] pages = data.dataPages;
        PageSerializer serializer = data.serializer;
        for (int i = 0; i < pages.length; ++i) {
            blackhole.consume((Object)serializer.serialize(pages[i]));
        }
    }

    @Benchmark
    public void deserialize(BenchmarkData data, Blackhole blackhole) {
        Slice[] serializedPages = data.serializedPages;
        PageDeserializer deserializer = data.deserializer;
        for (int i = 0; i < serializedPages.length; ++i) {
            blackhole.consume((Object)deserializer.deserialize(serializedPages[i]));
        }
    }

    @Test
    public void testBenchmarkData() {
        BenchmarkData data = new BenchmarkData();
        data.compressed = true;
        data.initialize();
        Slice[] serializedPages = data.serializedPages;
        PageDeserializer deserializer = data.deserializer;
        for (int i = 0; i < serializedPages.length; ++i) {
            PageAssertions.assertPageEquals(BenchmarkData.TYPES, deserializer.deserialize(serializedPages[i]), data.dataPages[i]);
        }
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.compressed = true;
        data.initialize();
        System.out.println("Page Size Avg: " + Arrays.stream(data.dataPages).mapToLong(Page::getSizeInBytes).average().getAsDouble());
        System.out.println("Page Size Min: " + Arrays.stream(data.dataPages).mapToLong(Page::getSizeInBytes).min().getAsLong());
        System.out.println("Page Size Max: " + Arrays.stream(data.dataPages).mapToLong(Page::getSizeInBytes).max().getAsLong());
        System.out.println("Page Size Sum: " + Arrays.stream(data.dataPages).mapToLong(Page::getSizeInBytes).sum());
        System.out.println("Page count: " + data.dataPages.length);
        System.out.println("Compressed: " + Arrays.stream(data.serializedPages).filter(PagesSerdeUtil::isSerializedPageCompressed).count());
        Benchmarks.benchmark(BenchmarkPagesSerde.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgs(new String[]{"-Xms4g", "-Xmx4g"})).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int ROW_COUNT = 15000;
        private static final List<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR);
        @Param(value={"true", "false"})
        private boolean encrypted;
        @Param(value={"true", "false"})
        private boolean compressed;
        @Param(value={"1000"})
        private int randomSeed = 1000;
        private PageSerializer serializer;
        private PageDeserializer deserializer;
        private Page[] dataPages;
        private Slice[] serializedPages;

        @Setup
        public void initialize() {
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new TestingBlockEncodingSerde(), this.compressed);
            Optional<Object> encryptionKey = this.encrypted ? Optional.of(Ciphers.createRandomAesEncryptionKey()) : Optional.empty();
            this.serializer = serdeFactory.createSerializer(encryptionKey);
            this.deserializer = serdeFactory.createDeserializer(encryptionKey);
            this.dataPages = this.createPages();
            this.serializedPages = this.createSerializedPages();
        }

        public Page[] getDataPages() {
            return this.dataPages;
        }

        private Slice[] createSerializedPages() {
            Slice[] result = new Slice[this.dataPages.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.serializer.serialize(this.dataPages[i]);
            }
            return result;
        }

        private Page[] createPages() {
            Random random = new Random(this.randomSeed);
            ArrayList<Page> pages = new ArrayList<Page>();
            int remainingRows = 15000;
            PageBuilder pageBuilder = new PageBuilder(TYPES);
            while (remainingRows > 0) {
                int rows = 100 + random.nextInt(900);
                List<Object>[] testRows = this.generateTestRows(random, TYPES, rows);
                remainingRows -= rows;
                for (int i = 0; i < testRows.length; ++i) {
                    this.writeRow(testRows[i], pageBuilder.getBlockBuilder(0));
                }
                pageBuilder.declarePositions(rows);
                pages.add(pageBuilder.build());
                pageBuilder.reset();
            }
            return (Page[])pages.toArray(Page[]::new);
        }

        private void writeRow(List<Object> testRow, BlockBuilder blockBuilder) {
            for (Object fieldValue : testRow) {
                if (fieldValue == null) {
                    blockBuilder.appendNull();
                    continue;
                }
                if (fieldValue instanceof String) {
                    VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)fieldValue)));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }

        private List<Object>[] generateTestRows(Random random, List<Type> fieldTypes, int numRows) {
            List[] testRows = new List[numRows];
            for (int i = 0; i < numRows; ++i) {
                ArrayList testRow = new ArrayList(fieldTypes.size());
                for (int j = 0; j < fieldTypes.size(); ++j) {
                    if (fieldTypes.get(j) == VarcharType.VARCHAR) {
                        int mode = random.nextInt(4);
                        if (mode == 0) {
                            testRow.add(null);
                            continue;
                        }
                        if (i > 0 && mode == 1) {
                            testRow.add(testRows[i - 1].get(j));
                            continue;
                        }
                        byte[] data = new byte[random.nextInt(256)];
                        random.nextBytes(data);
                        testRow.add(new String(data, StandardCharsets.ISO_8859_1));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                testRows[i] = testRow;
            }
            return testRows;
        }
    }
}

