/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import com.google.common.collect.ImmutableSet;
import io.trino.execution.executor.scheduler.PriorityQueue;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPriorityQueue {
    @Test
    public void testEmpty() {
        PriorityQueue queue = new PriorityQueue();
        Assertions.assertThat((String)((String)queue.poll())).isNull();
        Assertions.assertThat((boolean)queue.isEmpty()).isTrue();
    }

    @Test
    public void testNotEmpty() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"hello", 1L);
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
    }

    @Test
    public void testDuplicate() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"hello", 1L);
        Assertions.assertThatThrownBy(() -> queue.add((Object)"hello", 2L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testOrder() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"jumps", 5L);
        queue.add((Object)"fox", 4L);
        queue.add((Object)"over", 6L);
        queue.add((Object)"brown", 3L);
        queue.add((Object)"dog", 8L);
        queue.add((Object)"the", 1L);
        queue.add((Object)"lazy", 7L);
        queue.add((Object)"quick", 2L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("the");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("quick");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("brown");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("fox");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("jumps");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("over");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("lazy");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("dog");
        Assertions.assertThat((String)((String)queue.poll())).isNull();
    }

    @Test
    public void testInterleaved() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"jumps", 5L);
        queue.add((Object)"over", 6L);
        queue.add((Object)"fox", 4L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("fox");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("jumps");
        queue.add((Object)"brown", 3L);
        queue.add((Object)"dog", 8L);
        queue.add((Object)"the", 1L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("the");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("brown");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("over");
        queue.add((Object)"lazy", 7L);
        queue.add((Object)"quick", 2L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("quick");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("lazy");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("dog");
        Assertions.assertThat((String)((String)queue.poll())).isNull();
    }

    @Test
    public void testRemove() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"fox", 4L);
        queue.add((Object)"brown", 3L);
        queue.add((Object)"the", 1L);
        queue.add((Object)"quick", 2L);
        queue.remove((Object)"brown");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("the");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("quick");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("fox");
        Assertions.assertThat((String)((String)queue.poll())).isNull();
    }

    @Test
    public void testRemoveMissing() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"the", 1L);
        queue.add((Object)"quick", 2L);
        queue.add((Object)"brown", 3L);
        Assertions.assertThatThrownBy(() -> queue.remove((Object)"fox")).isInstanceOf(IllegalArgumentException.class);
        queue.removeIfPresent((Object)"fox");
    }

    @Test
    public void testContains() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"the", 1L);
        queue.add((Object)"quick", 2L);
        queue.add((Object)"brown", 3L);
        Assertions.assertThat((boolean)queue.contains((Object)"quick")).isTrue();
        Assertions.assertThat((boolean)queue.contains((Object)"fox")).isFalse();
    }

    @Test
    public void testRecycle() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"hello", 1L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("hello");
        queue.add((Object)"hello", 2L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("hello");
    }

    @Test
    public void testValues() {
        PriorityQueue queue = new PriorityQueue();
        Assertions.assertThat((Collection)queue.values()).isEmpty();
        queue.add((Object)"hello", 1L);
        queue.add((Object)"world", 2L);
        Assertions.assertThat((Collection)queue.values()).isEqualTo((Object)ImmutableSet.of((Object)"hello", (Object)"world"));
    }

    @Test
    public void testNextPriority() {
        PriorityQueue queue = new PriorityQueue();
        Assertions.assertThatThrownBy(() -> ((PriorityQueue)queue).nextPriority()).isInstanceOf(IllegalStateException.class);
        queue.add((Object)"hello", 10L);
        queue.add((Object)"world", 20L);
        Assertions.assertThat((long)queue.nextPriority()).isEqualTo(10L);
        queue.poll();
        Assertions.assertThat((long)queue.nextPriority()).isEqualTo(20L);
        queue.poll();
        Assertions.assertThatThrownBy(() -> ((PriorityQueue)queue).nextPriority()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testSamePriority() {
        PriorityQueue queue = new PriorityQueue();
        queue.add((Object)"hello", 1L);
        queue.add((Object)"world", 1L);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("hello");
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo("world");
    }
}

