/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.GroupByHashYieldAssertion;
import io.trino.operator.MarkDistinctOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestMarkDistinctOperator {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    private final TypeOperators typeOperators = new TypeOperators();
    private final JoinCompiler joinCompiler = new JoinCompiler(this.typeOperators);

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testMarkDistinct() {
        this.testMarkDistinct(true, this.newDriverContext());
        this.testMarkDistinct(false, this.newDriverContext());
    }

    private void testMarkDistinct(boolean hashEnabled, DriverContext driverContext) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(100, 0).addSequencePage(100, 0).build();
        MarkDistinctOperator.MarkDistinctOperatorFactory operatorFactory = new MarkDistinctOperator.MarkDistinctOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), (Collection)ImmutableList.of((Object)0), rowPagesBuilder.getHashChannel(), this.joinCompiler);
        MaterializedResult.Builder expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BooleanType.BOOLEAN});
        for (long i = 0L; i < 100L; ++i) {
            expected.row(new Object[]{i, true});
            expected.row(new Object[]{i, false});
        }
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, driverContext, input, expected.build(), hashEnabled, Optional.of(1));
    }

    @Test
    public void testRleDistinctMask() {
        this.testRleDistinctMask(true, this.newDriverContext());
        this.testRleDistinctMask(false, this.newDriverContext());
    }

    private void testRleDistinctMask(boolean hashEnabled, DriverContext driverContext) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> inputs = rowPagesBuilder.addSequencePage(100, 0).addSequencePage(100, 50).addSequencePage(1, 200).addSequencePage(1, 100).build();
        Page firstInput = inputs.get(0);
        Page secondInput = inputs.get(1);
        Page singleDistinctPage = inputs.get(2);
        Page singleNotDistinctPage = inputs.get(3);
        MarkDistinctOperator.MarkDistinctOperatorFactory operatorFactory = new MarkDistinctOperator.MarkDistinctOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), (Collection)ImmutableList.of((Object)0), rowPagesBuilder.getHashChannel(), this.joinCompiler);
        int maskChannel = firstInput.getChannelCount();
        try (Operator operator = operatorFactory.createOperator(driverContext);){
            int position;
            operator.addInput(firstInput);
            Block allDistinctOutput = operator.getOutput().getBlock(maskChannel);
            operator.addInput(firstInput);
            Block noDistinctOutput = operator.getOutput().getBlock(maskChannel);
            io.airlift.testing.Assertions.assertInstanceOf((Object)allDistinctOutput, RunLengthEncodedBlock.class);
            Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(allDistinctOutput, 0)).isTrue();
            io.airlift.testing.Assertions.assertInstanceOf((Object)noDistinctOutput, RunLengthEncodedBlock.class);
            Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(noDistinctOutput, 0)).isFalse();
            operator.addInput(secondInput);
            Block halfDistinctOutput = operator.getOutput().getBlock(maskChannel);
            for (position = 0; position < 50; ++position) {
                Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(halfDistinctOutput, position)).isFalse();
            }
            for (position = 50; position < 100; ++position) {
                Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(halfDistinctOutput, position)).isTrue();
            }
            operator.addInput(singleDistinctPage);
            Block singleDistinctBlock = operator.getOutput().getBlock(maskChannel);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)(singleDistinctBlock instanceof RunLengthEncodedBlock)).describedAs("single position inputs should not be RLE", new Object[0])).isFalse();
            Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(singleDistinctBlock, 0)).isTrue();
            operator.addInput(singleNotDistinctPage);
            Block singleNotDistinctBlock = operator.getOutput().getBlock(maskChannel);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)(singleNotDistinctBlock instanceof RunLengthEncodedBlock)).describedAs("single position inputs should not be RLE", new Object[0])).isFalse();
            Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(singleNotDistinctBlock, 0)).isFalse();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testMemoryReservationYield() {
        this.testMemoryReservationYield((Type)BigintType.BIGINT);
        this.testMemoryReservationYield((Type)VarcharType.VARCHAR);
    }

    private void testMemoryReservationYield(Type type) {
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys(type, 6000, 600);
        MarkDistinctOperator.MarkDistinctOperatorFactory operatorFactory = new MarkDistinctOperator.MarkDistinctOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)type), (Collection)ImmutableList.of((Object)0), Optional.of(1), this.joinCompiler);
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, type, (OperatorFactory)operatorFactory, operator -> ((MarkDistinctOperator)operator).getCapacity(), 450000L);
        io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(5));
        io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x1400000L));
        int count = 0;
        for (Page page : result.getOutput()) {
            Assertions.assertThat((int)page.getChannelCount()).isEqualTo(3);
            for (int i = 0; i < page.getPositionCount(); ++i) {
                Assertions.assertThat((byte)page.getBlock(2).getByte(i, 0)).isEqualTo((byte)1);
                ++count;
            }
        }
        Assertions.assertThat((int)count).isEqualTo(3600000);
    }

    private DriverContext newDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }
}

