/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractTestApproximateCountDistinct {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    protected abstract Type getValueType();

    protected abstract Object randomValue();

    protected int getUniqueValuesCount() {
        return 20000;
    }

    @Test
    public void testNoPositions() {
        this.assertCount((List<?>)ImmutableList.of(), 0.023, 0L);
        this.assertCount((List<?>)ImmutableList.of(), 0.0115, 0L);
    }

    @Test
    public void testSinglePosition() {
        this.assertCount((List<?>)ImmutableList.of((Object)this.randomValue()), 0.023, 1L);
        this.assertCount((List<?>)ImmutableList.of((Object)this.randomValue()), 0.0115, 1L);
    }

    @Test
    public void testAllPositionsNull() {
        this.assertCount(Collections.nCopies(100, null), 0.023, 0L);
        this.assertCount(Collections.nCopies(100, null), 0.0115, 0L);
    }

    @Test
    public void testMixedNullsAndNonNulls() {
        this.testMixedNullsAndNonNulls(0.023);
        this.testMixedNullsAndNonNulls(0.0115);
    }

    private void testMixedNullsAndNonNulls(double maxStandardError) {
        int uniques = this.getUniqueValuesCount();
        List<Object> baseline = this.createRandomSample(uniques, (int)((double)uniques * 1.5));
        Iterator<Object> iterator = baseline.iterator();
        ArrayList<Object> mixed = new ArrayList<Object>();
        while (iterator.hasNext()) {
            mixed.add(ThreadLocalRandom.current().nextBoolean() ? null : iterator.next());
        }
        this.assertCount(mixed, maxStandardError, this.estimateGroupByCount(baseline, maxStandardError));
    }

    @Test
    public void testMultiplePositions() {
        this.testMultiplePositions(0.023);
        this.testMultiplePositions(0.0115);
    }

    private void testMultiplePositions(double maxStandardError) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < 500; ++i) {
            int uniques = ThreadLocalRandom.current().nextInt(this.getUniqueValuesCount()) + 1;
            List<Object> values = this.createRandomSample(uniques, (int)((double)uniques * 1.5));
            long actual = this.estimateGroupByCount(values, maxStandardError);
            double error = (double)(actual - (long)uniques) * 1.0 / (double)uniques;
            stats.addValue(error);
        }
        io.airlift.testing.Assertions.assertLessThan((Comparable)Double.valueOf(stats.getMean()), (Comparable)Double.valueOf(0.01));
        io.airlift.testing.Assertions.assertLessThan((Comparable)Double.valueOf(stats.getStandardDeviation()), (Comparable)Double.valueOf(0.01 + maxStandardError));
    }

    @Test
    public void testMultiplePositionsPartial() {
        this.testMultiplePositionsPartial(0.023);
        this.testMultiplePositionsPartial(0.0115);
    }

    private void testMultiplePositionsPartial(double maxStandardError) {
        for (int i = 0; i < 100; ++i) {
            int uniques = ThreadLocalRandom.current().nextInt(this.getUniqueValuesCount()) + 1;
            List<Object> values = this.createRandomSample(uniques, (int)((double)uniques * 1.5));
            Assertions.assertThat((long)this.estimateCountPartial(values, maxStandardError)).isEqualTo(this.estimateGroupByCount(values, maxStandardError));
        }
    }

    protected void assertCount(List<?> values, double maxStandardError, long expectedCount) {
        if (!values.isEmpty()) {
            Assertions.assertThat((long)this.estimateGroupByCount(values, maxStandardError)).isEqualTo(expectedCount);
        }
        Assertions.assertThat((long)this.estimateCount(values, maxStandardError)).isEqualTo(expectedCount);
        Assertions.assertThat((long)this.estimateCountPartial(values, maxStandardError)).isEqualTo(expectedCount);
    }

    private long estimateGroupByCount(List<?> values, double maxStandardError) {
        Object result = AggregationTestUtils.groupedAggregation(this.getAggregationFunction(), this.createPage(values, maxStandardError));
        return (Long)result;
    }

    private long estimateCount(List<?> values, double maxStandardError) {
        Object result = AggregationTestUtils.aggregation(this.getAggregationFunction(), this.createPage(values, maxStandardError));
        return (Long)result;
    }

    private long estimateCountPartial(List<?> values, double maxStandardError) {
        Object result = AggregationTestUtils.partialAggregation(this.getAggregationFunction(), this.createPage(values, maxStandardError));
        return (Long)result;
    }

    private TestingAggregationFunction getAggregationFunction() {
        return FUNCTION_RESOLUTION.getAggregateFunction("approx_distinct", TypeSignatureProvider.fromTypes((Type[])new Type[]{this.getValueType(), DoubleType.DOUBLE}));
    }

    private Page createPage(List<?> values, double maxStandardError) {
        if (values.isEmpty()) {
            return new Page(0);
        }
        return new Page(values.size(), new Block[]{AbstractTestApproximateCountDistinct.createBlock(this.getValueType(), values), AbstractTestApproximateCountDistinct.createBlock((Type)DoubleType.DOUBLE, ImmutableList.copyOf(Collections.nCopies(values.size(), maxStandardError)))});
    }

    private static Block createBlock(Type type, List<?> values) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, values.size());
        for (Object value : values) {
            Class javaType = type.getJavaType();
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            if (javaType == Boolean.TYPE) {
                type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
                continue;
            }
            if (javaType == Long.TYPE) {
                type.writeLong(blockBuilder, ((Long)value).longValue());
                continue;
            }
            if (javaType == Double.TYPE) {
                type.writeDouble(blockBuilder, ((Double)value).doubleValue());
                continue;
            }
            if (javaType == Slice.class) {
                Slice slice = (Slice)value;
                type.writeSlice(blockBuilder, slice, 0, slice.length());
                continue;
            }
            type.writeObject(blockBuilder, value);
        }
        return blockBuilder.build();
    }

    private List<Object> createRandomSample(int uniques, int total) {
        Preconditions.checkArgument((uniques <= total ? 1 : 0) != 0, (String)"uniques (%s) must be <= total (%s)", (int)uniques, (int)total);
        ArrayList<Object> result = new ArrayList<Object>(total);
        result.addAll(this.makeRandomSet(uniques));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (result.size() < total) {
            int index = ((Random)random).nextInt(result.size());
            result.add(result.get(index));
        }
        return result;
    }

    private Set<Object> makeRandomSet(int count) {
        HashSet<Object> result = new HashSet<Object>();
        while (result.size() < count) {
            result.add(this.randomValue());
        }
        return result;
    }
}

