/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.RegexLibrary;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Collections;
import java.util.Objects;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public abstract class AbstractTestRegexpFunctions {
    private final RegexLibrary regexLibrary;
    private QueryAssertions assertions;

    protected AbstractTestRegexpFunctions(RegexLibrary regexLibrary) {
        this.regexLibrary = Objects.requireNonNull(regexLibrary, "regexLibrary is null");
    }

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions((QueryRunner)LocalQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).withFeaturesConfig(new FeaturesConfig().setRegexLibrary(this.regexLibrary)).build());
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(AbstractTestRegexpFunctions.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @ScalarFunction(deterministic=false)
    @SqlType(value="varchar")
    public static Slice invalidUtf8() {
        return Slices.wrappedBuffer((byte[])new byte[]{65, 65, -19, -96, -128, 65, 65, 65, 65, -19, -65, -65, 65, 65, 65});
    }

    @Test
    public void testRegexpLike() {
        this.assertions.function("regexp_like", "invalid_utf8()", "invalid_utf8()").evaluate();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'Stephen'", "'Ste(v|ph)en'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'Stevens'", "'Ste(v|ph)en'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'Stephen'", "'^Ste(v|ph)en$'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'Stevens'", "'^Ste(v|ph)en$'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'hello world'", "'[a-z]'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'hello\nworld'", "'.*hello\nworld.*'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'Hello'", "'^[a-z]+$'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'Hello'", "'^(?i)[a-z]+$'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'Hello'", "'^[a-zA-Z]+$'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'test'", "'test\\b'")))).isEqualTo(true);
    }

    @Test
    public void testRegexCharLike() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'ala'", "CHAR 'ala  '")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", "'ala  '", "CHAR 'ala  '")))).isEqualTo(true);
    }

    @Test
    public void testRegexpReplace() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'abc\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765'", "''", "'Y'")))).hasType((Type)VarcharType.createVarcharType((int)97)).isEqualTo("YaYbYcY\u6709Y\u670bY$Y%YXY\u81eaY9Y\u8fdcY\u65b9Y\u6765Y");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'a\u6709\u670b\ud83d\udcb0'", "'.'", "'Y'")))).hasType((Type)VarcharType.createVarcharType((int)14)).isEqualTo("YYYY");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'a\u6709\u670b\ud83d\udcb0'", "'.'", "'1$02'")))).hasType((Type)VarcharType.createVarcharType((int)44)).isEqualTo("1a21\u670921\u670b21\ud83d\udcb02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "''", "''", "'Y'")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("Y");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'fun stuff.'", "'[a-z]'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo(" .");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'fun stuff.'", "'[a-z]'", "'*'")))).hasType((Type)VarcharType.createVarcharType((int)65)).isEqualTo("*** *****.");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'call 555.123.4444 now'", "'(\\d{3})\\.(\\d{3}).(\\d{4})'")))).hasType((Type)VarcharType.createVarcharType((int)21)).isEqualTo("call  now");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'call 555.123.4444 now'", "'(\\d{3})\\.(\\d{3}).(\\d{4})'", "'($1) $2-$3'")))).hasType((Type)VarcharType.createVarcharType((int)2331)).isEqualTo("call (555) 123-4444 now");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'xxx xxx xxx'", "'x'", "'x'")))).hasType((Type)VarcharType.createVarcharType((int)71)).isEqualTo("xxx xxx xxx");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'xxx xxx xxx'", "'x'", "'\\x'")))).hasType((Type)VarcharType.createVarcharType((int)143)).isEqualTo("xxx xxx xxx");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'xxx'", "''", "'y'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("yxyxyxy");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_replace", "'xxx'", "'x'", "'\\'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'xxx xxx xxx'", "'x'", "'$0'")))).hasType((Type)VarcharType.createVarcharType((int)143)).isEqualTo("xxx xxx xxx");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'xxx'", "'(x)'", "'$01'")))).hasType((Type)VarcharType.createVarcharType((int)19)).isEqualTo("xxx");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'xxx'", "'x'", "'$05'")))).hasType((Type)VarcharType.createVarcharType((int)19)).isEqualTo("x5x5x5");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'123456789'", "'(1)(2)(3)(4)(5)(6)(7)(8)(9)'", "'$10'")))).hasType((Type)VarcharType.createVarcharType((int)139)).isEqualTo("10");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'1234567890'", "'(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)'", "'$10'")))).hasType((Type)VarcharType.createVarcharType((int)175)).isEqualTo("0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'1234567890'", "'(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)'", "'$11'")))).hasType((Type)VarcharType.createVarcharType((int)175)).isEqualTo("11");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'1234567890'", "'(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)'", "'$1a'")))).hasType((Type)VarcharType.createVarcharType((int)175)).isEqualTo("1a");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_replace", "'xxx'", "'x'", "'$1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_replace", "'xxx'", "'x'", "'$a'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_replace", "'xxx'", "'x'", "'$'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'wxyz'", "'(?<xyz>[xyz])'", "'${xyz}${xyz}'")))).hasType((Type)VarcharType.createVarcharType((int)124)).isEqualTo("wxxyyzz");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'wxyz'", "'(?<w>w)|(?<xyz>[xyz])'", "'[${w}](${xyz})'")))).hasType((Type)VarcharType.createVarcharType((int)144)).isEqualTo("[w]()[](x)[](y)[](z)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'xyz'", "'(?<xyz>[xyz])+'", "'${xyz}'")))).hasType((Type)VarcharType.createVarcharType((int)39)).isEqualTo("z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "'xyz'", "'(?<xyz>[xyz]+)'", "'${xyz}'")))).hasType((Type)VarcharType.createVarcharType((int)39)).isEqualTo("xyz");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_replace", "'xxx'", "'(?<name>x)'", "'${}'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_replace", "'xxx'", "'(?<name>x)'", "'${0}'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_replace", "'xxx'", "'(?<name>x)'", "'${nam}'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", "VARCHAR 'x'", "'.*'", "'xxxxx'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("xxxxxxxxxx");
    }

    @Test
    public void testRegexpReplaceLambda() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'Y')").binding("a", "'abc\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765'").binding("b", "''")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("YaYbYcY\u6709Y\u670bY$Y%YXY\u81eaY9Y\u8fdcY\u65b9Y\u6765Y");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'Y')").binding("a", "'a\u6709\u670b\ud83d\udcb0'").binding("b", "'.'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("YYYY");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> '1' || x[1] || '2')").binding("a", "'a\u6709\u670b\ud83d\udcb0'").binding("b", "'(.)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("1a21\u670921\u670b21\ud83d\udcb02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'Y')").binding("a", "''").binding("b", "''")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("Y");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'x'").binding("b", "'(x)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("X");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'xxx xxx xxx'").binding("b", "'(x)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("XXX XXX XXX");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1])").binding("a", "'new'").binding("b", "'(\\w)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("new");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1] || upper(x[1]))").binding("a", "'new'").binding("b", "'(\\w)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("nNeEwW");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]) || lower(x[2]))").binding("a", "'new york'").binding("b", "'(\\w)(\\w*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("New York");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[2]) || lower(x[3]))").binding("a", "'new york'").binding("b", "'((\\w)(\\w*))'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("New York");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'new york'").binding("b", "'(n\\w*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("NEW york");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'new york'").binding("b", "'(y\\w*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("new YORK");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'new york city'").binding("b", "'(yo\\w*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("new YORK city");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'm')").binding("a", "'abc abc'").binding("b", "'(abc)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("m m");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1])").binding("a", "'123 456'").binding("b", "'([0-9]*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("123 456");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[2] || x[3])").binding("a", "'123 456'").binding("b", "'(([0-9]*) ([0-9]*))'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("123456");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'm')").binding("a", "'abbabba'").binding("b", "'(abba)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("mbba");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'm' || x[1])").binding("a", "'abbabba'").binding("b", "'(abba)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("mabbabba");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> CASE WHEN x[1] IS NULL THEN 'foo' ELSE 'bar' END)").binding("a", "'abcde'").binding("b", "'ab(c)?de'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("bar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'm')").binding("a", "'abc'").binding("b", "'(.)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("mmm");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'm')").binding("a", "'abc'").binding("b", "'.'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("mmm");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'm')").binding("a", "'abbabba'").binding("b", "'abba'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("mbba");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'm')").binding("a", "'abc abc'").binding("b", "'abc'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("m m");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'OK')").binding("a", "'abc'").binding("b", "''")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("OKaOKbOKcOK");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1])").binding("a", "'abc'").binding("b", "'()'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'OK')").binding("a", "'abc'").binding("b", "'()'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("OKaOKbOKcOK");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'new'").binding("b", "'(\\w*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("NEW");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1] || upper(x[1]))").binding("a", "'new'").binding("b", "'(\\w*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("newNEW");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> CAST(length(x[1]) AS VARCHAR))").binding("a", "'new'").binding("b", "'(\\w*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("30");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> '<' || x[1] || '>')").binding("a", "'new york'").binding("b", "'(\\w*)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("<new><> <york><>");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1] )").binding("a", "'aaa'").binding("b", "'(b)?'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1])").binding("a", "'abde'").binding("b", "'ab(c)?de'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'OK')").binding("a", "'abde'").binding("b", "'ab(c)?de'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("OK");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1] || 'OK')").binding("a", "'abde'").binding("b", "'ab(c)?de'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'OK' || x[1])").binding("a", "'abde'").binding("b", "'ab(c)?de'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> CASE WHEN x[1] IS NULL THEN 'foo' ELSE 'bar' END)").binding("a", "'abde'").binding("b", "'ab(c)?de'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)").binding("a", "'ab'").binding("b", "'(a)?(b)?'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> CAST(NULL AS VARCHAR))").binding("a", "'aaa'").binding("b", "'(a)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NULL) OR (x[1] IS NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)").binding("a", "'ab'").binding("b", "'(a)?(b)?'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NULL) OR (x[1] IS NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)").binding("a", "'abacdb'").binding("b", "'(a)?(b)?'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'new york'").binding("b", "'(a)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("new york");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "''").binding("b", "'(a)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "null").binding("b", "'(a)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'new'").binding("b", "null")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> x[1])").binding("a", "'abde'").binding("b", "'(c)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("abde");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("regexp_replace(a, b, x -> 'm')").binding("a", "'abde'").binding("b", "'(c)'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("abde");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("regexp_replace(a, b, x -> upper(x[2]))").binding("a", "'new'").binding("b", "'(\\w)'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("regexp_replace(a, b, x -> upper(x[0]))").binding("a", "'new'").binding("b", "'(\\w)'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("regexp_replace(a, b, x -> x[1])").binding("a", "'abc'").binding("b", "''").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("regexp_replace(a, b, x -> upper(x[1]))").binding("a", "'x'").binding("b", "'x'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("regexp_replace(a, b, x -> 'm' || x[1])").binding("a", "'abbabba'").binding("b", "'abba'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testRegexpExtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract", "'Hello world bye'", "'\\b[a-z]([a-z]*)'")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo("world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract", "'Hello world bye'", "'\\b[a-z]([a-z]*)'", "1")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo("orld");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract", "'rat cat\nbat dog'", "'ra(.)|blah(.)(.)'", "2")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract", "'12345'", "'x'")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo(null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract", "'Baby X'", "'by ([A-Z].*)\\b[a-z]'")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo(null);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_extract", "'Hello world bye'", "'\\b[a-z]([a-z]*)'", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_extract", "'Hello world bye'", "'\\b[a-z]([a-z]*)'", "2")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testRegexpExtractAll() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract_all", "'abc\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765\ud83d\udcb0'", "''")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)14))).isEqualTo(ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object[])new String[]{"", "", ""}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract_all", "'a\u6709\u670b\ud83d\udcb0'", "'.'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))).isEqualTo(ImmutableList.of((Object)"a", (Object)"\u6709", (Object)"\u670b", (Object)"\ud83d\udcb0"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract_all", "''", "''")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))).isEqualTo(ImmutableList.of((Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract_all", "'rat cat\nbat dog'", "'.at'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)15))).isEqualTo(ImmutableList.of((Object)"rat", (Object)"cat", (Object)"bat"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract_all", "'rat cat\nbat dog'", "'(.)at'", "1")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)15))).isEqualTo(ImmutableList.of((Object)"r", (Object)"c", (Object)"b"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract_all", "'rat cat\nbat dog'", "'ra(.)|blah(.)(.)'", "2")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)15))).isEqualTo(Collections.singletonList(null));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_extract_all", "'hello'", "'(.)'", "2")::evaluate).hasMessage("Pattern has 1 groups. Cannot access group 2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract_all", "'12345'", "''")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)""));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_extract_all", "'12345'", "'('")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testRegexpSplit() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'abc\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765\ud83d\udcb0'", "''")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)14))).isEqualTo(ImmutableList.of((Object)"", (Object)"a", (Object)"b", (Object)"c", (Object)"\u6709", (Object)"\u670b", (Object)"$", (Object)"%", (Object)"X", (Object)"\u81ea", (Object)"9", (Object)"\u8fdc", (Object[])new String[]{"\u65b9", "\u6765", "\ud83d\udcb0", ""}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'a\u6709\u670b\ud83d\udcb0'", "'.'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))).isEqualTo(ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)"", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "''", "''")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))).isEqualTo(ImmutableList.of((Object)"", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'abc'", "'a'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"", (Object)"bc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'a.b:c;d'", "'[\\.:;]'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'a.b:c;d'", "'\\.'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b:c;d"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'a.b:c;d'", "':'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"a.b", (Object)"c;d"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'a,b,c'", "','")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'a1b2c3d'", "'\\d'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'a1b2346c3d'", "'\\d+'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)10))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'abcd'", "'x'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))).isEqualTo(ImmutableList.of((Object)"abcd"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'abcd'", "''")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))).isEqualTo(ImmutableList.of((Object)"", (Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "''", "'x'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))).isEqualTo(ImmutableList.of((Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "'a,b,c,d'", "','")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "',,a,,,b,c,d,,'", "','")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)13))).isEqualTo(ImmutableList.of((Object)"", (Object)"", (Object)"a", (Object)"", (Object)"", (Object)"b", (Object)"c", (Object)"d", (Object)"", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_split", "',,,'", "','")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)""));
    }

    @Test
    public void testRegexpCount() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'a.b:c;d'", "'[\\.:;]'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('a.b:c;d', '[\\.:;]')")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'a.b:c;d'", "'\\.'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('a.b:c;d', '\\.')")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'a.b:c;d'", "':'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('a.b:c;d', ':')")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'a,b,c'", "','")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('a,b,c', ',')")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'a1b2c3d'", "'\\d'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('a1b2c3d', '\\d')")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'a1b2346c3d'", "'\\d+'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('a1b2346c3d', '\\d+')")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'abcd'", "'x'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('abcd', 'x')")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'Hello world bye'", "'\\b[a-z]([a-z]*)'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('Hello world bye', '\\b[a-z]([a-z]*)')")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'rat cat\nbat dog'", "'ra(.)|blah(.)(.)'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('rat cat\nbat dog', 'ra(.)|blah(.)(.)')")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'Baby X'", "'by ([A-Z].*)\\b[a-z]'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('Baby X', 'by ([A-Z].*)\\b[a-z]')")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'rat cat bat dog'", "'.at'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('rat cat bat dog', '.at')")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "''", "'x'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('', 'x')")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "''", "''")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('', '')")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'\u541b\u5b50\u77dc\u800c\u4e0d\u4e89\uff0c\u515a\u800c\u4e0d\u7fa4'", "'\u4e0d'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('\u541b\u5b50\u77dc\u800c\u4e0d\u4e89\uff0c\u515a\u800c\u4e0d\u7fa4', '\u4e0d')")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'abcd'", "''")))).isEqualTo(5L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('abcd', '')")))).isEqualTo(5L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_count", "'1a 2b 14m'", "'\\s*[a-z]+\\s*'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "regexp_extract_all('1a 2b 14m', '\\s*[a-z]+\\s*')")))).isEqualTo(3L);
    }

    @Test
    public void testRegexpPosition() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a.b:c;d'", "'[\\.:;]'")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a.b:c;d'", "'\\.'")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a.b:c;d'", "':'")))).isEqualTo(4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a,b,c'", "','")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "'\\d'")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a,b,c'", "','", "3")))).isEqualTo(4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "'\\d'", "5")))).isEqualTo(6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d4e'", "'\\d'", "4", "2")))).isEqualTo(6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "'\\d'", "4", "3")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "''")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "''", "2")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "''", "2", "2")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "''", "2", "6")))).isEqualTo(7);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "''", "2", "7")))).isEqualTo(8);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "''", "2", "8")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'\u884c\u6210\u4e8e\u601dstr\u800c\u6bc1123\u4e8e\u968f'", "'\u4e8e'", "3", "2")))).isEqualTo(13);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'\u884c\u6210\u4e8e\u601dstr\u800c\u6bc1123\u4e8e\u968f'", "''", "3", "2")))).isEqualTo(4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'\u884c\u6210\u4e8e\u601dstr\u800c\u6bc1123\u4e8e\u968f'", "''", "3", "1")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "''", "', '")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "''", "', '", "4")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "''", "', '", "4", "2")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a,b,c'", "','", "2")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a1b2c3d'", "'\\d'", "4")))).isEqualTo(4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765'", "'\\d'", "7")))).isEqualTo(7);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765'", "'\\d'", "10", "1")))).isEqualTo(10);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765'", "'\\d'", "10", "2")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a,b,c'", "', '", "1000")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'a,b,c'", "', '", "8")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765'", "'\u6765'", "999")))).isEqualTo(-1);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_position", "'\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765'", "'\u6765'", "-1", "0")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_position", "'\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765'", "'\u6765'", "1", "0")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("regexp_position", "'\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765'", "'\u6765'", "1", "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'9102, say good bye'", "'\\s*[a-z]+\\s*'")))).isEqualTo(6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'natasha, 9102, miss you'", "'\\s*[a-z]+\\s*'", "10")))).isEqualTo(15);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_position", "'natasha, 9102, miss you'", "'\\s'", "10", "2")))).isEqualTo(20);
    }
}

