/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestBlockAndPositionNullConvention {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalar(FunctionWithBlockAndPositionConvention.class).scalar(FunctionWithValueBlockAndPositionConvention.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBlockPosition() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_block_position", "BIGINT '1234'")))).isEqualTo(1234L);
        Assertions.assertThat((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionBigint.get()).isTrue();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_block_position", "12.34e0")))).isEqualTo(12.34);
        Assertions.assertThat((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionDouble.get()).isTrue();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_block_position", "'hello'")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo("hello");
        Assertions.assertThat((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionSlice.get()).isTrue();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_block_position", "true")))).isEqualTo(true);
        Assertions.assertThat((boolean)FunctionWithBlockAndPositionConvention.hitBlockPositionBoolean.get()).isTrue();
    }

    @Test
    public void testValueBlockPosition() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_value_block_position", "BIGINT '1234'")))).isEqualTo(1234L);
        Assertions.assertThat((boolean)FunctionWithValueBlockAndPositionConvention.hitBlockPositionBigint.get()).isTrue();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_value_block_position", "12.34e0")))).isEqualTo(12.34);
        Assertions.assertThat((boolean)FunctionWithValueBlockAndPositionConvention.hitBlockPositionDouble.get()).isTrue();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_value_block_position", "'hello'")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo("hello");
        Assertions.assertThat((boolean)FunctionWithValueBlockAndPositionConvention.hitBlockPositionSlice.get()).isTrue();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("test_value_block_position", "true")))).isEqualTo(true);
        Assertions.assertThat((boolean)FunctionWithValueBlockAndPositionConvention.hitBlockPositionBoolean.get()).isTrue();
    }

    @ScalarFunction(value="test_block_position")
    public static final class FunctionWithBlockAndPositionConvention {
        private static final AtomicBoolean hitBlockPositionBigint = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionDouble = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionSlice = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionBoolean = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionObject = new AtomicBoolean();

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Object object) {
            return object;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlNullable @BlockPosition @SqlType(value="E") ValueBlock block, @BlockIndex int position) {
            hitBlockPositionObject.set(true);
            return TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Slice specializedSlice(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Slice slice) {
            return slice;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Slice specializedSlice(@TypeParameter(value="E") Type type, @SqlNullable @BlockPosition @SqlType(value="E", nativeContainerType=Slice.class) ValueBlock block, @BlockIndex int position) {
            hitBlockPositionSlice.set(true);
            return type.getSlice((Block)block, position);
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Boolean speciailizedBoolean(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Boolean bool) {
            return bool;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Boolean speciailizedBoolean(@TypeParameter(value="E") Type type, @SqlNullable @BlockPosition @SqlType(value="E", nativeContainerType=boolean.class) ValueBlock block, @BlockIndex int position) {
            hitBlockPositionBoolean.set(true);
            return type.getBoolean((Block)block, position);
        }

        @SqlType(value="bigint")
        @SqlNullable
        public static Long getLong(@SqlNullable @SqlType(value="bigint") Long number) {
            return number;
        }

        @SqlType(value="bigint")
        @SqlNullable
        public static Long getBlockPosition(@SqlNullable @BlockPosition @SqlType(value="bigint", nativeContainerType=long.class) ValueBlock block, @BlockIndex int position) {
            hitBlockPositionBigint.set(true);
            return BigintType.BIGINT.getLong((Block)block, position);
        }

        @SqlType(value="double")
        @SqlNullable
        public static Double getDouble(@SqlNullable @SqlType(value="double") Double number) {
            return number;
        }

        @SqlType(value="double")
        @SqlNullable
        public static Double getDouble(@SqlNullable @BlockPosition @SqlType(value="double", nativeContainerType=double.class) ValueBlock block, @BlockIndex int position) {
            hitBlockPositionDouble.set(true);
            return DoubleType.DOUBLE.getDouble((Block)block, position);
        }
    }

    @ScalarFunction(value="test_value_block_position")
    public static final class FunctionWithValueBlockAndPositionConvention {
        private static final AtomicBoolean hitBlockPositionBigint = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionDouble = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionSlice = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionBoolean = new AtomicBoolean();
        private static final AtomicBoolean hitBlockPositionObject = new AtomicBoolean();

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Object object) {
            return object;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlNullable @BlockPosition @SqlType(value="E") ValueBlock block, @BlockIndex int position) {
            hitBlockPositionObject.set(true);
            return TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Slice specializedSlice(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Slice slice) {
            return slice;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Slice specializedSlice(@TypeParameter(value="E") Type type, @SqlNullable @BlockPosition @SqlType(value="E", nativeContainerType=Slice.class) ValueBlock block, @BlockIndex int position) {
            hitBlockPositionSlice.set(true);
            return type.getSlice((Block)block, position);
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Boolean speciailizedBoolean(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Boolean bool) {
            return bool;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Boolean speciailizedBoolean(@TypeParameter(value="E") Type type, @SqlNullable @BlockPosition @SqlType(value="E", nativeContainerType=boolean.class) ValueBlock block, @BlockIndex int position) {
            hitBlockPositionBoolean.set(true);
            return type.getBoolean((Block)block, position);
        }

        @SqlType(value="bigint")
        @SqlNullable
        public static Long getLong(@SqlNullable @SqlType(value="bigint") Long number) {
            return number;
        }

        @SqlType(value="bigint")
        @SqlNullable
        public static Long getBlockPosition(@SqlNullable @BlockPosition @SqlType(value="bigint", nativeContainerType=long.class) ValueBlock block, @BlockIndex int position) {
            hitBlockPositionBigint.set(true);
            return BigintType.BIGINT.getLong((Block)block, position);
        }

        @SqlType(value="double")
        @SqlNullable
        public static Double getDouble(@SqlNullable @SqlType(value="double") Double number) {
            return number;
        }

        @SqlType(value="double")
        @SqlNullable
        public static Double getDouble(@SqlNullable @BlockPosition @SqlType(value="double", nativeContainerType=double.class) ValueBlock block, @BlockIndex int position) {
            hitBlockPositionDouble.set(true);
            return DoubleType.DOUBLE.getDouble((Block)block, position);
        }
    }
}

