/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.trino.json.JsonInputErrorNode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.Json2016Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJsonInputFunctions {
    private static final String INPUT = "{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}";
    private static final JsonNode JSON_OBJECT = new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)DoubleNode.valueOf((double)1.0), (Object)"key2", (Object)BooleanNode.TRUE, (Object)"key3", (Object)NullNode.instance));
    private static final String ERROR_INPUT = "[...";
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testVarcharToJson() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varchar_to_json\"('[]', true)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(new ArrayNode(JsonNodeFactory.instance));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JSON_OBJECT);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varchar_to_json\"('[...', true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varchar_to_json\"('[...', false)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JsonInputErrorNode.JSON_ERROR);
    }

    @Test
    public void testVarbinaryUtf8ToJson() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_8) + ", true)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JSON_OBJECT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf8_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_8) + ", true)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JSON_OBJECT);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varbinary_utf8_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_16LE) + ", true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf8_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_16LE) + ", false)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JsonInputErrorNode.JSON_ERROR);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varbinary_utf8_to_json\"(" + TestJsonInputFunctions.toVarbinary(ERROR_INPUT, StandardCharsets.UTF_8) + ", true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf8_to_json\"(" + TestJsonInputFunctions.toVarbinary(ERROR_INPUT, StandardCharsets.UTF_8) + ", false)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JsonInputErrorNode.JSON_ERROR);
    }

    @Test
    public void testVarbinaryUtf16ToJson() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf16_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_16LE) + ", true)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JSON_OBJECT);
        String varbinaryLiteral = TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_16BE);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varbinary_utf16_to_json\"(" + varbinaryLiteral + ", true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varbinary_utf16_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_8) + ", true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf16_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_8) + ", false)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JsonInputErrorNode.JSON_ERROR);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varbinary_utf16_to_json\"(" + TestJsonInputFunctions.toVarbinary(ERROR_INPUT, StandardCharsets.UTF_16LE) + ", true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf16_to_json\"(" + TestJsonInputFunctions.toVarbinary(ERROR_INPUT, StandardCharsets.UTF_16LE) + ", false)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JsonInputErrorNode.JSON_ERROR);
    }

    @Test
    public void testVarbinaryUtf32ToJson() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf32_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, Charset.forName("UTF-32LE")) + ", true)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JSON_OBJECT);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varbinary_utf32_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, Charset.forName("UTF-32BE")) + ", true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varbinary_utf32_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_8) + ", true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf32_to_json\"(" + TestJsonInputFunctions.toVarbinary(INPUT, StandardCharsets.UTF_8) + ", false)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JsonInputErrorNode.JSON_ERROR);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("\"$varbinary_utf32_to_json\"(" + TestJsonInputFunctions.toVarbinary(ERROR_INPUT, Charset.forName("UTF-32LE")) + ", true)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varbinary_utf32_to_json\"(" + TestJsonInputFunctions.toVarbinary(ERROR_INPUT, Charset.forName("UTF-32LE")) + ", false)")))).hasType((Type)Json2016Type.JSON_2016).isEqualTo(JsonInputErrorNode.JSON_ERROR);
    }

    @Test
    public void testNullInput() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varchar_to_json\"(null, true)")))).isNull((Type)Json2016Type.JSON_2016);
    }

    @Test
    public void testDuplicateObjectKeys() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("\"$varchar_to_json\"('{\"key\" : 1, \"key\" : 2}', true)")))).hasType((Type)Json2016Type.JSON_2016).isIn(new Object[]{new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key", (Object)IntNode.valueOf((int)1))), new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key", (Object)IntNode.valueOf((int)2)))});
    }

    private static String toVarbinary(String value, Charset encoding) {
        return "X'" + BaseEncoding.base16().encode(value.getBytes(encoding)) + "'";
    }
}

