/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.Session;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingSession;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestAtTimeZone {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        Session session = TestingSession.testSessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia")).build();
        this.assertions = new QueryAssertions(session);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testAtTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.1 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.1 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.12 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.12 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.123 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.123 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.1234 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.1234 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.12345 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.12345 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.123456 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.123456 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.1234567 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.1234567 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.12345678 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.12345678 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.123456789 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.123456789 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.1234567891 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.1234567891 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.12345678912 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.12345678912 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.123456789123 +07:09', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-04-30 22:25:56.123456789123 America/Los_Angeles'");
    }

    @Test
    public void testAtTimeZoneWithOffset() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.1 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.1 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.12 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.12 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.123 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.123 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.1234 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.1234 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.12345 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.12345 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.123456 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.123456 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.1234567 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.1234567 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.12345678 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.12345678 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.123456789 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.123456789 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.1234567891 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.1234567891 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.12345678912 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.12345678912 +03:04'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("at_timezone(TIMESTAMP '2020-05-01 12:34:56.123456789123 +07:09', INTERVAL '03:04' HOUR TO MINUTE)")))).matches("TIMESTAMP '2020-05-01 08:29:56.123456789123 +03:04'");
    }
}

