/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.testing.Closeables;
import io.trino.server.GenerateTraceTokenRequestFilter;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.testing.TestingTrinoServer;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import java.io.Closeable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestGenerateTokenFilter {
    private JettyHttpClient httpClient;
    private TestingTrinoServer server;
    private GenerateTraceTokenRequestFilter filter;

    @BeforeAll
    public void setup() {
        this.server = TestingTrinoServer.builder().setAdditionalModule((Module)new TestGenerateTokenFilterModule()).build();
        this.httpClient = (JettyHttpClient)this.server.getInstance(Key.get(HttpClient.class, GenerateTokenFilterTest.class));
        List filters = this.httpClient.getRequestFilters();
        Assertions.assertThat((int)filters.size()).isEqualTo(2);
        io.airlift.testing.Assertions.assertInstanceOf((Object)((HttpRequestFilter)filters.get(1)), GenerateTraceTokenRequestFilter.class);
        this.filter = (GenerateTraceTokenRequestFilter)filters.get(1);
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{this.server, this.httpClient});
        this.server = null;
        this.httpClient = null;
    }

    @Test
    public void testTraceToken() {
        Request request = Request.Builder.prepareGet().setUri(this.server.getBaseUrl().resolve("/testing/echo_token")).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        Assertions.assertThat((String)response.getBody()).isEqualTo(this.filter.getLastToken());
    }

    static class TestGenerateTokenFilterModule
    implements Module {
        TestGenerateTokenFilterModule() {
        }

        public void configure(Binder binder) {
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("test", GenerateTokenFilterTest.class).withTracing().withFilter(GenerateTraceTokenRequestFilter.class);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingAnnotation
    private static @interface GenerateTokenFilterTest {
    }

    @Path(value="/testing")
    public static class TestResource {
        @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
        @GET
        @Path(value="/echo_token")
        public String echoToken(@HeaderParam(value="X-Airlift-Tracetoken") String token) {
            return token;
        }
    }
}

