/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.StaticConnectorFactory;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ViewColumn;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.tree.GenericLiteral;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestMaterializedViews
extends BasePlanTest {
    private static final String SCHEMA = "tiny";

    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema(SCHEMA).setSystemProperty("task_concurrency", "1");
        TestingMetadata testingConnectorMetadata = new TestingMetadata();
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
        queryRunner.createCatalog("test_catalog", (ConnectorFactory)new StaticConnectorFactory("test", new TestMaterializedViewConnector((ConnectorMetadata)testingConnectorMetadata)), (Map)ImmutableMap.of());
        Metadata metadata = queryRunner.getMetadata();
        SchemaTableName testTable = new SchemaTableName(SCHEMA, "test_table");
        queryRunner.inTransaction(session -> {
            metadata.createTable(session, "test_catalog", new ConnectorTableMetadata(testTable, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), SaveMode.FAIL);
            return null;
        });
        SchemaTableName storageTable = new SchemaTableName(SCHEMA, "storage_table");
        queryRunner.inTransaction(session -> {
            metadata.createTable(session, "test_catalog", new ConnectorTableMetadata(storageTable, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), SaveMode.FAIL);
            return null;
        });
        SchemaTableName storageTableWithCasts = new SchemaTableName(SCHEMA, "storage_table_with_casts");
        queryRunner.inTransaction(session -> {
            metadata.createTable(session, "test_catalog", new ConnectorTableMetadata(storageTableWithCasts, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)TinyintType.TINYINT), (Object)new ColumnMetadata("b", (Type)VarcharType.VARCHAR))), SaveMode.FAIL);
            return null;
        });
        QualifiedObjectName freshMaterializedView = new QualifiedObjectName("test_catalog", SCHEMA, "fresh_materialized_view");
        MaterializedViewDefinition materializedViewDefinition = new MaterializedViewDefinition("SELECT a, b FROM test_table", Optional.of("test_catalog"), Optional.of(SCHEMA), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("b", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(TestingMetadata.STALE_MV_STALENESS.plusHours(1L)), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName("test_catalog", SCHEMA, "storage_table")));
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, freshMaterializedView, materializedViewDefinition, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedView.asSchemaTableName());
        QualifiedObjectName notFreshMaterializedView = new QualifiedObjectName("test_catalog", SCHEMA, "not_fresh_materialized_view");
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, notFreshMaterializedView, materializedViewDefinition, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        MaterializedViewDefinition materializedViewDefinitionWithCasts = new MaterializedViewDefinition("SELECT a, b FROM test_table", Optional.of("test_catalog"), Optional.of(SCHEMA), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("b", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName("test_catalog", SCHEMA, "storage_table_with_casts")));
        QualifiedObjectName materializedViewWithCasts = new QualifiedObjectName("test_catalog", SCHEMA, "materialized_view_with_casts");
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, materializedViewWithCasts, materializedViewDefinitionWithCasts, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        testingConnectorMetadata.markMaterializedViewIsFresh(materializedViewWithCasts.asSchemaTableName());
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, new QualifiedObjectName("test_catalog", SCHEMA, "stale_materialized_view_with_casts"), materializedViewDefinitionWithCasts, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        return queryRunner;
    }

    @Test
    public void testFreshMaterializedView() {
        this.assertPlan("SELECT * FROM fresh_materialized_view", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("storage_table")));
    }

    @Test
    public void testNotFreshMaterializedView() {
        Session defaultSession = this.getQueryRunner().getDefaultSession();
        Session legacyGracePeriod = Session.builder((Session)defaultSession).setSystemProperty("legacy_materialized_view_grace_period", "true").build();
        Session futureSession = Session.builder((Session)defaultSession).setStart(Instant.now().plus(1L, ChronoUnit.DAYS)).build();
        this.assertPlan("SELECT * FROM not_fresh_materialized_view", defaultSession, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("storage_table")));
        this.assertPlan("SELECT * FROM not_fresh_materialized_view", legacyGracePeriod, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("test_table")));
        this.assertPlan("SELECT * FROM not_fresh_materialized_view", futureSession, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("test_table")));
    }

    @Test
    public void testMaterializedViewWithCasts() {
        TestingAccessControlManager accessControl = this.getQueryRunner().getAccessControl();
        accessControl.columnMask(new QualifiedObjectName("test_catalog", SCHEMA, "materialized_view_with_casts"), "a", "user", ViewExpression.builder().expression("a + 1").build());
        this.assertPlan("SELECT * FROM materialized_view_with_casts", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"A_CAST", (Object)PlanMatchPattern.expression("CAST(A as BIGINT) + BIGINT '1'"), (Object)"B_CAST", (Object)PlanMatchPattern.expression("CAST(B as BIGINT)")), PlanMatchPattern.tableScan("storage_table_with_casts", (Map<String, String>)ImmutableMap.of((Object)"A", (Object)"a", (Object)"B", (Object)"b")))));
    }

    @Test
    public void testRefreshMaterializedViewWithCasts() {
        this.assertPlan("REFRESH MATERIALIZED VIEW stale_materialized_view_with_casts", PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter(List.of("A_CAST", "B_CAST"), List.of("a", "b"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.project(Map.of("A_CAST", PlanMatchPattern.expression("CAST(A AS tinyint)"), "B_CAST", PlanMatchPattern.expression("CAST(B AS varchar)")), PlanMatchPattern.tableScan("test_table", Map.of("A", "a", "B", "b")))))));
        this.assertPlan("REFRESH MATERIALIZED VIEW materialized_view_with_casts", PlanMatchPattern.output(PlanMatchPattern.values(List.of("rows"), List.of(List.of(new GenericLiteral("BIGINT", "0"))))));
    }

    private static class TestMaterializedViewConnector
    implements Connector {
        private final ConnectorMetadata metadata;

        public TestMaterializedViewConnector(ConnectorMetadata metadata) {
            this.metadata = metadata;
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
            return new ConnectorTransactionHandle(){};
        }

        public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
            return this.metadata;
        }
    }
}

