/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DecorrelateInnerUnnestWithGlobalAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestDecorrelateInnerUnnestWithGlobalAggregation
extends BaseRuleTest {
    public TestDecorrelateInnerUnnestWithGlobalAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireWithoutGlobalAggregation() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(p.symbol("unnested")).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values(new Symbol[0])))))).doesNotFire();
    }

    @Test
    public void doesNotFireWithoutUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnSourceDependentUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("a"), (List)ImmutableList.of((Object)p.symbol("unnested_a")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))).doesNotFire();
    }

    @Test
    public void testTransformCorrelatedUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(unnested_corr)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("ordinality IS NOT NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testPreexistingMask() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr"), (Object)p.symbol("old_masks")), (PlanNode)p.values(p.symbol("corr"), p.symbol("old_masks")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(unnested_corr)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), p.symbol("old_mask")).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("old_masks"), (List)ImmutableList.of((Object)p.symbol("old_mask")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "old_masks", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"new_mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_mask", (Object)PlanMatchPattern.expression("old_mask AND mask")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("ordinality IS NOT NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"old_masks", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr")), (Object)PlanMatchPattern.UnnestMapping.unnestMapping("old_masks", (List<String>)ImmutableList.of((Object)"old_mask"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr", "old_masks"))))))));
    }

    @Test
    public void testWithPreexistingOrdinality() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(unnested_corr)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.of(p.symbol("ordinality")), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("ordinality IS NOT NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testMultipleGlobalAggregations() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.globalGrouping().addAggregation(p.symbol("arbitrary"), PlanBuilder.expression("arbitrary(sum)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(unnested_corr)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("any_value"), PlanMatchPattern.functionCall("any_value", (List<String>)ImmutableList.of((Object)"sum"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("ordinality IS NOT NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))))));
    }

    @Test
    public void testProjectOverGlobalAggregation() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("sum_1"), (Expression)PlanBuilder.expression("sum + 1")), (PlanNode)p.aggregation(innerBuilder -> innerBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(unnested_corr)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))).matches(PlanMatchPattern.project(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"unique", (Object)PlanMatchPattern.expression("unique"), (Object)"sum_1", (Object)PlanMatchPattern.expression("sum + 1")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("ordinality IS NOT NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))))));
    }

    @Test
    public void testPreprojectUnnestSymbol() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> {
            Symbol corr = p.symbol("corr", (Type)VarcharType.VARCHAR);
            FunctionCall regexpExtractAll = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("regexp_extract_all", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)corr.toSymbolReference(), (Object)new StringLiteral(".")));
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)corr), (PlanNode)p.values(corr), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("max"), PlanBuilder.expression("max(unnested_corr)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("char_array"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("char_array"), (Expression)regexpExtractAll), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "char_array"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("ordinality IS NOT NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique", (Object)"char_array"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("char_array", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"char_array", (Object)PlanMatchPattern.expression("regexp_extract_all(corr, '.')")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))))));
    }

    @Test
    public void testMultipleNodesOverUnnestInSubquery() {
        this.tester().assertThat((Rule<?>)new DecorrelateInnerUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("groups"), (Object)p.symbol("numbers")), (PlanNode)p.values(p.symbol("groups"), p.symbol("numbers")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("sum_1"), (Expression)PlanBuilder.expression("sum + 1")), (PlanNode)p.aggregation(globalBuilder -> globalBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(negate)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().put(p.symbol("negate"), PlanBuilder.expression("-max")).build(), (PlanNode)p.aggregation(groupedBuilder -> groupedBuilder.singleGroupingSet(p.symbol("group")).addAggregation(p.symbol("max"), PlanBuilder.expression("max(modulo)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().putIdentities((Iterable)ImmutableList.of((Object)p.symbol("group"), (Object)p.symbol("number"))).put(p.symbol("modulo"), PlanBuilder.expression("number % 10")).build(), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("groups"), (List)ImmutableList.of((Object)p.symbol("group"))), (Object)new UnnestNode.Mapping(p.symbol("numbers"), (List)ImmutableList.of((Object)p.symbol("number")))), Optional.empty(), JoinNode.Type.INNER, Optional.empty(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sum_1", (Object)PlanMatchPattern.expression("sum + 1")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groups", "numbers", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"negated"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"negated", (Object)PlanMatchPattern.expression("-max")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groups", "numbers", "unique", "mask", "group"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"modulo"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"modulo", (Object)PlanMatchPattern.expression("number % 10")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("ordinality IS NOT NULL")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"groups", (Object)"numbers", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("groups", (List<String>)ImmutableList.of((Object)"group")), (Object)PlanMatchPattern.UnnestMapping.unnestMapping("numbers", (List<String>)ImmutableList.of((Object)"number"))), Optional.of("ordinality"), JoinNode.Type.LEFT, Optional.empty(), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("groups", "numbers")))))))))));
    }
}

