/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneDistinctAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneDistinctAggregation
extends BaseRuleTest {
    public TestPruneDistinctAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruning() {
        this.tester().assertThat((Rule<?>)new PruneDistinctAggregation()).on(p -> {
            Symbol a = p.symbol("a");
            AggregationNode child = p.aggregation(aggregationBuilder -> aggregationBuilder.globalGrouping().source((PlanNode)p.values(1, a)));
            return p.aggregation(aggregationBuilder -> aggregationBuilder.globalGrouping().source((PlanNode)child));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.values("a")));
    }

    @Test
    public void testNonPruning() {
        this.tester().assertThat((Rule<?>)new PruneDistinctAggregation()).on(p -> {
            Symbol a = p.symbol("a");
            AggregationNode child = p.aggregation(aggregationBuilder -> aggregationBuilder.globalGrouping().addAggregation(p.symbol("sum", (Type)BigintType.BIGINT), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(1, a)));
            return p.aggregation(aggregationBuilder -> aggregationBuilder.globalGrouping().source((PlanNode)child));
        }).doesNotFire();
    }
}

