/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PrunePatternRecognitionSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.PatternRecognitionRelation;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPrunePatternRecognitionSourceColumns
extends BaseRuleTest {
    public TestPrunePatternRecognitionSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneUnreferencedInput() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values("a"))));
    }

    @Test
    public void testDoNotPruneInputsWithAllRowsPerMatch() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPrunePartitionByInputs() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPruneOrderByInputs() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("a")), (Map)ImmutableMap.of((Object)p.symbol("a"), (Object)SortOrder.ASC_NULLS_LAST))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPruneMeasureInputs() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.addMeasure(p.symbol("measure"), "LAST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPruneVariableDefinitionInputs() {
        this.tester().assertThat((Rule<?>)new PrunePatternRecognitionSourceColumns()).on(p -> p.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "LAST(X.a > 0)").source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }
}

