/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.test.RuleBuilder;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RuleTester
implements Closeable {
    private final Metadata metadata;
    private final Session session;
    private final LocalQueryRunner queryRunner;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final TypeAnalyzer typeAnalyzer;
    private final FunctionManager functionManager;

    public static RuleTester defaultRuleTester() {
        return RuleTester.builder().build();
    }

    public RuleTester(LocalQueryRunner queryRunner) {
        this.queryRunner = Objects.requireNonNull(queryRunner, "queryRunner is null");
        this.session = queryRunner.getDefaultSession();
        this.metadata = queryRunner.getMetadata();
        this.functionManager = queryRunner.getFunctionManager();
        this.splitManager = queryRunner.getSplitManager();
        this.pageSourceManager = queryRunner.getPageSourceManager();
        this.typeAnalyzer = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)queryRunner.getPlannerContext());
    }

    public RuleBuilder assertThat(Rule<?> rule) {
        return new RuleBuilder(rule, this.queryRunner, this.session);
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }

    public PlannerContext getPlannerContext() {
        return this.queryRunner.getPlannerContext();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public Session getSession() {
        return this.session;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public TypeAnalyzer getTypeAnalyzer() {
        return this.typeAnalyzer;
    }

    public CatalogHandle getCurrentCatalogHandle() {
        return this.queryRunner.getCatalogHandle((String)this.session.getCatalog().orElseThrow());
    }

    public TableHandle getCurrentCatalogTableHandle(String schemaName, String tableName) {
        return this.queryRunner.getTableHandle((String)this.session.getCatalog().orElseThrow(), schemaName, tableName);
    }

    public LocalQueryRunner getQueryRunner() {
        return this.queryRunner;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Plugin> plugins = new ArrayList<Plugin>();
        private final Map<String, String> sessionProperties = new HashMap<String, String>();
        private Optional<Integer> nodeCountForStats = Optional.empty();
        private ConnectorFactory defaultCatalogConnectorFactory = new TpchConnectorFactory(1);

        private Builder() {
        }

        public Builder addPlugin(Plugin plugin) {
            this.plugins.add(Objects.requireNonNull(plugin, "plugin is null"));
            return this;
        }

        public Builder addPlugins(List<Plugin> plugins) {
            this.plugins.addAll((Collection<Plugin>)Objects.requireNonNull(plugins, "plugins is null"));
            return this;
        }

        public Builder addSessionProperty(String key, String value) {
            this.sessionProperties.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
            return this;
        }

        public Builder withNodeCountForStats(int count) {
            this.nodeCountForStats = Optional.of(count);
            return this;
        }

        public Builder withDefaultCatalogConnectorFactory(ConnectorFactory defaultCatalogConnectorFactory) {
            this.defaultCatalogConnectorFactory = defaultCatalogConnectorFactory;
            return this;
        }

        public RuleTester build() {
            Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").setSystemProperty("task_concurrency", "1");
            for (Map.Entry<String, String> entry : this.sessionProperties.entrySet()) {
                sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
            }
            Session session = sessionBuilder.build();
            LocalQueryRunner queryRunner = this.nodeCountForStats.map(nodeCount -> LocalQueryRunner.builder((Session)session).withNodeCountForStats(nodeCount.intValue()).build()).orElseGet(() -> LocalQueryRunner.create((Session)session));
            queryRunner.createCatalog((String)session.getCatalog().orElseThrow(), this.defaultCatalogConnectorFactory, (Map)ImmutableMap.of());
            this.plugins.forEach(arg_0 -> ((LocalQueryRunner)queryRunner).installPlugin(arg_0));
            return new RuleTester(queryRunner);
        }
    }
}

