/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableMap;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.query.QueryAssertions;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class TestFilteredAggregations
extends BasePlanTest {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testAddPredicateForFilterClauses() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT sum(x) FILTER(WHERE x > 0) FROM (VALUES 1, 1, 0, 2, 3, 3) t(x)")))).matches("VALUES (BIGINT '10')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT sum(x) FILTER(WHERE x > 0), sum(x) FILTER(WHERE x < 3) FROM (VALUES 1, 1, 0, 5, 3, 8) t(x)")))).matches("VALUES (BIGINT '18', BIGINT '2')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT sum(x) FILTER(WHERE x > 1), sum(x) FROM (VALUES 1, 1, 0, 2, 3, 3) t(x)")))).matches("VALUES (BIGINT '8', BIGINT '10')");
    }

    @Test
    public void testGroupAll() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(DISTINCT x) FILTER (WHERE x > 1) FROM (VALUES 1, 1, 1, 2, 3, 3) t(x)")))).matches("VALUES BIGINT '2'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(DISTINCT x) FILTER (WHERE x > 1), sum(DISTINCT x) FROM (VALUES 1, 1, 1, 2, 3, 3) t(x)")))).matches("VALUES (BIGINT '2', BIGINT '6')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(DISTINCT x) FILTER (WHERE x > 1), sum(DISTINCT y) FILTER (WHERE x < 3)FROM (VALUES (1, 10),(1, 20),(1, 20),(2, 20),(3, 30)) t(x, y)")))).matches("VALUES (BIGINT '2', BIGINT '30')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(x) FILTER (WHERE x > 1), sum(DISTINCT x) FROM (VALUES 1, 2, 3, 3) t(x)")))).matches("VALUES (BIGINT '3', BIGINT '6')");
    }

    @Test
    public void testGroupingSets() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT k, count(DISTINCT x) FILTER (WHERE y = 100), count(DISTINCT x) FILTER (WHERE y = 200) FROM (VALUES    (1, 1, 100),   (1, 1, 200),   (1, 2, 100),   (1, 3, 300),   (2, 1, 100),   (2, 10, 100),   (2, 20, 100),   (2, 20, 200),   (2, 30, 300),   (2, 40, 100)) t(k, x, y) GROUP BY GROUPING SETS ((), (k))")))).matches("VALUES (1, BIGINT '2', BIGINT '1'), (2, BIGINT '4', BIGINT '1'), (CAST(NULL AS INTEGER), BIGINT '5', BIGINT '2')");
    }

    @Test
    public void rewriteAddFilterWithMultipleFilters() {
        this.assertPlan("SELECT sum(totalprice) FILTER(WHERE totalprice > 0), sum(custkey) FILTER(WHERE custkey > 0) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.filter("(\"totalprice\" > 0E0 OR \"custkey\" > BIGINT '0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey", (Object)"custkey")))));
    }

    @Test
    public void testDoNotPushdownPredicateIfNonFilteredAggregateIsPresent() {
        this.assertPlanContainsNoFilter("SELECT sum(totalprice) FILTER(WHERE totalprice > 0), sum(custkey) FROM orders");
    }

    @Test
    public void testPushDownConstantFilterPredicate() {
        this.assertPlanContainsNoFilter("SELECT sum(totalprice) FILTER(WHERE FALSE) FROM orders");
        this.assertPlanContainsNoFilter("SELECT sum(totalprice) FILTER(WHERE TRUE) FROM orders");
    }

    @Test
    public void testNoFilterAddedForConstantValueFilters() {
        this.assertPlanContainsNoFilter("SELECT sum(x) FILTER(WHERE x > 0) FROM (VALUES 1, 1, 0, 2, 3, 3) t(x) GROUP BY x");
        this.assertPlanContainsNoFilter("SELECT sum(totalprice) FILTER(WHERE totalprice > 0) FROM orders GROUP BY totalprice");
    }

    private void assertPlanContainsNoFilter(String sql) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(sql, LogicalPlanner.Stage.OPTIMIZED).getRoot()).whereIsInstanceOfAny(new Class[]{FilterNode.class}).matches()).describedAs("Unexpected node for query: " + sql, new Object[0])).isFalse();
    }
}

