/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import io.trino.type.JsonType;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonType
extends AbstractTestType {
    public TestJsonType() {
        super((Type)JsonType.JSON, String.class, TestJsonType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        VariableWidthBlockBuilder blockBuilder = JsonType.JSON.createBlockBuilder(null, 1);
        Slice slice = Slices.utf8Slice((String)"{\"x\":1, \"y\":2}");
        JsonType.JSON.writeSlice((BlockBuilder)blockBuilder, slice);
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return null;
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getPreviousValue(this.getSampleValue())).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + this.type);
    }

    @Test
    public void testNextValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getNextValue(this.getSampleValue())).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + this.type);
    }
}

