/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.spi.block.BlockEncodingSerde;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;

public class PagesSerdeFactory {
    private static final int SERIALIZED_PAGE_DEFAULT_BLOCK_SIZE_IN_BYTES = 65536;
    private final BlockEncodingSerde blockEncodingSerde;
    private final boolean compressionEnabled;

    public PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, boolean compressionEnabled) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.compressionEnabled = compressionEnabled;
    }

    public PageSerializer createSerializer(Optional<SecretKey> encryptionKey) {
        return new PageSerializer(this.blockEncodingSerde, this.compressionEnabled, encryptionKey, 65536);
    }

    public PageDeserializer createDeserializer(Optional<SecretKey> encryptionKey) {
        return new PageDeserializer(this.blockEncodingSerde, this.compressionEnabled, encryptionKey, 65536);
    }
}

