/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import com.google.common.base.Ticker;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.execution.executor.scheduler.Group;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
final class TaskControl {
    private final Group group;
    private final int id;
    private final Ticker ticker;
    private final Lock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    private final Condition wakeup = this.lock.newCondition();
    @GuardedBy(value="lock")
    private boolean ready;
    @GuardedBy(value="lock")
    private boolean blocked;
    @GuardedBy(value="lock")
    private boolean cancelled;
    @GuardedBy(value="lock")
    private State state;
    private volatile long periodStart;
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong scheduledNanos = new AtomicLong();
    private final AtomicLong blockedNanos = new AtomicLong();
    private final AtomicLong waitNanos = new AtomicLong();
    private volatile Thread thread;

    public TaskControl(Group group, int id, Ticker ticker) {
        this.group = Objects.requireNonNull(group, "group is null");
        this.id = id;
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
        this.state = State.NEW;
        this.ready = false;
        this.periodStart = ticker.read();
    }

    public int id() {
        return this.id;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void cancel() {
        this.lock.lock();
        try {
            this.cancelled = true;
            this.wakeup.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean markReady() {
        this.lock.lock();
        try {
            if (this.cancelled) {
                boolean bl = false;
                return bl;
            }
            this.ready = true;
            this.wakeup.signal();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public void markNotReady() {
        this.lock.lock();
        try {
            this.ready = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isReady() {
        this.lock.lock();
        try {
            boolean bl = this.ready;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean awaitReady() {
        this.lock.lock();
        try {
            while (!this.ready && !this.cancelled) {
                try {
                    this.wakeup.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean bl = !this.cancelled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void markUnblocked() {
        this.lock.lock();
        try {
            this.blocked = false;
            this.wakeup.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void markBlocked() {
        this.lock.lock();
        try {
            this.blocked = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void awaitUnblock() {
        this.lock.lock();
        try {
            while (this.blocked && !this.cancelled) {
                try {
                    this.wakeup.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean transitionToBlocked() {
        boolean success = this.transitionTo(State.BLOCKED);
        if (success) {
            this.markBlocked();
        }
        return success;
    }

    public void transitionToFinished() {
        this.transitionTo(State.FINISHED);
    }

    public boolean transitionToWaiting() {
        boolean success = this.transitionTo(State.WAITING);
        if (success) {
            this.markNotReady();
        }
        return success;
    }

    public boolean transitionToRunning() {
        return this.transitionTo(State.RUNNING);
    }

    private boolean transitionTo(State state) {
        this.lock.lock();
        try {
            this.recordPeriodEnd(this.state);
            if (this.cancelled) {
                this.state = State.INTERRUPTED;
                boolean bl = false;
                return bl;
            }
            this.state = state;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void recordPeriodEnd(State state) {
        long now = this.ticker.read();
        long elapsed = now - this.periodStart;
        switch (state) {
            case RUNNING: {
                this.scheduledNanos.addAndGet(elapsed);
                break;
            }
            case BLOCKED: {
                this.blockedNanos.addAndGet(elapsed);
                break;
            }
            case NEW: {
                this.startNanos.addAndGet(elapsed);
                break;
            }
            case WAITING: {
                this.waitNanos.addAndGet(elapsed);
                break;
            }
        }
        this.periodStart = now;
    }

    public Group group() {
        return this.group;
    }

    public State getState() {
        this.lock.lock();
        try {
            State state = this.state;
            return state;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long elapsed() {
        return this.ticker.read() - this.periodStart;
    }

    public long getStartNanos() {
        return this.startNanos.get();
    }

    public long getWaitNanos() {
        return this.waitNanos.get();
    }

    public long getScheduledNanos() {
        return this.scheduledNanos.get();
    }

    public long getBlockedNanos() {
        return this.blockedNanos.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskControl that = (TaskControl)o;
        return this.id == that.id && this.group.equals(that.group);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.id);
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = this.group.name() + "-" + this.id + " [" + this.state + "]";
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public static enum State {
        NEW,
        WAITING,
        RUNNING,
        BLOCKED,
        INTERRUPTED,
        FINISHED;

    }
}

