/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import io.trino.operator.FlatHash;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class VariableWidthData {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(VariableWidthData.class);
    public static final int MIN_CHUNK_SIZE = 1024;
    public static final int MAX_CHUNK_SIZE = 0x800000;
    public static final int POINTER_SIZE = 12;
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    public static final byte[] EMPTY_CHUNK = new byte[0];
    private final List<byte[]> chunks = new ArrayList<byte[]>();
    private int openChunkOffset;
    private long chunksRetainedSizeInBytes;
    private long allocatedBytes;
    private long freeBytes;

    public VariableWidthData() {
    }

    public VariableWidthData(VariableWidthData variableWidthData) {
        for (byte[] chunk : variableWidthData.chunks) {
            this.chunks.add(Arrays.copyOf(chunk, chunk.length));
        }
        this.openChunkOffset = variableWidthData.openChunkOffset;
        this.chunksRetainedSizeInBytes = variableWidthData.chunksRetainedSizeInBytes;
        this.allocatedBytes = variableWidthData.allocatedBytes;
        this.freeBytes = variableWidthData.freeBytes;
    }

    public VariableWidthData(List<byte[]> chunks, int openChunkOffset) {
        this.chunks.addAll(chunks);
        this.openChunkOffset = openChunkOffset;
        this.chunksRetainedSizeInBytes = chunks.stream().mapToLong(SizeOf::sizeOf).reduce(0L, Math::addExact);
        this.allocatedBytes = chunks.stream().mapToLong(chunk -> ((byte[])chunk).length).sum();
        this.freeBytes = 0L;
    }

    public long getRetainedSizeBytes() {
        return FlatHash.sumExact(INSTANCE_SIZE, this.chunksRetainedSizeInBytes, SizeOf.sizeOfObjectArray((int)this.chunks.size()));
    }

    public List<byte[]> getAllChunks() {
        return this.chunks;
    }

    public long getAllocatedBytes() {
        return this.allocatedBytes;
    }

    public long getFreeBytes() {
        return this.freeBytes;
    }

    public byte[] allocate(byte[] pointer, int pointerOffset, int size) {
        byte[] openChunk;
        if (size == 0) {
            VariableWidthData.writePointer(pointer, pointerOffset, 0, 0, 0);
            return EMPTY_CHUNK;
        }
        byte[] byArray = openChunk = this.chunks.isEmpty() ? EMPTY_CHUNK : this.chunks.get(this.chunks.size() - 1);
        if (openChunk.length - this.openChunkOffset < size) {
            this.freeBytes += (long)(openChunk.length - this.openChunkOffset);
            int newSize = Ints.saturatedCast((long)Math.max((long)size * 32L, (long)openChunk.length * 2L));
            newSize = Ints.constrainToRange((int)newSize, (int)1024, (int)0x800000);
            newSize = Math.max(newSize, size);
            openChunk = new byte[newSize];
            this.chunks.add(openChunk);
            this.allocatedBytes += (long)newSize;
            this.chunksRetainedSizeInBytes = Math.addExact(this.chunksRetainedSizeInBytes, SizeOf.sizeOf((byte[])openChunk));
            this.openChunkOffset = 0;
        }
        VariableWidthData.writePointer(pointer, pointerOffset, this.chunks.size() - 1, this.openChunkOffset, size);
        this.openChunkOffset += size;
        return openChunk;
    }

    public void free(byte[] pointer, int pointerOffset) {
        int valueOffset;
        int valueLength = VariableWidthData.getValueLength(pointer, pointerOffset);
        if (valueLength == 0) {
            return;
        }
        int valueChunkIndex = VariableWidthData.getChunkIndex(pointer, pointerOffset);
        byte[] valueChunk = this.chunks.get(valueChunkIndex);
        if (valueChunkIndex == this.chunks.size() - 1 && this.openChunkOffset - valueLength == (valueOffset = VariableWidthData.getChunkOffset(pointer, pointerOffset))) {
            this.openChunkOffset = valueOffset;
            return;
        }
        if (valueLength == valueChunk.length) {
            this.chunks.set(valueChunkIndex, EMPTY_CHUNK);
            this.chunksRetainedSizeInBytes = Math.subtractExact(this.chunksRetainedSizeInBytes, SizeOf.sizeOf((byte[])valueChunk));
            this.allocatedBytes -= (long)valueChunk.length;
            return;
        }
        this.freeBytes += (long)valueLength;
    }

    public byte[] getChunk(byte[] pointer, int pointerOffset) {
        int chunkIndex = VariableWidthData.getChunkIndex(pointer, pointerOffset);
        if (this.chunks.isEmpty()) {
            Verify.verify((chunkIndex == 0 ? 1 : 0) != 0);
            return EMPTY_CHUNK;
        }
        Objects.checkIndex(chunkIndex, this.chunks.size());
        return this.chunks.get(chunkIndex);
    }

    private static int getChunkIndex(byte[] pointer, int pointerOffset) {
        return INT_HANDLE.get(pointer, pointerOffset);
    }

    public static int getChunkOffset(byte[] pointer, int pointerOffset) {
        return INT_HANDLE.get(pointer, pointerOffset + 4);
    }

    public static int getValueLength(byte[] pointer, int pointerOffset) {
        return INT_HANDLE.get(pointer, pointerOffset + 8);
    }

    public static void writePointer(byte[] pointer, int pointerOffset, int chunkIndex, int chunkOffset, int valueLength) {
        INT_HANDLE.set(pointer, pointerOffset, chunkIndex);
        INT_HANDLE.set(pointer, pointerOffset + 4, chunkOffset);
        INT_HANDLE.set(pointer, pointerOffset + 8, valueLength);
    }
}

