/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.PartitionFunction;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.output.SkewedPartitionRebalancer;
import io.trino.spi.Page;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ScaleWriterPartitioningExchanger
implements LocalExchanger {
    private static final double SCALE_WRITER_MEMORY_PERCENTAGE = 0.7;
    private final List<Consumer<Page>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final long maxBufferedBytes;
    private final Function<Page, Page> partitionedPagePreparer;
    private final PartitionFunction partitionFunction;
    private final SkewedPartitionRebalancer partitionRebalancer;
    private final IntArrayList[] writerAssignments;
    private final int[] partitionRowCounts;
    private final int[] partitionWriterIds;
    private final int[] partitionWriterIndexes;
    private final Supplier<Long> totalMemoryUsed;
    private final long maxMemoryPerNode;

    public ScaleWriterPartitioningExchanger(List<Consumer<Page>> buffers, LocalExchangeMemoryManager memoryManager, long maxBufferedBytes, Function<Page, Page> partitionedPagePreparer, PartitionFunction partitionFunction, int partitionCount, SkewedPartitionRebalancer partitionRebalancer, Supplier<Long> totalMemoryUsed, long maxMemoryPerNode) {
        this.buffers = Objects.requireNonNull(buffers, "buffers is null");
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.maxBufferedBytes = maxBufferedBytes;
        this.partitionedPagePreparer = Objects.requireNonNull(partitionedPagePreparer, "partitionedPagePreparer is null");
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionRebalancer = Objects.requireNonNull(partitionRebalancer, "partitionRebalancer is null");
        this.totalMemoryUsed = Objects.requireNonNull(totalMemoryUsed, "totalMemoryUsed is null");
        this.maxMemoryPerNode = maxMemoryPerNode;
        this.writerAssignments = new IntArrayList[buffers.size()];
        for (int i = 0; i < this.writerAssignments.length; ++i) {
            this.writerAssignments[i] = new IntArrayList();
        }
        this.partitionRowCounts = new int[partitionCount];
        this.partitionWriterIndexes = new int[partitionCount];
        this.partitionWriterIds = new int[partitionCount];
        Arrays.fill(this.partitionWriterIds, -1);
    }

    @Override
    public void accept(Page page) {
        long dataProcessed = 0L;
        for (int partitionId = 0; partitionId < this.partitionRowCounts.length; ++partitionId) {
            this.partitionRowCounts[partitionId] = 0;
            this.partitionWriterIds[partitionId] = -1;
        }
        if ((double)this.memoryManager.getBufferedBytes() > (double)this.maxBufferedBytes * 0.5 && (double)this.totalMemoryUsed.get().longValue() < (double)this.maxMemoryPerNode * 0.7) {
            this.partitionRebalancer.rebalance();
        }
        Page partitionPage = this.partitionedPagePreparer.apply(page);
        for (int position = 0; position < partitionPage.getPositionCount(); ++position) {
            int partitionId;
            int n = partitionId = this.partitionFunction.getPartition(partitionPage, position);
            this.partitionRowCounts[n] = this.partitionRowCounts[n] + 1;
            int writerId = this.partitionWriterIds[partitionId];
            if (writerId == -1) {
                this.partitionWriterIds[partitionId] = writerId = this.getNextWriterId(partitionId);
            }
            this.writerAssignments[writerId].add(position);
        }
        for (int bucket = 0; bucket < this.writerAssignments.length; ++bucket) {
            IntArrayList positionsList = this.writerAssignments[bucket];
            int bucketSize = positionsList.size();
            if (bucketSize == 0) continue;
            int[] positions = positionsList.elements();
            positionsList.clear();
            if (bucketSize == page.getPositionCount()) {
                page.compact();
                dataProcessed += this.sendPageToPartition(this.buffers.get(bucket), page);
                break;
            }
            Page pageSplit = page.copyPositions(positions, 0, bucketSize);
            dataProcessed += this.sendPageToPartition(this.buffers.get(bucket), pageSplit);
        }
        if ((double)this.totalMemoryUsed.get().longValue() < (double)this.maxMemoryPerNode * 0.7) {
            for (int partitionId = 0; partitionId < this.partitionRowCounts.length; ++partitionId) {
                this.partitionRebalancer.addPartitionRowCount(partitionId, this.partitionRowCounts[partitionId]);
            }
            this.partitionRebalancer.addDataProcessed(dataProcessed);
        }
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }

    private int getNextWriterId(int partitionId) {
        int n = partitionId;
        int n2 = this.partitionWriterIndexes[n];
        this.partitionWriterIndexes[n] = n2 + 1;
        return this.partitionRebalancer.getTaskId(partitionId, n2);
    }

    private long sendPageToPartition(Consumer<Page> buffer, Page pageSplit) {
        long retainedSizeInBytes = pageSplit.getRetainedSizeInBytes();
        this.memoryManager.updateMemoryUsage(retainedSizeInBytes);
        buffer.accept(pageSplit);
        return retainedSizeInBytes;
    }
}

