/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.OuterPositionIterator;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class LookupOuterOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final ListenableFuture<OuterPositionIterator> outerPositionsFuture;
    private final ListenableFuture<Void> blockedFutureView;
    private final List<Type> probeOutputTypes;
    private final Runnable onClose;
    private final PageBuilder pageBuilder;
    private OuterPositionIterator outerPositions;
    private boolean closed;

    public LookupOuterOperator(OperatorContext operatorContext, ListenableFuture<OuterPositionIterator> outerPositionsFuture, List<Type> probeOutputTypes, List<Type> buildOutputTypes, Runnable onClose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outerPositionsFuture = Objects.requireNonNull(outerPositionsFuture, "outerPositionsFuture is null");
        this.blockedFutureView = LookupOuterOperator.asVoid(outerPositionsFuture);
        ImmutableList types = ImmutableList.builder().addAll((Iterable)Objects.requireNonNull(probeOutputTypes, "probeOutputTypes is null")).addAll((Iterable)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null")).build();
        this.probeOutputTypes = ImmutableList.copyOf(probeOutputTypes);
        this.pageBuilder = new PageBuilder((List)types);
        this.onClose = Objects.requireNonNull(onClose, "onClose is null");
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        return this.blockedFutureView;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.closed;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (this.outerPositions == null) {
            this.outerPositions = MoreFutures.tryGetFutureValue(this.outerPositionsFuture).orElse(null);
            if (this.outerPositions == null) {
                return null;
            }
        }
        boolean outputPositionsFinished = false;
        while (!this.pageBuilder.isFull()) {
            boolean bl = outputPositionsFinished = !this.outerPositions.appendToNext(this.pageBuilder, this.probeOutputTypes.size());
            if (outputPositionsFinished) break;
            this.pageBuilder.declarePosition();
            for (int probeChannel = 0; probeChannel < this.probeOutputTypes.size(); ++probeChannel) {
                this.pageBuilder.getBlockBuilder(probeChannel).appendNull();
            }
        }
        Page page = null;
        if (this.pageBuilder.isFull() || outputPositionsFinished && !this.pageBuilder.isEmpty()) {
            page = this.pageBuilder.build();
            this.pageBuilder.reset();
        }
        if (outputPositionsFinished) {
            this.close();
        }
        return page;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.pageBuilder.reset();
        this.onClose.run();
    }

    public static class LookupOuterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> probeOutputTypes;
        private final List<Type> buildOutputTypes;
        private final JoinBridgeManager<?> joinBridgeManager;
        private boolean closed;

        public LookupOuterOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> probeOutputTypes, List<Type> buildOutputTypes, JoinBridgeManager<?> joinBridgeManager) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.probeOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeOutputTypes, "probeOutputTypes is null"));
            this.buildOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null"));
            this.joinBridgeManager = joinBridgeManager;
        }

        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"LookupOuterOperatorFactory is closed");
            ListenableFuture<OuterPositionIterator> outerPositionsFuture = this.joinBridgeManager.getOuterPositionsFuture();
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LookupOuterOperator.class.getSimpleName());
            this.joinBridgeManager.outerOperatorCreated();
            return new LookupOuterOperator(operatorContext, outerPositionsFuture, this.probeOutputTypes, this.buildOutputTypes, () -> this.joinBridgeManager.outerOperatorClosed());
        }

        @Override
        public void noMoreOperators() {
            this.joinBridgeManager.outerOperatorFactoryClosed();
            if (this.closed) {
                return;
            }
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Source operator factories cannot be duplicated");
        }
    }
}

