/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.PositionsAppenderSizeAccumulator;
import io.trino.operator.output.UnnestingPositionsAppender;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Objects;

public class PositionsAppenderPageBuilder {
    private static final int DEFAULT_INITIAL_EXPECTED_ENTRIES = 8;
    @VisibleForTesting
    static final int MAX_POSITION_COUNT = 32768;
    private static final int MAXIMUM_DIRECT_SIZE_MULTIPLIER = 8;
    private final UnnestingPositionsAppender[] channelAppenders;
    private final int maxPageSizeInBytes;
    private final int maxDirectPageSizeInBytes;
    private int declaredPositions;

    public static PositionsAppenderPageBuilder withMaxPageSize(int maxPageBytes, List<Type> sourceTypes, PositionsAppenderFactory positionsAppenderFactory) {
        return PositionsAppenderPageBuilder.withMaxPageSize(maxPageBytes, maxPageBytes * 8, sourceTypes, positionsAppenderFactory);
    }

    @VisibleForTesting
    static PositionsAppenderPageBuilder withMaxPageSize(int maxPageBytes, int maxDirectSizeInBytes, List<Type> sourceTypes, PositionsAppenderFactory positionsAppenderFactory) {
        return new PositionsAppenderPageBuilder(8, maxPageBytes, maxDirectSizeInBytes, sourceTypes, positionsAppenderFactory);
    }

    private PositionsAppenderPageBuilder(int initialExpectedEntries, int maxPageSizeInBytes, int maxDirectPageSizeInBytes, List<? extends Type> types, PositionsAppenderFactory positionsAppenderFactory) {
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(positionsAppenderFactory, "positionsAppenderFactory is null");
        Preconditions.checkArgument((maxPageSizeInBytes > 0 ? 1 : 0) != 0, (String)"maxPageSizeInBytes is negative: %s", (int)maxPageSizeInBytes);
        Preconditions.checkArgument((maxDirectPageSizeInBytes > 0 ? 1 : 0) != 0, (String)"maxDirectPageSizeInBytes is negative: %s", (int)maxDirectPageSizeInBytes);
        Preconditions.checkArgument((maxDirectPageSizeInBytes >= maxPageSizeInBytes ? 1 : 0) != 0, (String)"maxDirectPageSizeInBytes (%s) must be >= maxPageSizeInBytes (%s)", (int)maxDirectPageSizeInBytes, (int)maxPageSizeInBytes);
        this.maxPageSizeInBytes = maxPageSizeInBytes;
        this.maxDirectPageSizeInBytes = maxDirectPageSizeInBytes;
        this.channelAppenders = new UnnestingPositionsAppender[types.size()];
        for (int i = 0; i < this.channelAppenders.length; ++i) {
            this.channelAppenders[i] = positionsAppenderFactory.create(types.get(i), initialExpectedEntries, maxPageSizeInBytes);
        }
    }

    public void appendToOutputPartition(Page page, IntArrayList positions) {
        this.declarePositions(positions.size());
        for (int channel = 0; channel < this.channelAppenders.length; ++channel) {
            Block block = page.getBlock(channel);
            this.channelAppenders[channel].append(positions, block);
        }
    }

    public void appendToOutputPartition(Page page, int position) {
        this.declarePositions(1);
        for (int channel = 0; channel < this.channelAppenders.length; ++channel) {
            Block block = page.getBlock(channel);
            this.channelAppenders[channel].append(position, block);
        }
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = 0L;
        for (UnnestingPositionsAppender positionsAppender : this.channelAppenders) {
            retainedSizeInBytes += positionsAppender.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    public long getSizeInBytes() {
        long sizeInBytes = 0L;
        for (UnnestingPositionsAppender positionsAppender : this.channelAppenders) {
            sizeInBytes += positionsAppender.getSizeInBytes();
        }
        return sizeInBytes;
    }

    private void declarePositions(int positions) {
        this.declaredPositions += positions;
    }

    public boolean isFull() {
        if (this.declaredPositions == 0) {
            return false;
        }
        if (this.declaredPositions >= 32768) {
            return true;
        }
        PositionsAppenderSizeAccumulator accumulator = this.computeAppenderSizes();
        return accumulator.getSizeInBytes() >= (long)this.maxPageSizeInBytes || accumulator.getDirectSizeInBytes() >= (long)this.maxDirectPageSizeInBytes;
    }

    @VisibleForTesting
    PositionsAppenderSizeAccumulator computeAppenderSizes() {
        PositionsAppenderSizeAccumulator accumulator = new PositionsAppenderSizeAccumulator();
        for (UnnestingPositionsAppender positionsAppender : this.channelAppenders) {
            positionsAppender.addSizesToAccumulator(accumulator);
        }
        return accumulator;
    }

    public boolean isEmpty() {
        return this.declaredPositions == 0;
    }

    public Page build() {
        Block[] blocks = new Block[this.channelAppenders.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.channelAppenders[i].build();
            Preconditions.checkState((blocks[i].getPositionCount() == this.declaredPositions ? 1 : 0) != 0, (String)"Declared positions (%s) does not match block %s's number of entries (%s)", (Object)this.declaredPositions, (Object)i, (Object)blocks[i].getPositionCount());
        }
        Page page = new Page(this.declaredPositions, blocks);
        this.reset();
        return page;
    }

    private void reset() {
        this.declaredPositions = 0;
    }
}

