/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DuplicateMapKeyException;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.block.SqlMap;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;

public final class MapToMapCast
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapToMapCast.class, "mapCast", MethodHandle.class, MethodHandle.class, MapType.class, BlockTypeOperators.BlockPositionIsDistinctFrom.class, BlockTypeOperators.BlockPositionHashCode.class, ConnectorSession.class, SqlMap.class);
    private static final MethodHandle CHECK_LONG_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkLongIsNotNull", Long.class);
    private static final MethodHandle CHECK_DOUBLE_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkDoubleIsNotNull", Double.class);
    private static final MethodHandle CHECK_BOOLEAN_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkBooleanIsNotNull", Boolean.class);
    private static final MethodHandle CHECK_SLICE_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkSliceIsNotNull", Slice.class);
    private static final MethodHandle CHECK_BLOCK_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkBlockIsNotNull", Block.class);
    private static final MethodHandle WRITE_LONG = Reflection.methodHandle(Type.class, "writeLong", BlockBuilder.class, Long.TYPE);
    private static final MethodHandle WRITE_DOUBLE = Reflection.methodHandle(Type.class, "writeDouble", BlockBuilder.class, Double.TYPE);
    private static final MethodHandle WRITE_BOOLEAN = Reflection.methodHandle(Type.class, "writeBoolean", BlockBuilder.class, Boolean.TYPE);
    private static final MethodHandle WRITE_OBJECT = Reflection.methodHandle(Type.class, "writeObject", BlockBuilder.class, Object.class);
    private final BlockTypeOperators blockTypeOperators;

    public MapToMapCast(BlockTypeOperators blockTypeOperators) {
        super(FunctionMetadata.operatorBuilder((OperatorType)OperatorType.CAST).signature(Signature.builder().castableToTypeParameter("FK", new TypeSignature("TK", new TypeSignatureParameter[0])).castableToTypeParameter("FV", new TypeSignature("TV", new TypeSignatureParameter[0])).typeVariable("TK").typeVariable("TV").returnType(TypeSignature.mapType((TypeSignature)new TypeSignature("TK", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("TV", new TypeSignatureParameter[0]))).argumentType(TypeSignature.mapType((TypeSignature)new TypeSignature("FK", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("FV", new TypeSignatureParameter[0]))).build()).nullable().build());
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addCastSignature(new TypeSignature("FK", new TypeSignatureParameter[0]), new TypeSignature("TK", new TypeSignatureParameter[0])).addCastSignature(new TypeSignature("FV", new TypeSignatureParameter[0]), new TypeSignature("TV", new TypeSignatureParameter[0])).build();
    }

    @Override
    public SpecializedSqlScalarFunction specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Preconditions.checkArgument((boundSignature.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        MapType fromMapType = (MapType)boundSignature.getArgumentType(0);
        Type fromKeyType = fromMapType.getKeyType();
        Type fromValueType = fromMapType.getValueType();
        MapType toMapType = (MapType)boundSignature.getReturnType();
        Type toKeyType = toMapType.getKeyType();
        Type toValueType = toMapType.getValueType();
        MethodHandle keyProcessor = MapToMapCast.buildProcessor(functionDependencies, fromKeyType, toKeyType, true);
        MethodHandle valueProcessor = MapToMapCast.buildProcessor(functionDependencies, fromValueType, toValueType, false);
        BlockTypeOperators.BlockPositionIsDistinctFrom keyEqual = this.blockTypeOperators.getDistinctFromOperator(toKeyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(toKeyType);
        MethodHandle target = MethodHandles.insertArguments(METHOD_HANDLE, 0, keyProcessor, valueProcessor, toMapType, keyEqual, keyHashCode);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), target);
    }

    private static MethodHandle buildProcessor(FunctionDependencies functionDependencies, Type fromType, Type toType, boolean isKey) {
        FunctionNullability functionNullability = functionDependencies.getCastNullability(fromType, toType);
        InvocationConvention invocationConvention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), functionNullability.isReturnNullable() ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, false);
        MethodHandle cast = functionDependencies.getCastImplementation(fromType, toType, invocationConvention).getMethodHandle();
        if (cast.type().parameterArray()[0] != ConnectorSession.class) {
            cast = MethodHandles.dropArguments(cast, 0, new Class[]{ConnectorSession.class});
        }
        cast = MethodHandles.permuteArguments(cast, MethodType.methodType(cast.type().returnType(), Block.class, new Class[]{Integer.TYPE, ConnectorSession.class}), 2, 0, 1);
        if (isKey && functionNullability.isReturnNullable()) {
            MethodHandle target = MapToMapCast.nullChecker(cast.type().returnType());
            cast = MethodHandles.foldArguments(MethodHandles.dropArguments(target, 1, cast.type().parameterList()), cast);
        }
        MethodHandle writer = MapToMapCast.nativeValueWriter(toType);
        writer = MethodHandles.permuteArguments(writer, MethodType.methodType(Void.TYPE, writer.type().parameterArray()[1], BlockBuilder.class), 1, 0);
        cast = cast.asType(MethodType.methodType(writer.type().parameterType(0), cast.type().parameterArray()));
        return MethodHandles.foldArguments(MethodHandles.dropArguments(writer, 1, cast.type().parameterList()), cast);
    }

    private static MethodHandle nullChecker(Class<?> javaType) {
        if (javaType == Long.class) {
            return CHECK_LONG_IS_NOT_NULL;
        }
        if (javaType == Double.class) {
            return CHECK_DOUBLE_IS_NOT_NULL;
        }
        if (javaType == Boolean.class) {
            return CHECK_BOOLEAN_IS_NOT_NULL;
        }
        if (javaType == Slice.class) {
            return CHECK_SLICE_IS_NOT_NULL;
        }
        if (javaType == Block.class) {
            return CHECK_BLOCK_IS_NOT_NULL;
        }
        throw new IllegalArgumentException("Unknown java type " + javaType);
    }

    @UsedByGeneratedCode
    public static long checkLongIsNotNull(Long value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static double checkDoubleIsNotNull(Double value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static boolean checkBooleanIsNotNull(Boolean value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Slice checkSliceIsNotNull(Slice value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Block checkBlockIsNotNull(Block value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static SqlMap mapCast(MethodHandle keyProcessFunction, MethodHandle valueProcessFunction, MapType toType, BlockTypeOperators.BlockPositionIsDistinctFrom keyDistinctOperator, BlockTypeOperators.BlockPositionHashCode keyHashCode, ConnectorSession session, SqlMap fromMap) {
        int size = fromMap.getSize();
        int rawOffset = fromMap.getRawOffset();
        Block rawKeyBlock = fromMap.getRawKeyBlock();
        Block rawValueBlock = fromMap.getRawValueBlock();
        Type toKeyType = toType.getKeyType();
        BlockBuilder keyBlockBuilder = toKeyType.createBlockBuilder(null, size);
        for (int i = 0; i < size; ++i) {
            try {
                keyProcessFunction.invokeExact(rawKeyBlock, rawOffset + i, session, keyBlockBuilder);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        Block keyBlock = keyBlockBuilder.build();
        Type toValueType = toType.getValueType();
        BlockBuilder valueBlockBuilder = toValueType.createBlockBuilder(null, size);
        for (int i = 0; i < size; ++i) {
            if (rawValueBlock.isNull(rawOffset + i)) {
                valueBlockBuilder.appendNull();
                continue;
            }
            try {
                valueProcessFunction.invokeExact(rawValueBlock, rawOffset + i, session, valueBlockBuilder);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        Block valueBlock = valueBlockBuilder.build();
        try {
            return new SqlMap(toType, MapHashTables.HashBuildMode.STRICT_NOT_DISTINCT_FROM, keyBlock, valueBlock);
        }
        catch (DuplicateMapKeyException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "duplicate keys");
        }
    }

    private static MethodHandle nativeValueWriter(Type type) {
        MethodHandle methodHandle;
        Class javaType = type.getJavaType();
        if (javaType == Long.TYPE) {
            methodHandle = WRITE_LONG;
        } else if (javaType == Double.TYPE) {
            methodHandle = WRITE_DOUBLE;
        } else if (javaType == Boolean.TYPE) {
            methodHandle = WRITE_BOOLEAN;
        } else if (!javaType.isPrimitive()) {
            methodHandle = WRITE_OBJECT;
        } else {
            throw new IllegalArgumentException("Unknown java type " + javaType + " from type " + type);
        }
        return methodHandle.bindTo(type);
    }
}

