/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.remotetask;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.SpanBuilder;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStatus;
import io.trino.server.remotetask.DynamicFiltersFetcher;
import io.trino.server.remotetask.RemoteTaskStats;
import io.trino.server.remotetask.RequestErrorTracker;
import io.trino.server.remotetask.SimpleHttpResponseCallback;
import io.trino.server.remotetask.SimpleHttpResponseHandler;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;

class ContinuousTaskStatusFetcher {
    private static final Logger log = Logger.get(ContinuousTaskStatusFetcher.class);
    private final TaskId taskId;
    private final Consumer<Throwable> onFail;
    private final StateMachine<TaskStatus> taskStatus;
    private final JsonCodec<TaskStatus> taskStatusCodec;
    private final DynamicFiltersFetcher dynamicFiltersFetcher;
    private final Duration refreshMaxWait;
    private final Executor executor;
    private final HttpClient httpClient;
    private final Supplier<SpanBuilder> spanBuilderFactory;
    private final RequestErrorTracker errorTracker;
    private final RemoteTaskStats stats;
    @GuardedBy(value="this")
    private boolean running;
    @GuardedBy(value="this")
    private ListenableFuture<FullJsonResponseHandler.JsonResponse<TaskStatus>> future;

    public ContinuousTaskStatusFetcher(Consumer<Throwable> onFail, TaskStatus initialTaskStatus, Duration refreshMaxWait, JsonCodec<TaskStatus> taskStatusCodec, DynamicFiltersFetcher dynamicFiltersFetcher, Executor executor, HttpClient httpClient, Supplier<SpanBuilder> spanBuilderFactory, Duration maxErrorDuration, ScheduledExecutorService errorScheduledExecutor, RemoteTaskStats stats) {
        Objects.requireNonNull(initialTaskStatus, "initialTaskStatus is null");
        this.taskId = initialTaskStatus.getTaskId();
        this.onFail = Objects.requireNonNull(onFail, "onFail is null");
        this.taskStatus = new StateMachine<TaskStatus>("task-" + this.taskId, executor, initialTaskStatus);
        this.refreshMaxWait = Objects.requireNonNull(refreshMaxWait, "refreshMaxWait is null");
        this.taskStatusCodec = Objects.requireNonNull(taskStatusCodec, "taskStatusCodec is null");
        this.dynamicFiltersFetcher = Objects.requireNonNull(dynamicFiltersFetcher, "dynamicFiltersFetcher is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.spanBuilderFactory = Objects.requireNonNull(spanBuilderFactory, "spanBuilderFactory is null");
        this.errorTracker = new RequestErrorTracker(this.taskId, initialTaskStatus.getSelf(), maxErrorDuration, errorScheduledExecutor, "getting task status");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.scheduleNextRequest();
    }

    public synchronized void stop() {
        this.running = false;
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    private synchronized void scheduleNextRequest() {
        TaskStatus taskStatus = this.getTaskStatus();
        if (!this.running || taskStatus.getState().isDone()) {
            return;
        }
        if (this.future != null && !this.future.isDone()) {
            log.error("Cannot reschedule update because an update is already running");
            return;
        }
        ListenableFuture<Void> errorRateLimit = this.errorTracker.acquireRequestPermit();
        if (!errorRateLimit.isDone()) {
            errorRateLimit.addListener(this::scheduleNextRequest, this.executor);
            return;
        }
        Request request = Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)taskStatus.getSelf()).appendPath("status").build()).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setHeader("X-Trino-Current-Version", Long.toString(taskStatus.getVersion())).setHeader("X-Trino-Max-Wait", this.refreshMaxWait.toString()).setSpanBuilder(this.spanBuilderFactory.get()).build();
        this.errorTracker.startRequest();
        this.future = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(this.taskStatusCodec));
        Futures.addCallback(this.future, new SimpleHttpResponseHandler<TaskStatus>(new TaskStatusResponseCallback(), request.getUri(), this.stats), (Executor)this.executor);
    }

    TaskStatus getTaskStatus() {
        return this.taskStatus.get();
    }

    private synchronized void cleanupRequest() {
        if (this.future != null && this.future.isDone()) {
            this.future = null;
        }
    }

    void updateTaskStatus(TaskStatus newValue) {
        AtomicBoolean taskMismatch = new AtomicBoolean();
        this.taskStatus.setIf(newValue, oldValue -> {
            if (!Strings.isNullOrEmpty((String)oldValue.getTaskInstanceId()) && !oldValue.getTaskInstanceId().equals(newValue.getTaskInstanceId())) {
                taskMismatch.set(true);
                return false;
            }
            if (oldValue.getState().isDone()) {
                return false;
            }
            return newValue.getVersion() >= oldValue.getVersion();
        });
        if (taskMismatch.get()) {
            this.onFail.accept((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_MISMATCH, String.format("%s (%s)", "Could not communicate with the remote task. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", HostAddress.fromUri((URI)this.getTaskStatus().getSelf()))));
        }
        this.dynamicFiltersFetcher.updateDynamicFiltersVersionAndFetchIfNecessary(newValue.getDynamicFiltersVersion());
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<TaskStatus> stateChangeListener) {
        this.taskStatus.addStateChangeListener(stateChangeListener);
    }

    private void updateStats(long currentRequestStartNanos) {
        this.stats.statusRoundTripMillis(Duration.nanosSince((long)currentRequestStartNanos).toMillis());
    }

    private class TaskStatusResponseCallback
    implements SimpleHttpResponseCallback<TaskStatus> {
        private final long requestStartNanos = System.nanoTime();

        private TaskStatusResponseCallback() {
        }

        @Override
        public void success(TaskStatus value) {
            try (SetThreadName ignored = new SetThreadName("ContinuousTaskStatusFetcher-%s", new Object[]{ContinuousTaskStatusFetcher.this.taskId});){
                ContinuousTaskStatusFetcher.this.updateStats(this.requestStartNanos);
                try {
                    ContinuousTaskStatusFetcher.this.updateTaskStatus(value);
                    ContinuousTaskStatusFetcher.this.errorTracker.requestSucceeded();
                }
                finally {
                    ContinuousTaskStatusFetcher.this.cleanupRequest();
                    ContinuousTaskStatusFetcher.this.scheduleNextRequest();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable cause) {
            try (SetThreadName ignored = new SetThreadName("ContinuousTaskStatusFetcher-%s", new Object[]{ContinuousTaskStatusFetcher.this.taskId});){
                ContinuousTaskStatusFetcher.this.updateStats(this.requestStartNanos);
                try {
                    TaskStatus taskStatus = ContinuousTaskStatusFetcher.this.getTaskStatus();
                    if (!taskStatus.getState().isDone()) {
                        ContinuousTaskStatusFetcher.this.errorTracker.requestFailed(cause);
                    }
                }
                catch (Error e) {
                    ContinuousTaskStatusFetcher.this.onFail.accept(e);
                    throw e;
                }
                catch (RuntimeException e) {
                    ContinuousTaskStatusFetcher.this.onFail.accept(e);
                }
                finally {
                    ContinuousTaskStatusFetcher.this.cleanupRequest();
                    ContinuousTaskStatusFetcher.this.scheduleNextRequest();
                }
            }
        }

        @Override
        public void fatal(Throwable cause) {
            try (SetThreadName ignored = new SetThreadName("ContinuousTaskStatusFetcher-%s", new Object[]{ContinuousTaskStatusFetcher.this.taskId});){
                ContinuousTaskStatusFetcher.this.updateStats(this.requestStartNanos);
                ContinuousTaskStatusFetcher.this.onFail.accept(cause);
            }
        }
    }
}

