/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.FunctionResolver;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.Objects;

public class PlannerContext {
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final BlockEncodingSerde blockEncodingSerde;
    private final TypeManager typeManager;
    private final FunctionManager functionManager;
    private final LanguageFunctionManager languageFunctionManager;
    private final Tracer tracer;
    private final ResolvedFunction.ResolvedFunctionDecoder functionDecoder;

    @Inject
    public PlannerContext(Metadata metadata, TypeOperators typeOperators, BlockEncodingSerde blockEncodingSerde, TypeManager typeManager, FunctionManager functionManager, LanguageFunctionManager languageFunctionManager, Tracer tracer) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.languageFunctionManager = Objects.requireNonNull(languageFunctionManager, "languageFunctionManager is null");
        this.functionDecoder = new ResolvedFunction.ResolvedFunctionDecoder(arg_0 -> ((TypeManager)typeManager).getType(arg_0));
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public TypeOperators getTypeOperators() {
        return this.typeOperators;
    }

    public BlockEncodingSerde getBlockEncodingSerde() {
        return this.blockEncodingSerde;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public ResolvedFunction.ResolvedFunctionDecoder getFunctionDecoder() {
        return this.functionDecoder;
    }

    public FunctionResolver getFunctionResolver() {
        return this.getFunctionResolver(WarningCollector.NOOP);
    }

    public FunctionResolver getFunctionResolver(WarningCollector warningCollector) {
        return new FunctionResolver(this.metadata, this.typeManager, this.languageFunctionManager, this.functionDecoder, warningCollector);
    }

    public LanguageFunctionManager getLanguageFunctionManager() {
        return this.languageFunctionManager;
    }

    public Tracer getTracer() {
        return this.tracer;
    }
}

