/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.Immutable;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    @Nullable
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    @Nullable
    private final Optional<PlanNodeStatsEstimate> statistics;
    private final boolean updateTarget;
    private final Optional<Boolean> useConnectorNodePartitioning;

    @Deprecated
    public static TableScanNode newInstance(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, boolean updateTarget, Optional<Boolean> useConnectorNodePartitioning) {
        return new TableScanNode(id, table, outputs, assignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), updateTarget, useConnectorNodePartitioning);
    }

    @JsonCreator
    @DoNotCall
    public static TableScanNode fromJson(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputSymbols") List<Symbol> outputs, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="updateTarget") boolean updateTarget, @JsonProperty(value="useConnectorNodePartitioning") Optional<Boolean> useConnectorNodePartitioning) {
        return new TableScanNode(id, table, outputs, assignments, updateTarget, useConnectorNodePartitioning);
    }

    private TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, boolean updateTarget, Optional<Boolean> useConnectorNodePartitioning) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputs), (Object)"assignments does not cover all of outputs");
        this.enforcedConstraint = null;
        this.statistics = null;
        this.updateTarget = updateTarget;
        this.useConnectorNodePartitioning = Objects.requireNonNull(useConnectorNodePartitioning, "useConnectorNodePartitioning is null");
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, TupleDomain<ColumnHandle> enforcedConstraint, Optional<PlanNodeStatsEstimate> statistics, boolean updateTarget, Optional<Boolean> useConnectorNodePartitioning) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputs), (Object)"assignments does not cover all of outputs");
        Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        TableScanNode.validateEnforcedConstraint(enforcedConstraint, outputs, assignments);
        this.enforcedConstraint = enforcedConstraint;
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
        this.updateTarget = updateTarget;
        this.useConnectorNodePartitioning = Objects.requireNonNull(useConnectorNodePartitioning, "useConnectorNodePartitioning is null");
    }

    private static void validateEnforcedConstraint(TupleDomain<ColumnHandle> enforcedConstraint, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments) {
        if (enforcedConstraint.isAll() || enforcedConstraint.isNone()) {
            return;
        }
        Map domains = (Map)enforcedConstraint.getDomains().orElseThrow();
        Set visibleColumns = (Set)outputs.stream().map(assignments::get).map(Objects::requireNonNull).collect(ImmutableSet.toImmutableSet());
        domains.keySet().stream().filter(column -> !visibleColumns.contains(column)).findAny().ifPresent(column -> {
            throw new IllegalArgumentException(String.format("enforcedConstraint references a column that is not part of the plan. enforcedConstraint keys: %s, visibleColumns: %s", domains.keySet(), visibleColumns));
        });
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonIgnore
    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        Preconditions.checkState((this.enforcedConstraint != null ? 1 : 0) != 0, (Object)"enforcedConstraint should only be used in planner. It is not transported to workers.");
        return this.enforcedConstraint;
    }

    @JsonIgnore
    public Optional<PlanNodeStatsEstimate> getStatistics() {
        Preconditions.checkState((this.statistics != null ? 1 : 0) != 0, (Object)"statistics should only be used in planner. It is not transported to workers.");
        return this.statistics;
    }

    @JsonProperty(value="updateTarget")
    public boolean isUpdateTarget() {
        return this.updateTarget;
    }

    @JsonProperty(value="useConnectorNodePartitioning")
    public Optional<Boolean> getUseConnectorNodePartitioning() {
        return this.useConnectorNodePartitioning;
    }

    public boolean isUseConnectorNodePartitioning() {
        return this.useConnectorNodePartitioning.orElseThrow(() -> new VerifyException("useConnectorNodePartitioning is not present"));
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("outputSymbols", this.outputSymbols).add("assignments", this.assignments).add("enforcedConstraint", this.enforcedConstraint).add("updateTarget", this.updateTarget).toString();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }

    public TableScanNode withUseConnectorNodePartitioning(boolean useConnectorNodePartitioning) {
        return new TableScanNode(this.getId(), this.table, this.outputSymbols, this.assignments, this.enforcedConstraint, this.statistics, this.updateTarget, Optional.of(useConnectorNodePartitioning));
    }

    public TableScanNode withTableHandle(TableHandle table) {
        return new TableScanNode(this.getId(), table, this.outputSymbols, this.assignments, this.enforcedConstraint, this.statistics, this.updateTarget, this.useConnectorNodePartitioning);
    }
}

