/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.StageInfo;
import io.trino.execution.TaskInfo;
import io.trino.operator.OperatorInfo;
import io.trino.operator.OperatorStats;
import io.trino.operator.PipelineStats;
import io.trino.operator.TaskStats;
import io.trino.operator.WindowInfo;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.planprinter.BasicOperatorStats;
import io.trino.sql.planner.planprinter.PlanNodeStats;
import io.trino.sql.planner.planprinter.WindowOperatorStats;
import io.trino.sql.planner.planprinter.WindowPlanNodeStats;
import io.trino.util.MoreMaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class PlanNodeStatsSummarizer {
    private PlanNodeStatsSummarizer() {
    }

    public static Map<PlanNodeId, PlanNodeStats> aggregateStageStats(List<StageInfo> stageInfos) {
        return PlanNodeStatsSummarizer.aggregateTaskStats(stageInfos.stream().flatMap(s -> s.getTasks().stream()).collect(Collectors.toList()));
    }

    public static Map<PlanNodeId, PlanNodeStats> aggregateTaskStats(List<TaskInfo> taskInfos) {
        ArrayListMultimap groupedStats = ArrayListMultimap.create();
        List planNodeStats = taskInfos.stream().map(TaskInfo::getStats).flatMap(taskStats -> PlanNodeStatsSummarizer.getPlanNodeStats(taskStats).stream()).collect(Collectors.toList());
        for (PlanNodeStats stats : planNodeStats) {
            groupedStats.put((Object)stats.getPlanNodeId(), (Object)stats);
        }
        ImmutableMap.Builder aggregatedStatsBuilder = ImmutableMap.builder();
        for (PlanNodeId planNodeId : groupedStats.keySet()) {
            List groupedPlanNodeStats = groupedStats.get((Object)planNodeId);
            aggregatedStatsBuilder.put((Object)planNodeId, ((PlanNodeStats)groupedPlanNodeStats.get(0)).mergeWith(groupedPlanNodeStats.subList(1, groupedPlanNodeStats.size())));
        }
        return aggregatedStatsBuilder.buildOrThrow();
    }

    private static List<PlanNodeStats> getPlanNodeStats(TaskStats taskStats) {
        HashSet<PlanNodeId> planNodeIds = new HashSet<PlanNodeId>();
        HashMap<PlanNodeId, Long> planNodeInputPositions = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeInputBytes = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeOutputPositions = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeOutputBytes = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeSpilledDataSize = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeScheduledMillis = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodeCpuMillis = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> planNodePhysicalInputDataSize = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Double> planNodePhysicalInputReadNanos = new HashMap<PlanNodeId, Double>();
        HashMap<PlanNodeId, Long> planNodeBlockedMillis = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Map> basicOperatorStats = new HashMap<PlanNodeId, Map>();
        HashMap<PlanNodeId, WindowOperatorStats> windowNodeStats = new HashMap<PlanNodeId, WindowOperatorStats>();
        for (PipelineStats pipelineStats : taskStats.getPipelines()) {
            PlanNodeId planNodeId;
            if (pipelineStats.getOperatorSummaries().isEmpty()) continue;
            HashSet<PlanNodeId> processedNodes = new HashSet<PlanNodeId>();
            PlanNodeId inputPlanNode = pipelineStats.getOperatorSummaries().iterator().next().getPlanNodeId();
            PlanNodeId outputPlanNode = ((OperatorStats)Iterables.getLast(pipelineStats.getOperatorSummaries())).getPlanNodeId();
            for (OperatorStats operatorStats : pipelineStats.getOperatorSummaries()) {
                planNodeId = operatorStats.getPlanNodeId();
                planNodeIds.add(planNodeId);
                long scheduledMillis = operatorStats.getAddInputWall().toMillis() + operatorStats.getGetOutputWall().toMillis() + operatorStats.getFinishWall().toMillis();
                planNodeScheduledMillis.merge(planNodeId, scheduledMillis, Long::sum);
                long cpuMillis = operatorStats.getAddInputCpu().toMillis() + operatorStats.getGetOutputCpu().toMillis() + operatorStats.getFinishCpu().toMillis();
                planNodeCpuMillis.merge(planNodeId, cpuMillis, Long::sum);
                planNodeBlockedMillis.merge(planNodeId, operatorStats.getBlockedWall().toMillis(), Long::sum);
                planNodeSpilledDataSize.merge(planNodeId, operatorStats.getSpilledDataSize().toBytes(), Long::sum);
                planNodePhysicalInputDataSize.merge(planNodeId, operatorStats.getPhysicalInputDataSize().toBytes(), Long::sum);
                planNodePhysicalInputReadNanos.merge(planNodeId, operatorStats.getPhysicalInputReadTime().getValue(TimeUnit.NANOSECONDS), Double::sum);
                if (operatorStats.getPlanNodeId().equals(inputPlanNode) && !pipelineStats.isInputPipeline() || operatorStats.getOperatorType().equals("DynamicFilterSourceOperator") || processedNodes.contains(planNodeId)) continue;
                basicOperatorStats.merge(planNodeId, (Map)ImmutableMap.of((Object)operatorStats.getOperatorType(), (Object)new BasicOperatorStats(operatorStats.getTotalDrivers(), operatorStats.getInputPositions(), operatorStats.getSumSquaredInputPositions(), operatorStats.getMetrics(), operatorStats.getConnectorMetrics())), (map1, map2) -> MoreMaps.mergeMaps(map1, map2, BasicOperatorStats::merge));
                planNodeInputPositions.merge(planNodeId, operatorStats.getInputPositions(), Long::sum);
                planNodeInputBytes.merge(planNodeId, operatorStats.getInputDataSize().toBytes(), Long::sum);
                processedNodes.add(planNodeId);
            }
            processedNodes.clear();
            for (OperatorStats operatorStats : Lists.reverse(pipelineStats.getOperatorSummaries())) {
                planNodeId = operatorStats.getPlanNodeId();
                if (operatorStats.getPlanNodeId().equals(outputPlanNode) && !pipelineStats.isOutputPipeline() || processedNodes.contains(planNodeId)) continue;
                planNodeOutputPositions.merge(planNodeId, operatorStats.getOutputPositions(), Long::sum);
                planNodeOutputBytes.merge(planNodeId, operatorStats.getOutputDataSize().toBytes(), Long::sum);
                processedNodes.add(planNodeId);
            }
            for (OperatorStats operatorStats : pipelineStats.getOperatorSummaries()) {
                planNodeId = operatorStats.getPlanNodeId();
                OperatorInfo operatorInfo = operatorStats.getInfo();
                if (!(operatorInfo instanceof WindowInfo)) continue;
                WindowInfo windowInfo = (WindowInfo)operatorInfo;
                windowNodeStats.merge(planNodeId, WindowOperatorStats.create(windowInfo), WindowOperatorStats::mergeWith);
            }
        }
        ArrayList<PlanNodeStats> stats = new ArrayList<PlanNodeStats>();
        for (PlanNodeId planNodeId : planNodeIds) {
            if (!planNodeInputPositions.containsKey(planNodeId)) continue;
            long outputPositions = planNodeOutputPositions.getOrDefault(planNodeId, 0L);
            PlanNodeStats nodeStats = windowNodeStats.containsKey(planNodeId) ? new WindowPlanNodeStats(planNodeId, new Duration((double)((Long)planNodeScheduledMillis.get(planNodeId)).longValue(), TimeUnit.MILLISECONDS), new Duration((double)((Long)planNodeCpuMillis.get(planNodeId)).longValue(), TimeUnit.MILLISECONDS), new Duration((double)((Long)planNodeBlockedMillis.get(planNodeId)).longValue(), TimeUnit.MILLISECONDS), (Long)planNodeInputPositions.get(planNodeId), DataSize.succinctBytes((long)((Long)planNodeInputBytes.get(planNodeId))), outputPositions, DataSize.succinctBytes((long)planNodeOutputBytes.getOrDefault(planNodeId, 0L)), DataSize.succinctBytes((long)((Long)planNodeSpilledDataSize.get(planNodeId))), (Map)basicOperatorStats.get(planNodeId), (WindowOperatorStats)windowNodeStats.get(planNodeId)) : new PlanNodeStats(planNodeId, new Duration((double)((Long)planNodeScheduledMillis.get(planNodeId)).longValue(), TimeUnit.MILLISECONDS), new Duration((double)((Long)planNodeCpuMillis.get(planNodeId)).longValue(), TimeUnit.MILLISECONDS), new Duration((double)((Long)planNodeBlockedMillis.get(planNodeId)).longValue(), TimeUnit.MILLISECONDS), (Long)planNodeInputPositions.get(planNodeId), DataSize.succinctBytes((long)((Long)planNodeInputBytes.get(planNodeId))), DataSize.succinctBytes((long)planNodePhysicalInputDataSize.getOrDefault(planNodeId, 0L)), new Duration(planNodePhysicalInputReadNanos.getOrDefault(planNodeId, 0.0).doubleValue(), TimeUnit.NANOSECONDS), outputPositions, DataSize.succinctBytes((long)planNodeOutputBytes.getOrDefault(planNodeId, 0L)), DataSize.succinctBytes((long)((Long)planNodeSpilledDataSize.get(planNodeId))), (Map)basicOperatorStats.get(planNodeId));
            stats.add(nodeStats);
        }
        return stats;
    }
}

